grammar LexML;
options {    
    output=AST;
    ASTLabelType=CommonTree; // type of $stat.tree ref etc...
}
tokens {

LexML; 	FLexML;
Projeto;	FProjeto;
Norma;	FNorma;
ParteInicial;	FParteInicial;
Epigrafe; 	FEpigrafe;
Ementa; 	FEmenta;
Preambulo; 	FPreambulo;
Articulacao; 	FArticulacao;
Parte;	FParte;
Livro;	FLivro;
Titulo;	FTitulo;
Capitulo;	FCapitulo;
Secao;	FSecao;
Subsecao;	FSubsecao;
Artigo;	FArtigo;
Caput;	FCaput;
Inciso;	FInciso;
Alinea;	FAlinea;
Item;	FItem;
Pena;	FPena;
Paragrafo;	FParagrafo;
ParteFinal;	FParteFinal;
LocalData;	FLocalData;
Fecho;	FFecho;
Assinaturas;	FAssinaturas;
Assinatura;	FAssinatura;
Justificacao;  FJustificacao;
PartePrincipal; FPartePrincipal;
P;	FP;
MetadadoNorma; MetadadoProjeto;
Dummy;

}


lexml 	: (parteInicial articulacao parteFinal) 
	   => parteInicial articulacao parteFinal
	    -> 
	    ^(LexML MetadadoNorma 
	     Norma parteInicial articulacao parteFinal FNorma 
	     FLexML) 
	  | parteInicial articulacao justificacao -> 
	    ^(LexML MetadadoProjeto 
	     Projeto Norma parteInicial articulacao FNorma justificacao FProjeto  
	     FLexML) 
	     ;
parteInicial 	: epigrafe ementa preambulo ->
	    ^(ParteInicial epigrafe ementa preambulo FParteInicial) ;
epigrafe 	: EPIGRAFEROT linha  NEWLINE+ ->
	    ^(Epigrafe EPIGRAFEROT linha FEpigrafe) ; 
ementa	: linha NEWLINE+ -> 
	    ^(Ementa linha FEmenta);
preambulo	: linha NEWLINE+ ->
	    ^(Preambulo linha FPreambulo); 
articulacao 	: (parte+ | livro+ | titulo+ | capitulo+ | secao+ | artigo+)  -> 
                   ^(Articulacao parte* livro* titulo* capitulo* secao* artigo* FArticulacao);

parte	: PARTEROT     WS PALAVRA      COMPLEMENTO?                                 NEWLINE artigo* livro*    ->
	    ^(Parte    PARTEROT PALAVRA COMPLEMENTO?         Dummy       artigo* livro*    FParte);
livro	: LIVROROT     WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE artigo* titulo*   ->
	    ^(Livro    LIVROROT    NUMEROROMANO COMPLEMENTO? Dummy frase artigo* titulo*   FLivro);
titulo	: TITULOROT    WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE artigo* capitulo* ->
	    ^(Titulo   TITULOROT   NUMEROROMANO COMPLEMENTO? Dummy frase artigo* capitulo* FTitulo);
capitulo	: CAPITULOROT  WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE artigo* secao*     ->
	    ^(Capitulo CAPITULOROT NUMEROROMANO COMPLEMENTO? Dummy frase artigo* secao*    FCapitulo);
secao	: SECAOROT     WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE artigo* subsecao* ->
	    ^(Secao    SECAOROT    NUMEROROMANO COMPLEMENTO? Dummy frase artigo* subsecao* FSecao);
subsecao	: SUBSECAOROT  WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE artigo+           ->
	    ^(Subsecao SUBSECAOROT NUMEROROMANO COMPLEMENTO? Dummy frase artigo* FSubsecao);
	    
artigo	: ARTROT WS NUMERO ORDINAL? COMPLEMENTO? PONTO? caput paragrafo* ->
       	    ^(Artigo ARTROT NUMERO? ORDINAL? COMPLEMENTO? PONTO? Dummy caput paragrafo* FArtigo);
       	    
caput	: WS linha NEWLINE+ inciso* pena? ->
       	    ^(Caput linha inciso* pena? FCaput);
paragrafo	: PARROT       NUMERO? ORDINAL? COMPLEMENTO? PONTO? WS linha NEWLINE inciso* pena?  ->
                   ^(Paragrafo PARROT NUMERO? ORDINAL? COMPLEMENTO? PONTO? Dummy linha inciso* pena?  FParagrafo);
inciso	: NUMEROROMANO COMPLEMENTO? WS HIFEN                WS linha NEWLINE alinea* ->
                   ^(Inciso NUMEROROMANO COMPLEMENTO? HIFEN Dummy linha alinea* FInciso);
alinea	: LETRAALINEA  COMPLEMENTO? FECHAPARENTESE          WS linha NEWLINE item* ->
                   ^(Alinea LETRAALINEA COMPLEMENTO? FECHAPARENTESE Dummy linha item* FAlinea);
item	: NUMEROITEM COMPLEMENTO? PONTO                     WS linha NEWLINE ->
                   ^(Item NUMEROITEM COMPLEMENTO? PONTO Dummy linha FItem);
pena	: PENAROT    WS HIFEN                               WS linha NEWLINE ->
	    ^(Pena HIFEN linha FPena);
                   
parteFinal	: localData assinaturas ->
                   ^(ParteFinal localData assinaturas FParteFinal);
localData 	: LOCAL linha NEWLINE+ ->
                   ^(LocalData LOCAL linha FLocalData );
assinaturas    : assinatura+ ->
                   ^(Assinaturas assinatura+ FAssinaturas); 
assinatura 	: linha NEWLINE+ ->
                   ^(Assinatura linha+ FAssinatura);
justificacao 	: JUSTIFICAROT linha? NEWLINE+ texto+ ->
	    ^(Justificacao PartePrincipal P JUSTIFICAROT linha? FP texto* FPartePrincipal FJustificacao);                  
texto 	: linha NEWLINE+ ->
	    ^(P linha FP);	    
                   
frase	: atomoSimples+;
linha 	: atomo+;
// Se alterar atomo ou atomoSimples, lembrar de alterar em GeraXML.g
atomo 	: NUMERO | PALAVRA | ORDINAL | WS | HIFEN 
	| NUMEROROMANO |  ABREPARENTESE | FECHAPARENTESE 
	|  SIMBOLOS | VIRGULA | COMPLEMENTO 
	| PONTUACAO | PONTO  ;
atomoSimples 	: NUMERO | PALAVRA | ORDINAL | WS | HIFEN 
	| NUMEROROMANO | ABREPARENTESE | FECHAPARENTESE 
	| SIMBOLOS | VIRGULA | COMPLEMENTO;

NEWLINE 	: WS* ('\r'? '\n' WS*)+;
WS 	: (' '|'\t')+;	
HIFEN          : '-';
ARTROT	: {getCharPositionInLine()==0}? 
	  'Art.'
	| 'Art.' {$type = PALAVRA;}
	;
PARROT	: {getCharPositionInLine()==0}? 
	  (' '|'Pargrafo nico.'|'Pargrafo nico.')
	| (' '|'Pargrafo nico'|'Pargrafo nico'|'') {$type = PALAVRA;}
	;
NUMEROROMANO  	: ('I'|'V'|'X'|'L'|'C')+
	;
LOCAL 	: {getCharPositionInLine()==0}? 
	  ('Braslia,'|'BRASLIA,')
	| ('Braslia,'|'BRASLIA,') {$type = PALAVRA;}
	;
EPIGRAFEROT   : {getCharPositionInLine()==0}? 
	  ('Lei'|'LEI'|'Constituio') 
	| ('Lei'|'LEI'|'Constituio') {$type = PALAVRA;}
	| {getCharPositionInLine()==0}? 
	  ('Projeto'|'PROJETO')
	| ('Projeto'|'PROJETO') {$type = PALAVRA;}
	;
TITULOROT	: {getCharPositionInLine()==0}? 
	  ('Ttulo'|'TTULO')
	| ('Ttulo'|'TTULO') {$type = PALAVRA;}
	;
CAPITULOROT	: {getCharPositionInLine()==0}? 
	  ('Captulo'|'CAPTULO')
	| ('Captulo'|'CAPTULO') {$type = PALAVRA;}
	;
SECAOROT	: {getCharPositionInLine()==0}? 
	  ('Seo'|'SEO')
	| ('Seo'|'SEO') {$type = PALAVRA;}
	;
SUBSECAOROT	: {getCharPositionInLine()==0}? 
	  ('Subseo'|'SUBSEO')
	| ('Subseo'|'SUBSEO') {$type = PALAVRA;}
	;
PARTEROT	: {getCharPositionInLine()==0}?
	  ('Parte'|'PARTE')
	| ('Parte'|'PARTE') {$type = PALAVRA;}
	;
LIVROROT	: {getCharPositionInLine()==0}? 
	  ('Livro'|'LIVRO')
	| ('Livro'|'LIVRO') {$type = PALAVRA;}
	;
PENAROT	: {getCharPositionInLine()==0}? 
	  'Pena'
	| 'Pena' {$type = PALAVRA;}
	;
JUSTIFICAROT	: {getCharPositionInLine()==0}? 
	  ('Justificao'|'Justificaao')
	| ('Justificao'|'Justificaao') {$type = PALAVRA;}
	;
COMPLEMENTO    : ('-'('A'..'Z'))+;
ABREPARENTESE  : '(';
FECHAPARENTESE : ')';	
PONTUACAO 	: (';'|':');
VIRGULA	: ',';
PONTO	: '.';
SIMBOLOS 	: ('%'|'$'|'*'|'/'|'!'|'@'|'#'|'&'|''|''|'"'|'+'|'<'|'>'|'?'|'['|']'|'_'|'{'|'}'); 
NUMEROITEM 	: {getCharPositionInLine()==0}?
	   ('0'..'9')+  
	|  ('0'..'9')+ {$type=NUMERO;} 
	;
NUMERO 	: ('0'..'9')+;
ORDINAL	: (''|'');
LETRAALINEA	: {getCharPositionInLine()==0}? 
	  ('a'..'z')+
	| ('a'..'z')+ {$type=PALAVRA;}
	;
PALAVRA	: ('a'..'z'|'A'..'Z'|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|'\'')+;

