import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import org.antlr.stringtemplate.*;
import org.antlr.stringtemplate.language.*;


import java.io.*;

public class PipeLexML {


	public static StringTemplateGroup templates;
    public static void main(String args[]) throws Exception {

	
		if (args.length < 1) {
			System.out.println("Use: java PipeLexml NomeArq.txt");
			return;
		}
		
		//arquivo de entrada
		FileInputStream fstream = new  FileInputStream(args[0]);

        // Filtro de Normalizao (correo de erros, uniformizao de espaos etc)
		ANTLRInputStream input = new ANTLRInputStream(fstream);
		NormalizaLexer lexFiltro = new NormalizaLexer(input);
		TokenStream tokensFiltro = new CommonTokenStream(lexFiltro);
		System.err.println("Fase Normalizao - OK");
		
		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_Normal.txt")));	
		System.out.println(tokensFiltro.toString());

		
        // Parser do Texto Normalizado e criao de rvore em Memria
        LexMLLexer lexer = new LexMLLexer(new ANTLRStringStream(tokensFiltro.toString()));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
        LexMLParser parser = new LexMLParser(tokens);
        LexMLParser.lexml_return r = parser.lexml();      // parse rule s
		System.err.println("Fase Parser - OK");

		// arquivo de sada (bsico)
		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_LexML.xml"), true, "UTF-8"));	

        // Passeio na rvore, externalizando o XML
        CommonTree t = (CommonTree)r.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(t);
        nodes.setTokenStream(tokens);
        GeraXML walker = new GeraXML(nodes); // cria a rvore Walker
        //walker.setTemplateLib(templates); // where to find templates
        GeraXML.lexml_return r2 = walker.lexml();
		System.err.println("Fase Gerao do LexXML - OK");

		ANTLRInputStream xml = new ANTLRInputStream(new FileInputStream(new File(args[0]+"_LexML.xml")), "UTF-8");

		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_LexML_lang.xml"), true, "UTF-8"));	
		LinguisticoLexer lexFiltroLinguistico = new LinguisticoLexer(xml);
		TokenStream tokensFiltroLinguistico = new CommonTokenStream(lexFiltroLinguistico);
		System.out.println(tokensFiltroLinguistico.toString());
		System.err.println("Fase Linguistica - OK");
		

    }
	

}
