import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.HashMap;

public class UtilLexML {

    public static void MontaTagERotulo(HashMap memoria, String tipo, String numero) {
	    if (tipo.equals("Parte")) {
		    String complemento = "";
			if (memoria.get("cmpPRT") == null) {
				memoria.put("cmpPRT",complemento);
			} else {
			    complemento = (String)memoria.get("cmpPRT");
			}
		    zeraAbaixo(memoria, "Parte");
		    int i = 1;
		    while (memoria.get("prt"+i+complemento) != null) {
		      i = i + 1;
		    }
		    memoria.put("prtID", "prt"+i+complemento);
		    memoria.put("seqPRT", ""+i);
		    //apenas no caso de parte, eh gerado o TextoSimples e no eh chamada a rotina de montar ID
		    System.out.println("        <Parte id=\""+memoria.get("prtID")+"\" seqOrdem=\""+memoria.get("seqPRT")+"\" ><Rotulo>PARTE</Rotulo><TextoSimples>"+numero+(String)memoria.get("cmpPRT")+"</TextoSimples>");
		} else if (tipo.equals("Livro")) {
		    String complemento = "";
			if (memoria.get("cmpLIV") == null) {
				memoria.put("cmpLIV",complemento);
			} else {
			    complemento = (String)memoria.get("cmpLIV");
			}
		    zeraAbaixo(memoria, "Livro");
		    memoria.put("livID", "liv"+converteNumeroRomanoParaDecimal(numero)+complemento);
			TrataSeqOrdem(memoria, "LIV");
		    System.out.print("          <Livro id=\""+pegaID(memoria, "Livro", (String)memoria.get("livID"))+"\" seqOrdem=\""+memoria.get("seqLIV")+"\" ><Rotulo>LIVRO "+numero+(String)memoria.get("cmpLIV")+"</Rotulo><TextoSimples>");
		} else if (tipo.equals("Ttulo")) {
		    String complemento = "";
			if (memoria.get("cmpTIT") == null) {
				memoria.put("cmpTIT",complemento);
			} else {
			    complemento = (String)memoria.get("cmpTIT");
			}
		    zeraAbaixo(memoria, "Ttulo");
			TrataSeqOrdem(memoria, "TIT");
		    memoria.put("titID", "tit"+converteNumeroRomanoParaDecimal(numero)+complemento);
		    System.out.print("            <Titulo id=\""+pegaID(memoria, "Ttulo", (String)memoria.get("titID"))+"\"  seqOrdem=\""+memoria.get("seqTIT")+"\"  ><Rotulo>TTULO "+numero+(String)memoria.get("cmpTIT")+"</Rotulo><TextoSimples>");
		} else if (tipo.equals("Captulo")) {
		    String complemento = "";
			if (memoria.get("cmpCAP") == null) {
				memoria.put("cmpCAP",complemento);
			} else {
			    complemento = (String)memoria.get("cmpCAP");
			}
		    zeraAbaixo(memoria, "Captulo");
			TrataSeqOrdem(memoria, "CAP");
		    memoria.put("capID", "cap"+converteNumeroRomanoParaDecimal(numero)+complemento);
		    System.out.print("              <Capitulo id=\""+pegaID(memoria, "Captulo", (String)memoria.get("capID"))+"\"  seqOrdem=\""+memoria.get("seqCAP")+"\"  ><Rotulo>CAPTULO "+numero+(String)memoria.get("cmpCAP")+"</Rotulo><TextoSimples>");
		} else if (tipo.equals("Seo")) {
		    String complemento = "";
			if (memoria.get("cmpSEC") == null) {
				memoria.put("cmpSEC",complemento);
			} else {
			    complemento = (String)memoria.get("cmpSEC");
			}
		    zeraAbaixo(memoria, "Seo");
			TrataSeqOrdem(memoria, "SEC");
		    memoria.put("secID", "sec"+converteNumeroRomanoParaDecimal(numero)+complemento);
		    System.out.print("              <Secao id=\""+pegaID(memoria, "Seo", (String)memoria.get("secID"))+"\"  seqOrdem=\""+memoria.get("seqSEC")+"\" ><Rotulo>Seo "+numero+(String)memoria.get("cmpSEC")+"</Rotulo><TextoSimples>");
		} else if (tipo.equals("Subseo")) {
		    String complemento = "";
			if (memoria.get("cmpSUB") == null) {
				memoria.put("cmpSUB",complemento);
			} else {
			    complemento = (String)memoria.get("cmpSUB");
			}
		    zeraAbaixo(memoria, "Subseo");
			TrataSeqOrdem(memoria, "SUB");
		    memoria.put("subID", "sub"+converteNumeroRomanoParaDecimal(numero)+complemento);
		    System.out.print("              <Subsecao id=\""+pegaID(memoria, "Subseo", (String)memoria.get("subID"))+"\"   seqOrdem=\""+memoria.get("seqSUB")+"\" ><Rotulo>Subseo "+numero+(String)memoria.get("cmpSUB")+"</Rotulo><TextoSimples>");
		} else if (tipo.equals("Artigo")) {
		    String complemento = "";
			String ordinal     = "";
			String ponto       = "";
			if (memoria.get("cmpART") == null) {
				memoria.put("cmpART",complemento);
			} else {
			    complemento = (String)memoria.get("cmpART");
			}
			if (memoria.get("ordART") == null) {
				memoria.put("ordART",ordinal);
			} else {
			    ordinal = (String)memoria.get("ordART");
			}
			if (memoria.get("pntART") == null) {
				memoria.put("pntART",ponto);
			} else {
			    ponto = (String)memoria.get("pntART");
			}
		    zeraAbaixo(memoria, "Artigo");
			TrataSeqOrdem(memoria, "ART");
		    memoria.put("artID", "art"+numero+complemento);
			//System.err.println("xx"+(String)memoria.get("artID"));
		    System.out.print("                 <Artigo id=\""+pegaID(memoria, "Artigo", "")+"\" seqOrdem=\""+memoria.get("seqART")+"\" ><Rotulo>Art. "+numero+(String)memoria.get("ordART")+(String)memoria.get("cmpART")+(String)memoria.get("pntART")+"</Rotulo>");
			memoria.put("ordART", null);
			memoria.put("pntART", null);
			memoria.put("cmpART", null);
		} else if (tipo.equals("Caput")) {
		    memoria.put("cptID", "cpt");
		    System.out.print("<Caput id=\""+pegaID(memoria, "Caput", "")+"\" ><Texto><p>");
		} else if (tipo.equals("Inciso")) {
		    String complemento = "";
			if (memoria.get("cmpINC") == null) {
				memoria.put("cmpINC",complemento);
			} else {
			    complemento = (String)memoria.get("cmpINC");
			}
		    zeraAbaixo(memoria, "Inciso");
			TrataSeqOrdem(memoria, "INC");
		    memoria.put("incID", "inc"+converteNumeroRomanoParaDecimal(numero)+complemento);
		    System.out.print("                  <Inciso id=\""+pegaID(memoria, "Inciso", "")+"\" seqOrdem=\""+memoria.get("seqINC")+"\" ><Rotulo> "+numero+(String)memoria.get("cmpINC")+" - </Rotulo><Texto><p>");
			memoria.put("cmpINC", null);
		} else if (tipo.equals("Pargrafo")) {
		    String complemento = "";
			String ordinal = "";
			String ponto = "";
			String labelPar = "";
			String numPar = "";
			if (memoria.get("ordPAR") == null) {
				memoria.put("ordPAR",ordinal);
			} else {
			    ordinal = (String)memoria.get("ordPAR");
			}
			if (memoria.get("cmpPAR") == null) {
				memoria.put("cmpPAR",complemento);
			} else {
			    complemento = (String)memoria.get("cmpPAR");
			}
			if (memoria.get("pntPAR") == null) {
				memoria.put("pntPAR",ponto);
			} else {
			    ponto = (String)memoria.get("pntPAR");
			}
			if (memoria.get("lblPAR") == null) {
				memoria.put("lblPAR",labelPar);
			} else {
			    labelPar = (String)memoria.get("lblPAR");
			}
			if (memoria.get("numPAR") == null) {
				memoria.put("numPAR",numPar);
			} else {
			    numPar = (String)memoria.get("numPAR");
				numero = numPar;
			}
		    zeraAbaixo(memoria, "Pargrafo");
			TrataSeqOrdem(memoria, "PAR");
		    memoria.put("parID", "par"+TestaUnico(labelPar)+numPar+complemento);
		    System.out.print("                  <Paragrafo id=\""+pegaID(memoria, "Pargrafo", "")+"\" seqOrdem=\""+memoria.get("seqPAR")+"\" ><Rotulo>"+labelPar+numero+(String)memoria.get("ordPAR")+(String)memoria.get("cmpPAR")+(String)memoria.get("pntPAR")+"</Rotulo><Texto><p>");
			memoria.put("ordPAR", null);
			memoria.put("pntPAR", null);
			memoria.put("lblPAR", null);
			memoria.put("numPAR", null);
			memoria.put("cmpPAR", null);
		} else if (tipo.equals("Alnea")) {
		    String complemento = "";
			if (memoria.get("cmpALI") == null) {
				memoria.put("cmpALI",complemento);
			} else {
			    complemento = (String)memoria.get("cmpALI");
			}
		    zeraAbaixo(memoria, "Alnea");
			TrataSeqOrdem(memoria, "ALI");
		    memoria.put("aliID", "ali"+UtilLexML.letterToDecimal(numero)+complemento);
		    System.out.print("                  <Alinea id=\""+pegaID(memoria, "Alnea", "")+"\" seqOrdem=\""+memoria.get("seqALI")+"\" ><Rotulo> "+numero+(String)memoria.get("cmpALI")+") </Rotulo><Texto><p>");
			memoria.put("cmpALI", null);
		} else if (tipo.equals("Item")) {
		    String complemento = "";
			if (memoria.get("cmpITE") == null) {
				memoria.put("cmpITE",complemento);
			} else {
			    complemento = (String)memoria.get("cmpITE");
			}
			TrataSeqOrdem(memoria, "ITE");
		    memoria.put("iteID", "ite"+numero+complemento);
		    System.out.print("                     <Item id=\""+pegaID(memoria, "Item", "")+"\" seqOrdem=\""+memoria.get("seqITE")+"\" ><Rotulo> "+numero+(String)memoria.get("cmpITE")+(String)memoria.get("pntITE")+"</Rotulo><Texto><p>");
			memoria.put("pntITE", null);
			memoria.put("cmpITE", null);
		}
		
    }	

	public static void TrataSeqOrdem(HashMap memoria, String tipo) {
			int i = 1;
		    if (memoria.get("seq"+tipo) != null) {
		      i = Integer.parseInt((String)memoria.get("seq"+tipo));
			  i = i + 1;
			  memoria.put("seq"+tipo, ""+i);
		    } else {
			  memoria.put("seq"+tipo, ""+1);
			}
	
	}
	
	public static String pegaID(HashMap memoria, String tipo, String id) {
	    // Parte no passam por esta rotina, pois no   necessrio compor partes do ID
	    String idretorno = "";
	    if (tipo.equals("Livro") || tipo.equals("Ttulo") || tipo.equals("Captulo") || tipo.equals("Seo") || tipo.equals("Subseo")) {
		    if ( memoria.get("prtID") != null && ((String)memoria.get("prtID")).length() > 0) {
			   idretorno = idretorno + (String)memoria.get("prtID") + "_";
			} 
		}
	    if (tipo.equals("Ttulo") || tipo.equals("Captulo") || tipo.equals("Seo") || tipo.equals("Subseo")) {
		    if (  memoria.get("livID") != null && ((String)memoria.get("livID")).length() > 0) {
			   idretorno = idretorno + (String)memoria.get("livID") + "_";
			} 
		}
	    if (tipo.equals("Captulo") || tipo.equals("Seo") || tipo.equals("Subseo")) {
		    if ( memoria.get("titID") != null && ((String)memoria.get("titID")).length() > 0) {
			   idretorno = idretorno + (String)memoria.get("titID") + "_";
			} 
		}
	    if (tipo.equals("Seo") || tipo.equals("Subseo")) {
		    if ( memoria.get("capID") != null && ((String)memoria.get("capID")).length() > 0) {
			   idretorno = idretorno + (String)memoria.get("capID") + "_";
			} 
		}
	    if (tipo.equals("Subseo")) {
		    if ( memoria.get("secID") != null && ((String)memoria.get("secID")).length() > 0) {
			   idretorno = idretorno + (String)memoria.get("secID") + "_";
			} 
		}
	    if (tipo.equals("Artigo") || tipo.equals("Caput") || tipo.equals("Pargrafo") || tipo.equals("Inciso") || tipo.equals("Alnea") || tipo.equals("Item")) {
		    if (((String)memoria.get("artID")).length() > 0) {
			   idretorno = idretorno + (String)memoria.get("artID");
			} 
		}
	    if (tipo.equals("Caput") || tipo.equals("Inciso") || tipo.equals("Alnea") || tipo.equals("Item")) {
		    if (((String)memoria.get("cptID")).length() > 0) {
			   idretorno = idretorno + "_" +(String)memoria.get("cptID");
			} 
		}
	    if (tipo.equals("Pargrafo") || tipo.equals("Inciso") || tipo.equals("Alnea") || tipo.equals("Item")) {
		    if (((String)memoria.get("parID")).length() > 0) {
			   idretorno = idretorno + "_" +(String)memoria.get("parID");
			} 
		}
		if (tipo.equals("Inciso") || tipo.equals("Alnea") || tipo.equals("Item")) {
		    if (((String)memoria.get("incID")).length() > 0) {
			   idretorno = idretorno + "_" + (String)memoria.get("incID");
			} 
		}
		if (tipo.equals("Alnea") || tipo.equals("Item")) {
		    if (((String)memoria.get("aliID")).length() > 0) {
			   idretorno = idretorno + "_" + (String)memoria.get("aliID");
			} 
		}
		if (tipo.equals("Item")) {
		    if (((String)memoria.get("iteID")).length() > 0) {
			   idretorno = idretorno + "_" + (String)memoria.get("iteID");
			} 
		}
		return idretorno + id;
	}

	public static void zeraAbaixo(HashMap memoria, String tipo) {
	    if (tipo.equals("Parte")) {
		   memoria.put("livID","");
		   memoria.put("titID","");
		   memoria.put("capID","");
		   memoria.put("secID","");
		   memoria.put("subID","");
		   memoria.put("seqLIV","0");
		   memoria.put("seqTIT","0");
		   memoria.put("seqCAP","0");
		   memoria.put("seqSEC","0");
		   memoria.put("seqSUB","0");
		   memoria.put("seqART","0");
		} else if (tipo.equals("Livro")) {
		   memoria.put("titID","");
		   memoria.put("capID","");
		   memoria.put("secID","");
		   memoria.put("subID","");
		   memoria.put("seqTIT","0");
		   memoria.put("seqCAP","0");
		   memoria.put("seqSEC","0");
		   memoria.put("seqSUB","0");
		   memoria.put("seqART","0");
		} else if (tipo.equals("Ttulo")) {
		   memoria.put("capID","");
		   memoria.put("secID","");
		   memoria.put("subID","");
		   memoria.put("seqCAP","0");
		   memoria.put("seqSEC","0");
		   memoria.put("seqSUB","0");
		   memoria.put("seqART","0");
		} else if (tipo.equals("Captulo")) {
		   memoria.put("secID","");
		   memoria.put("subID","");
		   memoria.put("seqSEC","0");
		   memoria.put("seqSUB","0");
		   memoria.put("seqART","0");
		} else if (tipo.equals("Seo")) {
		   memoria.put("subID","");
		   memoria.put("seqSUB","0");
		   memoria.put("seqART","0"); 
		} else if (tipo.equals("Subseo")) {
		   memoria.put("seqART","0"); 
		} else if (tipo.equals("Artigo")) {
		   memoria.put("parID","");
		   memoria.put("incID","");
		   memoria.put("aliID","");
		   memoria.put("iteID","");
		   memoria.put("seqPAR", "0");
		   memoria.put("seqINC", "0");
		   memoria.put("seqALI", "0");
		   memoria.put("seaITE", "0");
		} else if (tipo.equals("Pargrafo")) {
		   memoria.put("cptID","");
		   memoria.put("incID","");
		   memoria.put("aliID","");
		   memoria.put("iteID","");
		   memoria.put("seqINC", "0");
		   memoria.put("seqALI", "0");
		   memoria.put("seaITE", "0");
		} else if (tipo.equals("Inciso")) {
		   memoria.put("aliID","");
		   memoria.put("iteID","");
		   memoria.put("seqALI", "0");
		   memoria.put("seaITE", "0");
		} else if (tipo.equals("Alnea")) {
		   memoria.put("iteID","");
		   memoria.put("seaITE", "0");
		} 
	}

	public static String TestaUnico(String label) {
	    if (label.equals("Pargrafo nico.") ||  label.equals("Pargrafo nico.") ) {
		   return "1";
		} else if (label.equals(" ")) {
		   return "";
		}
		return label;
    }
	

	
	//////////////////////////////////////////////
	
	public static String Citacao1(String agr1, String NumRomano, String Doc) {
		String resultado = "";
		if (! (Doc == null)) {
		    resultado = "<Remissao xlink:href=\"";
			System.err.println("achei "+Doc);
		} 
		return resultado;
	}
	
	
	
	
	
	///////////////////////////////////////
	
/**
 * @author Michiel Meeuwissen
 * @since MMBase-1.8
 * @version $Id: RomanTransformer.java,v 1.4 2005/11/01 23:36:02 michiel Exp $  */ 
 
    public static final Pattern NUMERICO = Pattern.compile("\\d+");
    public static final Pattern ROMANO = Pattern.compile("(?i)[ivxlcdm]+");
    public static final Pattern ALFABETICO = Pattern.compile("[a-zA-Z]+");

    public static final String LETRAS_MAIUSCULAS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LETRAS_MINUSCULAS = "abcdefghijklmnopqrstuvwxyz";

    public static final int I = 1, V = 5, X = 10, L = 50, C = 100, D = 500, M = 1000;

	public static boolean isVazia(String string) {
        return ((string == null) || (string.trim().length() == 0));
    }
    public static char converteDecimalParaCaracterRomano(int i) {
        switch (i) {
            case M:
                return 'm';
            case D:
                return 'd';
            case C:
                return 'c';
            case L:
                return 'l';
            case X:
                return 'x';
            case V:
                return 'v';
            case I:
                return 'i';
            default:
                return ' ';
        }
    }

    public static String converteDecimalParaRomano(int numeroDecimal) {
        if ((numeroDecimal < 1) || (numeroDecimal > 3999))
            return "" + numeroDecimal;
        final StringBuffer buf = new StringBuffer();
        int mode = M;
        while (numeroDecimal > 0) {
            while (numeroDecimal < mode)
                mode /= 10;
            if ((numeroDecimal >= 9 * mode) && (mode < M)) {
                buf.append(converteDecimalParaCaracterRomano(mode));
                buf.append(converteDecimalParaCaracterRomano(mode * 10));
                numeroDecimal -= 9 * mode;
                continue;
            }
            if ((numeroDecimal >= 4 * mode) && (mode < M)) {
                if (numeroDecimal < 5 * mode) {
                    buf.append(converteDecimalParaCaracterRomano(mode));
                    numeroDecimal += mode;
                }
                buf.append(converteDecimalParaCaracterRomano(5 * mode));
                numeroDecimal -= 5 * mode;
            }
            while (numeroDecimal >= mode) {
                buf.append(converteDecimalParaCaracterRomano(mode));
                numeroDecimal -= mode;
            }
        }
        return buf.toString();
    }

    public static int converteLetraParaNumero(String letra) {
        if ((letra == null) || letra.trim().equals(""))
            return 0;

        return LETRAS_MAIUSCULAS.indexOf(letra.toUpperCase()) + 1;
    }

    public static char converteNumeroParaLetra(int numero) {
        if (numero > LETRAS_MINUSCULAS.length())
            throw new IndexOutOfBoundsException();

        return LETRAS_MINUSCULAS.charAt(numero - 1);
    }

    public static int converteNumeroRomanoParaDecimal(char numeroRomano) {
        if (numeroRomano == 'i')
            return I;
        if (numeroRomano == 'v')
            return V;
        if (numeroRomano == 'x')
            return X;
        if (numeroRomano == 'l')
            return L;
        if (numeroRomano == 'c')
            return C;
        if (numeroRomano == 'd')
            return D;
        if (numeroRomano == 'm')
            return M;
        return 0;
    }

    public static int converteNumeroRomanoParaDecimal(String numeroRomano) {
        numeroRomano = numeroRomano.toLowerCase();
        int tot = 0;
        int mode = I;
        for (int i = numeroRomano.length() - 1; i >= 0; i--) {
            int value = converteNumeroRomanoParaDecimal(numeroRomano.charAt(i));

            if (value > mode)
                mode = value;
            if (value < mode)
                tot -= value;
            else
                tot += value;
        }

        return tot;
    }

    public static char getProximaLetra(char ch) {
        if (ch != 'Z') {
            int index = LETRAS_MAIUSCULAS.indexOf(ch);
            return LETRAS_MAIUSCULAS.charAt(++index);
        }

        return ch;
    }

    public static String getProximoNumero(String numeroAnterior) throws NumberFormatException {
        if (isNumeracaoEspecial(numeroAnterior))
            return getProximoNumeroEspecial(numeroAnterior);

        int numero = Integer.parseInt(numeroAnterior) + 1;
        return Integer.toString(numero);
    }

    public static String getProximoNumeroEspecial(String letraAnterior) {
        if (isVazia(letraAnterior))
            return "";

        StringBuffer sb = new StringBuffer(letraAnterior.substring(0, letraAnterior.length() - 1));

        char ultimoChar = letraAnterior.charAt(letraAnterior.length() - 1);

        if (ultimoChar == 'Z')
            sb.append("ZA");

        sb.append(getProximaLetra(ultimoChar));

        return sb.toString();
    }

    public static boolean isDigitoUnico(String seqOrdem) {
        try {
            String numero = seqOrdem.substring(0, seqOrdem.indexOf('-'));
            if (isNumerico(numero) && (numero.length() > 1))
                return true;
        }
        catch (Exception e) {

        }

        return false;
    }

    public static boolean isLetra(char letra) {
        return ((LETRAS_MINUSCULAS.indexOf(letra) >= 0) || (LETRAS_MINUSCULAS.indexOf(letra) >= 0));
    }

    public static boolean isLetra(String letra) {
        return ALFABETICO.matcher(letra).matches();
    }

    public static boolean isNumeracaoEspecial(String numeracao) {
        Matcher matcher = ALFABETICO.matcher(numeracao);
        if (matcher.find())
            return true;
        return false;
    }

    public static boolean isNumerico(String numero) {
        return NUMERICO.matcher(numero).matches();
    }

    public static boolean isRomano(String numero) {
        return ROMANO.matcher(numero).matches();
    }

 	
    public static int letterToDecimal(String letras) {
        int i = 0,decimal = 0;
        int len = letras.length();
        int temp = 0;
		char cc = letras.charAt(i);
		
        // falta colocar um loop para tratar das alineas "aa" "ab" etc 
		switch(cc) {
			case 'a': return 1;
			case 'b': return 2;
			case 'c': return 3;
			case 'd': return 4;
			case 'e': return 5;
			case 'f': return 6;
			case 'g': return 7;
			case 'h': return 8;
			case 'i': return 9;
			case 'j': return 10;
			case 'k': return 11;
			case 'l': return 12;
			case 'm': return 13;
			case 'n': return 14;
			case 'o': return 15;
			case 'p': return 16;
			case 'q': return 17;
			case 'r': return 18;
			case 's': return 19;
			case 't': return 20;
			case 'u': return 21;
			case 'v': return 22;
			case 'w': return 23;
			case 'x': return 24;
			case 'y': return 25;
			case 'z': return 26;
		}
		return -1;
	 
	}
}