import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import org.antlr.stringtemplate.*;
import org.antlr.stringtemplate.language.*;


import java.io.*;
import java.util.HashMap;

public class PipeLexML {


	public static StringTemplateGroup templates;
	private static String Jurisdicao, Autoridade, Tipo, Numero, DataRepresentativa, DataVersao, DataVisao, Forma, Lingua;
	
	public static void TrataParametros(HashMap memoria) {
	    if (Jurisdicao != null) {
		   memoria.put("Jurisdicao", Jurisdicao);
		   memoria.put("Autoridade", Autoridade);
		   memoria.put("Tipo", Tipo);
		   memoria.put("Numero", Numero);
		   memoria.put("DataRepresentativa", DataRepresentativa);
		   memoria.put("DataVersao", DataVersao);
		   memoria.put("DataVisao", DataVisao);
		   memoria.put("Forma", Forma);
		   memoria.put("Lingua", Lingua);
		} else {
		   memoria.put("Jurisdicao", "");
		   memoria.put("Autoridade", "");
		   memoria.put("Tipo", "");
		   memoria.put("Numero", "");
		   memoria.put("DataRepresentativa", "");
		   memoria.put("DataVersao", "");
		   memoria.put("DataVisao", "");
		   memoria.put("Forma", "");	
		   memoria.put("Lingua", "");
		}
	}
	
    public static void main(String args[]) throws Exception {

	
		
		if (args.length < 1) {
			System.out.println("Use: java PipeLexml NomeArq.txt");
			System.out.println("  ou java PipeLexml NomeArq.rtf");
			return;
		}
		
		if (args.length == 10) {
		   //expe leis\2000\lei09953.rtf  br federal lei 9953 2000-01-04 dataVig 2000-01-05 texto~pt-BR
		   Jurisdicao = args[1];
		   Autoridade = args[2];
		   Tipo       = args[3];
		   Numero     = args[4];
		   DataRepresentativa = args[5];
		   DataVersao = args[6];
		   DataVisao  = args[7];
		   Forma      = args[8];
		   Lingua	  = args[9];
		}
		
		//arquivo de entrada
		FileInputStream fstream = new  FileInputStream(args[0]);
		ANTLRInputStream input = new ANTLRInputStream(fstream);
		System.setErr(new PrintStream(new FileOutputStream(args[0]+".log.txt"), true, "UTF-8"));
		
		if (args[0].toLowerCase().endsWith("rtf")) {

		        // Parser do RTF e criao de rvore em Memria
		        RTFLexer lexer = new RTFLexer(input);
		        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
		        RTFParser parser = new RTFParser(tokens);
		        RTFParser.rtf_return r = parser.rtf();      // parse rule s
				System.err.println("Fase Parser RTF - OK");
				//System.out.println(r.toString());

				// arquivo de sada (
				System.setOut(new PrintStream(new FileOutputStream(args[0]+".xml.html"), true, "UTF-8"));	

		        // Passeio na rvore, externalizando o XML
		        CommonTree t = (CommonTree)r.getTree();
		        CommonTreeNodeStream nodes = new CommonTreeNodeStream(t);
		        nodes.setTokenStream(tokens);
		        GeraXHTML walker = new GeraXHTML(nodes); // cria a rvore Walker
		        //walker.setTemplateLib(templates); // where to find templates
		        GeraXHTML.rtf_return r2 = walker.rtf();
				System.err.println("Fase Gerao do XHTML - OK");
				
				ANTLRInputStream xml = new ANTLRInputStream(new FileInputStream(new File(args[0]+".xml.html")), "UTF-8");

				System.setOut(new PrintStream(new FileOutputStream(args[0]+".txt"), true, "UTF-8"));	
				XHTML2TXTLexer lexFiltroTXT = new XHTML2TXTLexer(xml);
				TokenStream tokensFiltroTXT = new CommonTokenStream(lexFiltroTXT);
				System.out.println(tokensFiltroTXT.toString());
				System.err.println("Fase XHTML2TXT - OK");
				
				fstream  = new FileInputStream(args[0]+".txt");
				input = new ANTLRInputStream(fstream, "UTF-8");
		
		}
		

        // Filtro de Normalizao (correo de erros, uniformizao de espaos etc)
		NormalizaLexer lexFiltro = new NormalizaLexer(input);
		TokenStream tokensFiltro = new CommonTokenStream(lexFiltro);
		System.err.println("Fase Normalizao - OK");
		
		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_Normal.txt"), true, "UTF-8"));	
		System.out.println(tokensFiltro.toString());

		input = new ANTLRInputStream(new FileInputStream(args[0]+"_Normal.txt"), "UTF-8");
		NormalizaAltLexer lexFiltroAlt = new NormalizaAltLexer(input);
		tokensFiltro = new CommonTokenStream(lexFiltroAlt);
		System.err.println("Fase Normalizao Alt - OK");
		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_NormaAlt.txt"), true, "UTF-8"));
		System.out.println(tokensFiltro.toString());
		
        // Parser do Texto Normalizado e criao de rvore em Memria
        LexMLLexer lexer = new LexMLLexer(new ANTLRStringStream(tokensFiltro.toString()));
        TokenRewriteStream tokens = new TokenRewriteStream(lexer);
		System.err.println("Fase LexML Lexer - OK");
        LexMLParser parser = new LexMLParser(tokens);
        LexMLParser.lexml_return r = parser.lexml();      // parse rule s
		System.err.println("Fase LexML Parser - OK");

		// arquivo de sada (bsico)
		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_LexML.xml"), true, "UTF-8"));	

        // Passeio na rvore, externalizando o XML
        CommonTree t = (CommonTree)r.getTree();
        CommonTreeNodeStream nodes = new CommonTreeNodeStream(t);
        nodes.setTokenStream(tokens);
        GeraXML walker = new GeraXML(nodes); // cria a rvore Walker
        //walker.setTemplateLib(templates); // where to find templates
        GeraXML.lexml_return r2 = walker.lexml();
		System.err.println("Fase Gerao do LexML - OK");

		ANTLRInputStream xml = new ANTLRInputStream(new FileInputStream(new File(args[0]+"_LexML.xml")), "UTF-8");

		System.setOut(new PrintStream(new FileOutputStream(args[0]+"_LexML_lang.xml"), true, "UTF-8"));	
		LinguisticoLexer lexFiltroLinguistico = new LinguisticoLexer(xml);
		TokenStream tokensFiltroLinguistico = new CommonTokenStream(lexFiltroLinguistico);
		System.out.println(tokensFiltroLinguistico.toString());
		System.err.println("Fase Linguistica - OK");
		

    }
	

}
