grammar LexML;
options {    
    output=AST;
    ASTLabelType=CommonTree; // type of $stat.tree ref etc...
}
tokens {

LexML; 	 FLexML;
Projeto;	 FProjeto;
Norma;	 FNorma;
ParteInicial;	 FParteInicial;
Epigrafe; 	 FEpigrafe;
Ementa; 	 FEmenta;
Preambulo; 	 FPreambulo;
Articulacao; 	 FArticulacao;
Parte;	 FParte;
Livro;	 FLivro;
Titulo;	 FTitulo;
Capitulo;	 FCapitulo;
Secao;	 FSecao;
Subsecao;	 FSubsecao;
Artigo;	 FArtigo;
Caput;	 FCaput;
Inciso;	 FInciso;
Alinea;	 FAlinea;
Item;	 FItem;
Pena;	 FPena;
Paragrafo;	 FParagrafo;
Alteracao;	 FAlteracao;
Omissis;	 FOmissis;
AspasEstrutura; FAspasEstrutura;
AbreAspas;	 
FechaAspas;	 
AltTitulo;	 FAltTitulo;
AltCapitulo;	 FAltCapitulo;
AltSecao;	 FAltSecao;
AltArtigo;	 FAltArtigo;
AltCaput;	 FAltCaput;
AltParagrafo;   FAltParagrafo;
AltInciso;	 FAltInciso;
AltAlinea;	 FAltAlinea;
AltItem;	 FAltItem;
NotaAlteracao;  FNotaAlteracao;
ParteFinal;	 FParteFinal;
LocalData;	 FLocalData;
Fecho;	 FFecho;
Assinaturas;	 FAssinaturas;
Assinatura;	 FAssinatura;
NomePessoa;	 FNomePessoa;
Cargo;	 FCargo;
Justificacao;   FJustificacao;
PartePrincipal; FPartePrincipal;
P;	 FP;
TWS;
MetadadoNorma;  MetadadoProjeto;
Dummy;

}
@members 	{
  	boolean ehProjeto = false;

} 
@lexer::members {
	boolean ehAlteracao = false;
	}


lexml 	
options { k = 1;}
@init {
    Token start = input.LT(1);
    if (start.getType() == EPIGRAFEROTPL) {
       ehProjeto = true;
    } else {
       ehProjeto = false;
    } 
}    
	:   { !(ehProjeto)}? parteInicial articulacao parteFinal 
	    -> 
	    ^(LexML MetadadoNorma 
	     Norma parteInicial articulacao parteFinal FNorma 
	     FLexML) 
	  | { (ehProjeto) }? parteInicial articulacao justificacao
	     -> 
	    ^(LexML MetadadoProjeto 
	     Projeto Norma parteInicial articulacao FNorma justificacao FProjeto  
	     FLexML) 
	     ;
parteInicial 	: epigrafe ementa preambulo ->
	    ^(ParteInicial epigrafe ementa preambulo FParteInicial) ;
epigrafe 	: { !(ehProjeto)}? 
	  ABREBOLD? EPIGRAFEROT frase FECHABOLD? NEWLINE ->
	    ^(Epigrafe EPIGRAFEROT frase FEpigrafe)  
	| { (ehProjeto) }?
	  ABREBOLD? EPIGRAFEROTPL frase FECHABOLD?  NEWLINE ->
	    ^(Epigrafe EPIGRAFEROTPL frase FEpigrafe) 
	; 
ementa	: ABREBOLD? ABREITALICO? frase FECHAITALICO? FECHABOLD?  NEWLINE -> 
	    ^(Ementa frase FEmenta);
preambulo	: texto+ ->
	    ^(Preambulo texto+ FPreambulo); 
articulacao 	: artigo* (
		parte+ | livro+ | 
		titulo+ | capitulo+ | secao+)?  -> 
                   ^(Articulacao 
                   	artigo* parte* livro* 
                   	titulo* capitulo* secao*  FArticulacao);

parte	: PARTEROT     WS PALAVRA      COMPLEMENTO?                                 NEWLINE artigo* livro*    ->
	    ^(Parte    PARTEROT PALAVRA COMPLEMENTO?         Dummy       artigo* livro*    FParte);
livro	: LIVROROT     WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) (frase NEWLINE)+ artigo* titulo*   ->
	    ^(Livro    LIVROROT    NUMEROROMANO COMPLEMENTO? Dummy (frase TWS)+ artigo* titulo*   FLivro);
titulo	: TITULOROT    WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) (frase NEWLINE)+ artigo* capitulo* ->
	    ^(Titulo   TITULOROT   NUMEROROMANO COMPLEMENTO? Dummy (frase TWS)+ artigo* capitulo* FTitulo);
capitulo	: CAPITULOROT  WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) (frase NEWLINE)+ artigo* secao*     ->
	    ^(Capitulo CAPITULOROT NUMEROROMANO COMPLEMENTO? Dummy (frase TWS)+ artigo* secao*    FCapitulo);
secao	: SECAOROT     WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) (frase NEWLINE)+ artigo* subsecao* ->
	    ^(Secao    SECAOROT    NUMEROROMANO COMPLEMENTO? Dummy (frase TWS)+ artigo* subsecao* FSecao);
subsecao	: SUBSECAOROT  WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) (frase NEWLINE)+ artigo+           ->
	    ^(Subsecao SUBSECAOROT NUMEROROMANO COMPLEMENTO? Dummy (frase TWS)+ artigo* FSubsecao);
	    
artigo	: ARTROT WS NUMERO ORDINAL? COMPLEMENTO? PONTO? caput paragrafo* ->
       	    ^(Artigo ARTROT NUMERO? ORDINAL? COMPLEMENTO? PONTO? Dummy caput paragrafo* FArtigo);
       	    
caput	: WS linha NEWLINE alteracao* inciso* pena? ->
       	    ^(Caput linha alteracao* inciso* pena? FCaput);
paragrafo	: PARROT       NUMERO? ORDINAL? COMPLEMENTO? PONTO? WS linha NEWLINE inciso* pena?  ->
                   ^(Paragrafo PARROT NUMERO? ORDINAL? COMPLEMENTO? PONTO? Dummy linha inciso* pena?  FParagrafo);
inciso	: INCISOROT COMPLEMENTO? WS HIFEN                   WS linha NEWLINE alteracao* alinea* pena? ->
                   ^(Inciso INCISOROT COMPLEMENTO? HIFEN Dummy linha alteracao* alinea* pena* FInciso);
alinea	: LETRAALINEA  COMPLEMENTO? FECHAPARENTESE          WS linha NEWLINE item* ->
                   ^(Alinea LETRAALINEA COMPLEMENTO? FECHAPARENTESE Dummy linha item* FAlinea);
item	: NUMEROITEM COMPLEMENTO? PONTO                  WS linha NEWLINE ->
                   ^(Item NUMEROITEM COMPLEMENTO? PONTO Dummy linha FItem);
pena	: PENAROT    WS HIFEN                               WS linha NEWLINE ->
	    ^(Pena PENAROT HIFEN linha FPena);
	    
alteracao      : ABREASPASROT NEWLINE dispalt FECHAASPASROT NEWLINE notaAlteracao? NEWLINE? ->
	    ^(AspasEstrutura AbreAspas dispalt FechaAspas notaAlteracao? FAspasEstrutura); 
dispalt	: ( altTitulo | altCapitulo | altSecao | altArtigo | altInciso | altParagrafo | altAlinea | altItem | altPena | omissis )+;

omissis	: ARTROTALT WS NUMERO ORDINAL? COMPLEMENTO? PONTO? WS? OMISSIS NEWLINE   ->
	    ^(Omissis ARTROTALT NUMERO? ORDINAL? COMPLEMENTO? PONTO? OMISSIS FOmissis)
	| PARROTALT     NUMERO? ORDINAL? COMPLEMENTO? PONTO? WS? OMISSIS NEWLINE ->
	    ^(Omissis PARROTALT NUMERO? ORDINAL? COMPLEMENTO? PONTO? OMISSIS FOmissis)
	| INCISOROTALT COMPLEMENTO?                          WS HIFEN WS OMISSIS NEWLINE ->
	    ^(Omissis INCISOROTALT COMPLEMENTO? HIFEN OMISSIS FOmissis)
	| PENAROTALT WS HIFEN WS OMISSIS NEWLINE ->
	    ^(Omissis PENAROTALT HIFEN OMISSIS FOmissis)
	| OMISSIS NEWLINE ->
	    ^(Omissis OMISSIS FOmissis);
altTitulo	: TITULOROTALT WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE altArtigo* ->
	    ^(AltTitulo    TITULOROTALT    NUMEROROMANO COMPLEMENTO? Dummy frase altArtigo* FAltTitulo);	    
altCapitulo	: CAPITULOROTALT WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE altArtigo* ->
	    ^(AltCapitulo    CAPITULOROTALT    NUMEROROMANO COMPLEMENTO? Dummy frase altArtigo* FAltCapitulo);	    
altSecao	: SECAOROTALT WS NUMEROROMANO COMPLEMENTO? ( NEWLINE | WS HIFEN WS ) frase NEWLINE altArtigo* ->
	    ^(AltSecao    SECAOROTALT    NUMEROROMANO COMPLEMENTO? Dummy frase altArtigo* FAltSecao);	    
altArtigo	: ARTROTALT WS NUMERO ORDINAL? COMPLEMENTO? PONTO? altCaput altParagrafo*  ->
	    ^(AltArtigo ARTROTALT NUMERO? ORDINAL? COMPLEMENTO? PONTO? Dummy altCaput altParagrafo* FAltArtigo);
altCaput	: WS linha NEWLINE altInciso* altPena?  ->
       	    ^(AltCaput linha FAltCaput);    
altParagrafo	: PARROTALT     NUMERO? ORDINAL? COMPLEMENTO? PONTO? WS linha NEWLINE altInciso* altPena?  ->
                   ^(AltParagrafo PARROTALT NUMERO? ORDINAL? COMPLEMENTO? PONTO? Dummy linha altInciso* altPena?  FAltParagrafo);
altInciso	: INCISOROTALT COMPLEMENTO?                          WS HIFEN WS linha NEWLINE altAlinea*  ->
	    ^(AltInciso INCISOROTALT COMPLEMENTO? HIFEN Dummy linha altAlinea* FAltInciso);
altAlinea	: LETRAALINEAALT  COMPLEMENTO? FECHAPARENTESE        WS linha NEWLINE altItem*  ->
                   ^(AltAlinea LETRAALINEAALT COMPLEMENTO? FECHAPARENTESE Dummy linha altItem* FAltAlinea);
altItem	: NUMEROITEMALT  COMPLEMENTO? PONTO     	        WS linha NEWLINE ->
                   ^(AltItem NUMEROITEMALT COMPLEMENTO? PONTO Dummy linha FAltItem);
altPena	: PENAROTALT    WS HIFEN                             WS linha NEWLINE ->
	    ^(Pena  PENAROTALT HIFEN linha FPena);
notaAlteracao  : NOTAALTERACAO NEWLINE ->
	    ^(NotaAlteracao NOTAALTERACAO FNotaAlteracao);	        	    
parteFinal	: localData assinaturas NEWLINE* ->
                   ^(ParteFinal localData assinaturas FParteFinal);
localData 	: LOCAL linha NEWLINE ->
                   ^(LocalData LOCAL linha FLocalData );
assinaturas    : assinatura+ ->
                   ^(Assinaturas assinatura+ FAssinaturas); 
assinatura 	:  nomepessoa cargo? ->
                   ^(Assinatura nomepessoa cargo? FAssinatura);
nomepessoa	:  linha NEWLINE ->
 	    ^(NomePessoa linha FNomePessoa); 
cargo	: CARGOROT NEWLINE ->
	    ^(Cargo CARGOROT FCargo);	                   
justificacao 	: JUSTIFICAROT linha? NEWLINE texto+ ->
	    ^(Justificacao PartePrincipal P JUSTIFICAROT linha? FP texto* FPartePrincipal FJustificacao);                  
texto 	: linha NEWLINE ->
	    ^(P linha FP);	    
                   
frase	: atomoSimples+;
linha 	: atomo+;
// Se alterar atomo ou atomoSimples, lembrar de alterar em GeraXML.g
atomo 	: NUMERO | PALAVRA | ORDINAL | WS | HIFEN 
	| NUMEROROMANO |   FECHAPARENTESE 
	|  SIMBOLOS | VIRGULA | COMPLEMENTO 
	| PONTUACAO | PONTO  
	| ABREBOLD | FECHABOLD | ABREITALICO | FECHAITALICO
	| ABRETABELA | FECHATABELA | ABRELINHA | FECHALINHA | ABRECELL | FECHACELL;
atomoSimples 	: NUMERO | PALAVRA | ORDINAL | WS | HIFEN 
	| NUMEROROMANO | FECHAPARENTESE | PONTUACAO 
	| SIMBOLOS | VIRGULA | PONTO | COMPLEMENTO;
NEWLINE 	: WS* ('\r'? '\n' WS*)+;
WS 	: (' '|'\t')+;	
HIFEN          : '-';
ARTROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  'Art.' {$type = ARTROTALT;}  
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  'Art.'  
	| 'Art.' {$type = PALAVRA;}  
	;
ARTROTALT      : {getCharPositionInLine()==0 && ehAlteracao}? 
	  'Art.'		
	;
PARROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  (' '|'Pargrafo nico.'|'Pargrafo nico.') {$type = PARROTALT;}
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  (' '|'Pargrafo nico.'|'Pargrafo nico.') 
	| (''|' '|'Pargrafo nico'|'Pargrafo nico'|'') {$type = PALAVRA;}
	;
PARROTALT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  (' '|'Pargrafo nico.'|'Pargrafo nico.')
	  ;
INCISOROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('I'|'V'|'X'|'L'|'C')+ {$type=INCISOROTALT;}
	| {getCharPositionInLine()==0 && ! (ehAlteracao)}? 
	  ('I'|'V'|'X'|'L'|'C')+
	| ('I'|'V'|'X'|'L'|'C')+ {$type=NUMEROROMANO;}
	;
INCISOROTALT 	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('I'|'V'|'X'|'L'|'C')+ 
	;
LOCAL 	: {getCharPositionInLine()==0}? =>
	  ('Braslia'|'BRASLIA'|'Congresso'|'CONGRESSO'|'SENADO'|'Senado')
	   // Incluir a cidade da assinatura do ato. 
//	| ('Braslia'|'BRASLIA,'|'Congresso'|'CONGRESSO') {$type = PALAVRA;}
	;	
CARGOROT	: {getCharPositionInLine()==0}? =>
  	  ('PRESIDENTE'|'Presidente'|'Presidente da Mesa do Congresso Nacional'
  	  |'Primeiro Vice-Presidente da Mesa do Congresso Nacional, no exerccio da Presidncia' 
  	  |'Segundo Vice-Presidente da Mesa do Congresso Nacional, no exerccio da Presidncia')
  	;	
EPIGRAFEROT    : {getCharPositionInLine()==0 && getLine()==1}? =>
	  ABREBOLD? ('Lei'|'LEI'|'Constituio'|'Decreto'|'DECRETO'|'Emenda'|'EMENDA') 
	| ('Lei'|'LEI'|'Constituio'|'Decreto'|'DECRETO') {$type = PALAVRA;}
	;
EPIGRAFEROTPL  : {getCharPositionInLine()==0}? 
	  ('Projeto'|'PROJETO'|'PROPOSTA'|'Proposta')
	| ('Projeto'|'PROJETO'|'PROPOSTA'|'Proposta') {$type = PALAVRA;}
	;
TITULOROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('Ttulo'|'TTULO') {$type=TITULOROTALT;}
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  ('Ttulo'|'TTULO')
	| ('Ttulo'|'TTULO') {$type = PALAVRA;}
	;
TITULOROTALT   : {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('Ttulo'|'TTULO') {$type=TITULOROTALT;}
	;
CAPITULOROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('Captulo'|'CAPTULO') {$type=CAPITULOROTALT;}
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  ('Captulo'|'CAPTULO') 
	|  ('Captulo'|'CAPTULO') {$type = PALAVRA;}
	;
CAPITULOROTALT : {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('Captulo'|'CAPTULO') {$type=CAPITULOROTALT;}
	;	 	
SECAOROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('Seo'|'SEO') {$type=SECAOROTALT;}
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  ('Seo'|'SEO') 
	| ('Seo'|'SEO') {$type = PALAVRA;}
	;
SECAOROTALT 	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('Seo'|'SEO');	
SUBSECAOROT	: {getCharPositionInLine()==0}? 
	  ('Subseo'|'SUBSEO')
	| ('Subseo'|'SUBSEO') {$type = PALAVRA;}
	;
PARTEROT	: {getCharPositionInLine()==0}?
	  ('Parte'|'PARTE')
	| ('Parte'|'PARTE') {$type = PALAVRA;}
	;
LIVROROT	: {getCharPositionInLine()==0}? 
	  ('Livro'|'LIVRO')
	| ('Livro'|'LIVRO') {$type = PALAVRA;}
	;
PENAROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  'Pena' {$type = PENAROTALT;}
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  'Pena' 
	| 'Pena' {$type = PALAVRA;}
	;
PENAROTALT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  'Pena' 
	;
ABREASPASROT	: {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  '"' {ehAlteracao = true;
//	   System.err.println("A");
	      }
	| {getCharPositionInLine()!=0}?
	  '"' {$type = SIMBOLOS;}
	;
FECHAASPASROT	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  '"' {ehAlteracao = false;
//	   System.err.println("F");	  
	      }
	| {getCharPositionInLine()!=0}?
	  '"' {$type = SIMBOLOS;}
	;
JUSTIFICAROT	: {getCharPositionInLine()==0}? 
	  ('Justificao'|'Justificaao'|'JUSTIFICAO')
	| ('Justificao'|'Justificaao'|'JUSTIFICAO') {$type = PALAVRA;}
	;
NOTAALTERACAO	: {getCharPositionInLine()==0}? =>
	   ('(NR)'|'(AC)') 
//	   {System.err.println("NR");} 
//	|  ('(NR)'|'(AC)') {$type = PALAVRA;}
	;	
NUMEROROMANO  	: ('I'|'V'|'X'|'L'|'C')+
	;
COMPLEMENTO    : ('-'('A'..'Z'))+;
FECHAPARENTESE : ')';	
OMISSIS	: ('.....')('.')*
	;  
PONTUACAO 	: (';'|':');
VIRGULA	: ',';
PONTO	: '.';

ABREBOLD	: '<b>';
FECHABOLD	: '</b>';
ABREITALICO	: '<i>';
FECHAITALICO   : '</i>';
ABRETABELA	: '<table>';
FECHATABELA	: '</table>';
ABRELINHA	: '<tr>';
FECHALINHA	: '</tr>';
ABRECELL	: '<td>';
FECHACELL	: '</td>';


SIMBOLOS 	: ('%'|'$'|'*'|'/'|'!'|'@'|'#'|'&'|''|''|''|''|''|'"'|'+'|'<'|'>'|'('|'?'|'['|']'|'_'|'{'|'}'|''|'|'|'=')
	;
NUMEROITEM 	: {getCharPositionInLine()==0 && ehAlteracao}? =>
	   ('0'..'9')+ {$type=NUMEROITEMALT;}  
	| {getCharPositionInLine()==0  && !(ehAlteracao)}? =>
	   ('0'..'9')+  
	|  ('0'..'9')+ {$type=NUMERO;}
	;
NUMEROITEMALT 	: {getCharPositionInLine()==0 && ehAlteracao}? =>
	   ('0'..'9')+ 
	;
NUMERO 	: {getCharPositionInLine()>0}? => ('0'..'9')'.\r' {$type=PALAVRA;}
	| {getCharPositionInLine()>0}? => (('0'..'9')'.')?('0'..'9')+
	;
ORDINAL	: (''|'');
LETRAALINEA	: {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('a'..'z')+ {$type=LETRAALINEAALT;}
	| {getCharPositionInLine()==0 && !(ehAlteracao)}? 
	  ('a'..'z')+
	| ('a'..'z')+ {$type=PALAVRA;}
	;
LETRAALINEAALT : {getCharPositionInLine()==0 && ehAlteracao}? 
	  ('a'..'z')+
	;   	
PALAVRA	: ('a'..'z'|'A'..'Z'|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|'\'')+;

