lexer grammar Normaliza;
options {
    filter=true;
}

WSinterno 	: (' '|'\t')(' '|'\t')+ {setText(" ");};	

Normaliza 	: ( WS* '\r'? '\n' )+ WS*  // normaliza final(is) de linha(s)
	     {setText("\r\n");} 
	  | ('\t')                 // troca tab por branco
	     {setText(" ");}   
	  | ('<i>caput</i>')
	     {setText("caput");}
	  | ('<i> caput</i>')
	     {setText(" caput");}
	  | ('..... .....')
	     {setText("..........");}
	     // acerta branco perdido dentro do omissis
	  | (~('.') '..\r')
	     {setText(getText().substring(0, 1)+".\r");}
	     // acerta ponto ponto ao final de linha
	  | ('<i>caput </i>')
	     {setText("caput ");}
	  | ('". (NR)') 
	     {setText(".\" (NR)");} 
	  | ('". (AC)') 
	     {setText(".\" (AC)");} 
	  | ('\u0096')             // troca travessao pequeno por hifen
	     {setText("-");}       
	  | ('0'..'9') ('o'|'') (' '|','|';'|'.'|'-')  //  acerta ordinal 9o 
	     {String termo = getText(); 
	      setText(termo.substring(0, 1)+""+termo.substring(2));}
	  | ('Brasilia,')
	     {setText("Braslia,");}
	;
	
Resto 	:
	 .;	
	
fragment
WS 	: (' '|'\t')+;	

      
 
