tree grammar GeraXHTML;

options {
    tokenVocab=RTF;
    ASTLabelType=CommonTree;
    output=template; 
}
@header {
import java.util.HashMap;
import java.util.Stack;
import java.io.*;
}
@members {
/** Map variable name to Integer object holding value */
HashMap memory = new HashMap();
Boolean abriuParagrafo = new Boolean("True");
Boolean paragrafoComTexto = new Boolean("True");
Boolean iniciouTexto = new Boolean("False");
Boolean abriuBold = new Boolean("False");
Boolean abriuItalic = new Boolean("False");
Boolean abriuUnderline = new Boolean("False");
Boolean abriuSub = new Boolean("False");
Boolean abriuSuper = new Boolean("False");
Boolean ehTabela = new Boolean("False");
Boolean inicioGrupo = new Boolean("False");
Stack   tags = new Stack();

}


rtf 	: ^(XHTML  	 
		 {System.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		  System.out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ");
		  System.out.println(" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\" >"); 
		  System.out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:lexml=\"http://www.lexml.gov.br/0.6\">");
		  System.out.println("<head><title>Formato XHTML do LexML</title></head>");
		  System.out.println("<body>");
		  tags.push("</html>"); 
		  tags.push("</body>"); 
		  memory.put("abriuBold", abriuBold);
		  memory.put("abriuItalic", abriuItalic);
		  memory.put("abriuUnderline", abriuUnderline);
		  memory.put("abriuSub", abriuSub);
		  memory.put("abriuSuper", abriuSuper);
		  memory.put("iniciouTexto", iniciouTexto);
		  memory.put("ehTabela", ehTabela);
		  memory.put("inicioGrupo", inicioGrupo);
		  UtilLexML.empilha(tags,"<p>");}
		 run
	    FXHTML 	 {
	    	  String tag;
	    	  UtilLexML.desempilha(tags, memory, "</html>");
	    	  }
	    );
run	: ^(BLOCO 
	          miolo*
	    FBLOCO)
	    ;
//linha	: ^(LINHA 
//	       miolo+ 
//	       FLINHA);	          


miolo	: ^(MIOLO
	          CONTROL_SYMBOL?  
	          SLASH? 
	          (CONTROL_WORD
	          	{
	          	 if ($CONTROL_WORD.text.trim().equals("endash")) 
	          	 	 {
	          	 	  System.out.print("-");
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("ldblquote") || $CONTROL_WORD.text.trim().equals("rdblquote")) 
	          	 	 {
	          	 	  System.out.print("\"");
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("b")) 
	          	 	 {
	          	 	  UtilLexML.empilha(tags, "<b>");
	          	 	  abriuBold = Boolean.TRUE;
	          	 	  memory.put("abriuBold", abriuBold);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("b0")) 
	          	 	 {
	          	 	  abriuBold = Boolean.FALSE;
	          	 	  memory.put("abriuBold", abriuBold);
	          	 	  UtilLexML.desempilha(tags, memory, "</b>");
			  UtilLexML.verificaFormatacao(tags, memory);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("i")) 
	          	 	 {
	          	 	  UtilLexML.empilha(tags, "<i>");
	          	 	  abriuItalic = Boolean.TRUE;
	          	 	  memory.put("abriuItalic", abriuItalic);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("i0")) 
	          	 	 {
	          	 	  abriuItalic = Boolean.FALSE;
	          	 	  memory.put("abriuItalic", abriuItalic);
	          	 	  UtilLexML.desempilha(tags, memory, "</i>");
			  UtilLexML.verificaFormatacao(tags, memory);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("u")) 
	          	 	 {
	          	 	  UtilLexML.empilha(tags, "<u>");
	          	 	  abriuUnderline = Boolean.TRUE;
	          	 	  memory.put("abriuUnderline", abriuUnderline);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("u0")) 
	          	 	 {
	          	 	  abriuUnderline = Boolean.FALSE;
	          	 	  memory.put("abriuUnderline", abriuUnderline);
	          	 	  UtilLexML.desempilha(tags, memory, "</u>");
			  UtilLexML.verificaFormatacao(tags, memory);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("sub")) 
	          	 	 {
	          	 	  UtilLexML.empilha(tags, "<sub>");
	          	 	  abriuSub = Boolean.TRUE;
	          	 	  memory.put("abriuSub", abriuSub);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("super")) 
	          	 	 {
	          	 	  UtilLexML.empilha(tags, "<sup>");
	          	 	  abriuSuper = Boolean.TRUE;
	          	 	  memory.put("abriuSuper", abriuSuper);
	          	 	 }
	          	 if ($CONTROL_WORD.text.trim().equals("nosupersub")) 
	          	                {
	         	    abriuSub	    = Boolean.FALSE;
	         	    abriuSuper	    = Boolean.FALSE;
	         	    memory.put("abriuSub", abriuSub);
	         	    memory.put("abriuSuper", abriuSuper);
		    UtilLexML.desempilha(tags, memory, "</sup>");
		    UtilLexML.desempilha(tags, memory, "</sub>");
		                }
	          	 if ($CONTROL_WORD.text.trim().equals("line")) 
	          	                {
		     if (abriuParagrafo.booleanValue()) {
	          		  UtilLexML.desempilha(tags, memory, "</p>"); }
          	 	     UtilLexML.empilha(tags, "<p>");
          	 	     abriuParagrafo = Boolean.TRUE;
	          	                }
	          	}
	          )?	        
	          (C_PARD {
	            ehTabela = Boolean.FALSE;
	            memory.put("ehTabela", ehTabela);

	          })?
	          (C_PAR
	          	{if (abriuParagrafo.booleanValue()) {
	          		  UtilLexML.desempilha(tags, memory, "</p>"); }
          	 	 UtilLexML.empilha(tags, "<p>");
          	 	 abriuParagrafo = Boolean.TRUE;
          	 	 iniciouTexto   = Boolean.FALSE;
         	    	 memory.put("iniciouTexto", iniciouTexto);
          
	          	  }
	            )?
  	          (C_PLAIN
	          	{
	         	    abriuBold      = Boolean.FALSE;
	         	    abriuItalic    = Boolean.FALSE;
	         	    abriuUnderline = Boolean.FALSE;
	         	    abriuSub	    = Boolean.FALSE;
	         	    abriuSuper	    = Boolean.FALSE;
	         	    memory.put("abriuUnderline", abriuUnderline);
	         	    memory.put("abriuItalic", abriuItalic);
	         	    memory.put("abriuBold", abriuBold);
	         	    memory.put("abriuSub", abriuSub);
	         	    memory.put("abriuSuper", abriuSuper);
		    UtilLexML.desempilha(tags, memory, "</sup>");
		    UtilLexML.desempilha(tags, memory, "</sub>");
	         	    UtilLexML.desempilha(tags, memory, "</u>");
	         	    UtilLexML.desempilha(tags, memory, "</i>");
	         	    UtilLexML.desempilha(tags, memory, "</b>");
	         	}
	          )?    
	          (C_CELL {UtilLexML.desempilha(tags, memory, "</td>");
	          	    }
	          )? 
	          (C_ROW {UtilLexML.desempilha(tags, memory, "</tr>");
		    }
	          )? 
	          (C_TROWD {UtilLexML.desempilha(tags, memory, "</table>");
	          	     UtilLexML.empilha(tags, "<table>");
	          	     UtilLexML.empilha(tags, "<tr>");
	          	     UtilLexML.empilha(tags, "<td>");}
	          )? 
	          (C_INTBL {ehTabela = Boolean.TRUE;
	          	     memory.put("ehTabela", ehTabela);
	          	     }
	          )?
	          CR_LF?
	          CR? 
	          LF? 
//	          tabela?
	          text? 
	          group?
	    FMIOLO
	    );	    




group	: ^(GRUPO 
	        {UtilLexML.empilha(tags, "<inicioGrupo>");}
		miolo* 
	        {UtilLexML.zeraFormatacao(memory);}
	        {UtilLexML.desempilha(tags, memory, "</inicioGrupo>");}
	    FGRUPO);
text	: ^(TEXTO 
		{if (! iniciouTexto.booleanValue()) {
		    iniciouTexto = Boolean.TRUE;
	         	    memory.put("iniciouTexto", iniciouTexto);
		    UtilLexML.verificaFormatacao(tags, memory);
	 	 }
		 if (ehTabela.booleanValue() && tags.search("</tr>") <= 0) {
		    UtilLexML.empilha(tags, "<tr>");
		 }
		 if (ehTabela.booleanValue() && tags.search("</td>") <= 0) {
		    UtilLexML.empilha(tags, "<td>");
		 }
		} 
		TEXT?   
		HEX_VALUE? 
		ESCAPED_SLASH? 
		ESCAPED_LBRACE?
		ESCAPED_RBRACE? 
	   FTEXTO) {   UtilLexML.verificaTabela(tags, memory);
	   	System.out.print($text.text);
	           }
	           
	   ;
   







