tree grammar GeraXML;

options {
    tokenVocab=LexML;
    ASTLabelType=CommonTree;
    output=template; 
}
@header {
import java.util.HashMap;
import java.io.*;
}
@members {
/** Map variable name to Integer object holding value */
HashMap memory = new HashMap();

}


lexml 	: ^(LexML  	 {System.out.println("<?xml version=\"1.0\" ?>");} 
		 {System.out.println("<LexML xmlns=\"http://www.lexml.gov.br/0.6\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.lexml.gov.br/0.6 file:./lexml06-br-rigido.xsd\" >");} 
	       (MetadadoNorma
	                {PipeLexML.TrataParametros(memory);
	                 System.out.println("  <Metadado>");
 		  System.out.println("      <Identificacao xml:base=\"http://www.lexml.gov.br/\" FRBRitemRef=\"self\">");
 		  System.out.println("        <JurisdicaoAutoridade  xlink:href=\"/lex/br/JurisdicaoAutoridade.rdf#"+memory.get("Jurisdicao")+"\"/>");
 		  System.out.println("        <Autoridade xlink:href=\"/lex/br/Autoridade.rdf#"+memory.get("Autoridade")+"\"/>  ");
 		  System.out.println("        <TipoDocumento xlink:href=\"/lex/br/TipoDocumento.rdf#"+memory.get("Tipo")+"\"/> ");
 		  System.out.println("        <IdentificadorDocumento>");
 		  System.out.println("          <DataRepresentativa>"+memory.get("DataRepresentativa")+"</DataRepresentativa>");
 		  System.out.println("          <Identificador>"+memory.get("Numero")+"</Identificador> ");
		  System.out.println("        </IdentificadorDocumento>");
		  System.out.println("        <DataVersao>"+memory.get("DataVersao")+"</DataVersao> ");
		  System.out.println("        <DataVisao>"+memory.get("DataVisao")+"</DataVisao> ");
		  System.out.println("        <FormaConteudo>");
		  System.out.println("           <TipoConteudo xlink:href=\"/lex/br/TipoConteudo.rdf#"+memory.get("Forma")+"\"/>");
		  System.out.println("           <Lingua  xlink:href=\"/lex/br/Lingua.rdf#"+memory.get("Lingua")+"\"/>");
		  System.out.println("        </FormaConteudo>");
		  System.out.println("       </Identificacao>");
		  System.out.println("       <Contexto>");
		  System.out.println("         <FRBRObraComplexa URN=\""+UtilLexML.MontaURNComplexa(memory)+"\" showAs=\"NomeObraComplexa\"> ");
		  System.out.println("           <FRBRObraIndividual URN=\""+UtilLexML.MontaURNIndividual(memory)+"\" showAs=\"NomeObraIndividual\"> ");
		  System.out.println("           <PublicacaoOficial URN=\"urn:lex:br:\" showAs=\"Publicao Oficial no \"/>  <!-- falta acertar -->");
		  System.out.println("              <FRBRItem id=\"self\"  mimetype=\"text/xml\" xlink:href=\"texto;pt-br.xml\"/> <!-- falta acertar -->");
		  System.out.println("           </FRBRObraIndividual>");
		  System.out.println("         </FRBRObraComplexa>");
		  System.out.println("         </Contexto>");
	       	  System.out.println("  </Metadado>");}  
	       )?	 
	       (MetadadoProjeto
	                {System.out.println("  <Metadado>");
 		  System.out.println("      <Identificacao xml:base=\"http://www.lexml.gov.br/\" FRBRitemRef=\"self\">");
 		  System.out.println("        <JurisdicaoAutoridade  xlink:href=\"/lex/br/JurisdicaoAutoridade.rdf#br\"/>");
 		  System.out.println("        <Autoridade xlink:href=\"/lex/br/Autoridade.rdf#senado.federal\"/>" ); // incluir aqui o nome uniforme da autoridade
 		  System.out.println("        <TipoDocumento xlink:href=\"/lex/br/TipoDocumento.rdf#projeto.norma;\"/> <!-- falta acertar o subtipo do projeto --> ");
 		  System.out.println("        <IdentificadorDocumento>");
 		  System.out.println("          <DataRepresentativa>1500-01-01</DataRepresentativa> <!-- falta acertar --> ");
 		  System.out.println("          <Identificador> </Identificador> <!-- falta acertar  --> ");
		  System.out.println("        </IdentificadorDocumento>");
		  System.out.println("        <DataVersao>1500-01-01</DataVersao><!-- falta acertar --> ");
		  System.out.println("        <DataVisao>1500-01-01</DataVisao><!-- falta acertar --> ");
		  System.out.println("        <FormaConteudo>");
		  System.out.println("           <TipoConteudo xlink:href=\"/lex/br/TipoConteudo.rdf#texto\"/>");
		  System.out.println("           <Lingua  xlink:href=\"/lex/br/Lingua.rdf#pt-BR\"/>");
		  System.out.println("        </FormaConteudo>");
		  System.out.println("       </Identificacao>");
		  System.out.println("       <Contexto>");
		  System.out.println("         <FRBRObraComplexa URN=\"urn:lex:br:\" showAs=\"NomeObraComplexa\"> <!-- falta acertar --> ");
		  System.out.println("           <FRBRObraIndividual URN=\"urn:lex:br:\" showAs=\"NomeObraIndividual\">  <!-- falta acertar -->");
		  System.out.println("           <PublicacaoOficial URN=\"urn:lex:br:\" showAs=\"Publicao Oficial no \"/>  <!-- falta acertar -->");
		  System.out.println("              <FRBRItem id=\"self\"  mimetype=\"text/xml\" xlink:href=\"texto;pt-br.xml\"/> <!-- falta acertar -->");
		  System.out.println("           </FRBRObraIndividual>");
		  System.out.println("         </FRBRObraComplexa>");
		  System.out.println("         </Contexto>");
	       	  System.out.println("  </Metadado>");}  
	       )?	 
	       	  
	      (Projeto  {System.out.println(" <ProjetoNorma>");})?
	       Norma	 {System.out.println("  <Norma>");} 
		 parteInicial articulacao parteFinal? 
	       FNorma   {System.out.println("  </Norma>");}
	       justificacao? 
	      (FProjeto {System.out.println(" </ProjetoNorma>");})?
	    FLexML 	 {System.out.println("</LexML>");}
	    );
parteInicial 	: ^(ParteInicial   {System.out.println("    <ParteInicial>");} 
		    epigrafe ementa preambulo 
	    FParteInicial  {System.out.println("    </ParteInicial>");}
	    );
epigrafe 	: ^(Epigrafe {System.out.print("      <Epigrafe id=\"epigrafe\"><TextoSimples>");} 
		(EPIGRAFEROT {System.out.print($EPIGRAFEROT.text);})?
		(EPIGRAFEROTPL {System.out.print($EPIGRAFEROTPL.text);})?
		 frase 
	    FEpigrafe {System.out.println("</TextoSimples></Epigrafe>");} 
	    );
ementa	: ^(Ementa {System.out.print("      <Ementa id=\"ementa\"><TextoSimples>");} 
		frase 
	    FEmenta {System.out.println("</TextoSimples></Ementa>");} 
	    );
preambulo	: ^(Preambulo {System.out.println("      <Preambulo id=\"preambulo\"><Texto>");} 
		texto+ 
	    FPreambulo {System.out.println("</Texto></Preambulo>");}
	    ); 
articulacao 	: ^(Articulacao {System.out.println("    <Articulacao>");}
		artigo* parte* livro* titulo* capitulo* secao*  
	    FArticulacao {System.out.println("    </Articulacao>");}
	    );
	    
parte	: ^(Parte PARTEROT PALAVRA 
		(COMPLEMENTO {memory.put("cmpPRT", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "Parte", $PALAVRA.text);}   
		Dummy
		artigo* livro*
	    FParte {System.out.println("    </Parte>");}
	    );
livro	: ^(Livro LIVROROT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpLIV", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "Livro", $NUMEROROMANO.text);}   
		Dummy
		(frase TWS {System.out.print(" ");})+      
		{System.out.println("</TextoSimples>");}
		artigo* titulo*
	    FLivro {System.out.println("    </Livro>");}
	    );
titulo	: ^(Titulo TITULOROT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpTIT", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "Ttulo", $NUMEROROMANO.text);}   
		Dummy
		(frase TWS {System.out.print(" ");})+      
		{System.out.println("</TextoSimples>");}
		artigo* capitulo*
	    FTitulo {System.out.println("    </Titulo>");}
	    );
capitulo	: ^(Capitulo CAPITULOROT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpCAP", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "Captulo", $NUMEROROMANO.text);}   
		Dummy
		(frase TWS {System.out.print(" ");})+      
		{System.out.println("</TextoSimples>");}
		artigo* secao* 
	    FCapitulo {System.out.println("    </Capitulo>");}
	    );
secao	: ^(Secao SECAOROT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpSEC", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "Seo", $NUMEROROMANO.text);}   
                              Dummy           
		(frase TWS {System.out.print(" ");})+      
		{System.out.println("</TextoSimples>");}
		artigo* subsecao*
	    FSecao {System.out.println("    </Secao>");}
	    );
subsecao	: ^(Subsecao SUBSECAOROT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpSUB", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "Subseo", $NUMEROROMANO.text);}   
                              Dummy          
		(frase TWS {System.out.print(" ");})+      
		{System.out.println("</TextoSimples>");}
		artigo* 
	    FSubsecao {System.out.println("    </Subsecao>");}
	    );
	    
artigo	: ^(Artigo ARTROT NUMERO 
		(ORDINAL  {memory.put("ordART",$ORDINAL.text);})? 
		(COMPLEMENTO {memory.put("cmpART",$COMPLEMENTO.text);})?
		(PONTO  {memory.put("pntART",$PONTO.text);})?
		{UtilLexML.MontaTagERotulo(memory, "Artigo", $NUMERO.text);}   
		Dummy
                              caput paragrafo*  
                   FArtigo 	{System.out.println("      </Artigo>");}
                   );
                   
caput	: ^(Caput 
                              {UtilLexML.MontaTagERotulo(memory, "Caput", "");}   
                              linha {System.out.println("</p></Texto>");}  
                              ({System.out.println("     <Alteracao>");}
                              	alteracao
                               {System.out.println("     </Alteracao>");}
                              )* 
                              inciso* pena?
                              {System.out.println("        </Caput>");} 
                   FCaput {memory.put("cptID", "");} 
                   );
inciso	: ^(Inciso INCISOROT 
		(COMPLEMENTO {memory.put("cmpINC",$COMPLEMENTO.text);})? 
		HIFEN 
                               {UtilLexML.MontaTagERotulo(memory, "Inciso", $INCISOROT.text);}
                               Dummy        
                               linha {System.out.println("</p></Texto>");}
                              ({System.out.println("     <Alteracao>");}
                              	alteracao
                               {System.out.println("     </Alteracao>");}
                              )* 
                               alinea* pena?
                               {System.out.println("        </Inciso>");} 
	    FInciso {memory.put("incID", "");}
                   );
alinea	: ^(Alinea LETRAALINEA 
		(COMPLEMENTO {memory.put("cmpALI",$COMPLEMENTO.text);})?  
		FECHAPARENTESE  
                               {UtilLexML.MontaTagERotulo(memory, "Alnea", $LETRAALINEA.text);}
                               Dummy
                               linha {System.out.println("</p></Texto>");}
                               item*
                               {System.out.println("          </Alinea>");} 
	    FAlinea {memory.put("aliID", "");}
                   );
item	: ^(Item NUMEROITEM 
		(COMPLEMENTO {memory.put("cmpITE",$COMPLEMENTO.text);})?  
		(PONTO  {memory.put("pntITE",$PONTO.text);})?
                               {UtilLexML.MontaTagERotulo(memory, "Item", $NUMEROITEM.text);}
                               Dummy
                               linha 
                               {System.out.println("</p></Texto></Item>");} 
	    FItem {memory.put("iteID", "");}
                   );
paragrafo	: ^(Paragrafo PARROT {memory.put("lblPAR", $PARROT.text);}
		(NUMERO {memory.put("numPAR", $NUMERO.text);})?
		(ORDINAL  {memory.put("ordPAR",$ORDINAL.text);})? 
		(COMPLEMENTO {memory.put("cmpPAR",$COMPLEMENTO.text);})?
		(PONTO  {memory.put("pntPAR",$PONTO.text);})?
                               {UtilLexML.MontaTagERotulo(memory, "Pargrafo", "");}
		 Dummy 
                               linha 
                               {System.out.println("</p></Texto>");} 
                               inciso* pena?
                               {System.out.println("        </Paragrafo>");} 
                   FParagrafo {memory.put("parID", "");}
                   );
pena	: ^(Pena PENAROT  {System.out.print("          <Pena><Rotulo>"+$PENAROT.text +" - </Rotulo>");} 
		HIFEN {System.out.print("<Texto><p>");}
                               linha 
                               {System.out.print("</p></Texto></Pena>");} 
	    FPena
                   );
alteracao      : ^(AspasEstrutura {UtilLexML.IncrementaAspas(memory);
 		     System.out.println("            <AspasEstrutura id=\""+UtilLexML.pegaID(memory, "Alteracao", "")+"_asp"+((Integer)memory.get("SeqAspas")).intValue()+"\">");}
		AbreAspas {System.out.println("                <AbreAspas>"+'\u201C'+"</AbreAspas>");} 
		dispalt 
		FechaAspas {System.out.println("                <FechaAspas>"+'\u201D'+"</FechaAspas>");} 
		notaAlteracao? 
	    FAspasEstrutura {System.out.println("            </AspasEstrutura>");}  
	    ); 
dispalt	: ( altTitulo | altCapitulo | altSecao | altArtigo | altInciso | altParagrafo | altAlinea | altItem | altPena | omissis )+;

altTitulo	: ^(AltTitulo TITULOROTALT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpATIT", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "ATitulo", $NUMEROROMANO.text);}   
                              Dummy           
		frase     {System.out.println("</TextoSimples>");}
		altArtigo* 
	    FAltTitulo {System.out.println("    </Titulo>");}
	    );

altCapitulo	: ^(AltCapitulo CAPITULOROTALT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpACAP", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "ACapitulo", $NUMEROROMANO.text);}   
                              Dummy           
		frase     {System.out.println("</TextoSimples>");}
		altArtigo* 
	    FAltCapitulo {System.out.println("    </Capitulo>");}
	    );

altSecao	: ^(AltSecao SECAOROTALT NUMEROROMANO 
		(COMPLEMENTO {memory.put("cmpASEC", $COMPLEMENTO.text);})? 
		{UtilLexML.MontaTagERotulo(memory, "ASeo", $NUMEROROMANO.text);}   
                              Dummy           
		frase     {System.out.println("</TextoSimples>");}
		altArtigo* 
	    FAltSecao {System.out.println("    </Secao>");}
	    );

altArtigo	: ^(AltArtigo ARTROTALT NUMERO 
		(ORDINAL  {memory.put("ordAART",$ORDINAL.text);})? 
		(COMPLEMENTO {memory.put("cmpAART",$COMPLEMENTO.text);})?
		(PONTO  {memory.put("pntAART",$PONTO.text);})?
		{UtilLexML.MontaTagERotulo(memory, "AArtigo", $NUMERO.text);}   
		Dummy
                              altCaput altParagrafo*   
                   FAltArtigo  {System.out.println("</Artigo>");}
                   );
    
altCaput	: ^(AltCaput 
                              {UtilLexML.MontaTagERotulo(memory, "ACaput", "");}   
                              linha {System.out.print("</p></Texto>");}  
                              {System.out.print("</Caput>");} 
                   FAltCaput {memory.put("cptID", "");} 
                   );    
altParagrafo	: ^(AltParagrafo PARROTALT {memory.put("lblAPAR", $PARROTALT.text);}
		(NUMERO {memory.put("numAPAR", $NUMERO.text);})?
		(ORDINAL  {memory.put("ordAPAR",$ORDINAL.text);})? 
		(COMPLEMENTO {memory.put("cmpAPAR",$COMPLEMENTO.text);})?
		(PONTO  {memory.put("pntAPAR",$PONTO.text);})?
                               {UtilLexML.MontaTagERotulo(memory, "APargrafo", "");}
		 Dummy 
                               linha 
                               {System.out.println("</p></Texto>");} 
                               altInciso* altPena?
                               {System.out.println("        </Paragrafo>");} 
                   FAltParagrafo {memory.put("AparID", "");}
                   );
altInciso	: ^(AltInciso INCISOROTALT 
		(COMPLEMENTO {memory.put("cmpAINC",$COMPLEMENTO.text);})? 
		HIFEN 
                               {UtilLexML.MontaTagERotulo(memory, "AInciso", $INCISOROTALT.text);}
                               Dummy        
                               linha {System.out.println("</p></Texto>");}
                               altAlinea* 
                               {System.out.println("        </Inciso>");} 
	    FAltInciso {memory.put("AincID", "");}
                   );
altAlinea	: ^(AltAlinea LETRAALINEAALT 
		(COMPLEMENTO {memory.put("cmpAALI",$COMPLEMENTO.text);})?  
		FECHAPARENTESE  
                               {UtilLexML.MontaTagERotulo(memory, "AAlnea", $LETRAALINEAALT.text);}
                               Dummy
                               linha {System.out.println("</p></Texto>");}
                               altItem*
                               {System.out.println("          </Alinea>");} 
	    FAltAlinea {memory.put("AaliID", "");}
                   );
altItem	: ^(AltItem NUMEROITEMALT 
		(COMPLEMENTO {memory.put("cmpAITE",$COMPLEMENTO.text);})?  
		(PONTO  {memory.put("pntAITE",$PONTO.text);})?
                               {UtilLexML.MontaTagERotulo(memory, "AItem", $NUMEROITEMALT.text);}
                               Dummy
                               linha 
                               {System.out.println("</p></Texto></Item>");} 
	    FAltItem {memory.put("AiteID", "");}
                   );
altPena	: ^(Pena PENAROTALT  {System.out.print("          <Pena><Rotulo>"+$PENAROTALT.text +" - </Rotulo>");} 
		HIFEN {System.out.print("<Texto><p>");}
                               linha 
                               {System.out.print("</p></Texto></Pena>");} 
	    FPena
                   );                   
omissis	: ^(Omissis {System.out.print("       <Omissis>");}
		ARTROTALT NUMERO
		(ORDINAL  {memory.put("ordAART",$ORDINAL.text);})? 
		(COMPLEMENTO {memory.put("cmpAART",$COMPLEMENTO.text);})?
		(PONTO  {memory.put("pntAART",$PONTO.text);})?
		{UtilLexML.MontaRotulo(memory,"AArtigo", $NUMERO.text);}
		        {System.out.print("<TextoSimples>");}
		OMISSIS {System.out.print($OMISSIS.text);}
	   FOmissis {System.out.println("</TextoSimples></Omissis>");})
	| ^(Omissis {System.out.print("       <Omissis>");}
		PARROTALT {memory.put("lblAPAR", $PARROTALT.text);}
		(NUMERO {memory.put("numAPAR", $NUMERO.text);})?
		(ORDINAL  {memory.put("ordAPAR",$ORDINAL.text);})? 
		(COMPLEMENTO {memory.put("cmpAPAR",$COMPLEMENTO.text);})?
		(PONTO  {memory.put("pntAPAR",$PONTO.text);})?
		{UtilLexML.MontaRotulo(memory,"APargrafo", "");}
		        {System.out.print("<TextoSimples>");}
		OMISSIS {System.out.print($OMISSIS.text);}
	    FOmissis {System.out.println("</TextoSimples></Omissis>");})
	| ^(Omissis {System.out.print("       <Omissis><Rotulo/><TextoSimples>");}
		INCISOROTALT
		(COMPLEMENTO {memory.put("cmpAINC",$COMPLEMENTO.text);})? 
		HIFEN 
		{UtilLexML.MontaRotulo(memory,"AInciso", $INCISOROTALT.text);}
		OMISSIS {System.out.print($OMISSIS.text);}
	    FOmissis   {System.out.println("</TextoSimples></Omissis>");})
	| ^(Omissis {System.out.print("       <Omissis>");}
		PENAROTALT HIFEN {System.out.print("<Rotulo>Pena -</Rotulo>");}
		OMISSIS {System.out.print($OMISSIS.text);}
	    FOmissis{System.out.println("</TextoSimples></Omissis>");})    
	| ^(Omissis    {System.out.print("       <Omissis><Rotulo/><TextoSimples>");}
		OMISSIS {System.out.print($OMISSIS.text);}
	    FOmissis   {System.out.println("</TextoSimples></Omissis>");})
	    ;
                   
notaAlteracao  : ^(NotaAlteracao {System.out.print("        <NotaAlteracao><TextoSimples>");} 
		NOTAALTERACAO {System.out.print($NOTAALTERACAO.text);}
		FNotaAlteracao {System.out.println("</TextoSimples></NotaAlteracao>");} 
	    );	        	    
                   
parteFinal	: ^(ParteFinal {System.out.println("    <ParteFinal>");} 
		localData assinaturas 
	    FParteFinal {System.out.println("    </ParteFinal>");}
	    );
localData 	: ^(LocalData LOCAL {System.out.print("      <LocalDataFecho id=\"localDataFecho\"><TextoSimples>"+$LOCAL.text);}
		linha 
		{System.out.print($linha.text);
		System.out.println("</TextoSimples></LocalDataFecho>");}
	     FLocalData
	    );	    
assinaturas    : ^(Assinaturas {System.out.println("      <Assinaturas>");}
		assinatura+ 
	    FAssinaturas {System.out.println("      </Assinaturas>");}
	    ); 
assinatura 	: ^(Assinatura {System.out.print("          <Assinatura>");}
	    nomepessoa cargo?
	    FAssinatura {System.out.println("</Assinatura>");}
	    );
nomepessoa	:  ^(NomePessoa  {System.out.print("              <NomePessoa>");}
		linha 
	    FNomePessoa {System.out.println("</NomePessoa>");}
	    );
cargo	: ^(Cargo {System.out.print("          <Cargo>");}
		CARGOROT {System.out.print($CARGOROT.text);}
	    FCargo {System.out.print("</Cargo>");});	                   
justificacao 	: ^(Justificacao {System.out.println("          <Justificacao>");} 
	    PartePrincipal {System.out.println("            <PartePrincipal>");} 
	    P {System.out.print("          <p>");} 
	    JUSTIFICAROT {System.out.print($JUSTIFICAROT.text);} 
	    linha? 
	    FP {System.out.println("          </p>");} 
		texto*	    
	    FPartePrincipal {System.out.println("            </PartePrincipal>");} 
	    FJustificacao {System.out.println("          </Justificacao>");} 
	    );
	
texto 	: ^(P {System.out.print("          <p>");}
		linha 
	    FP {System.out.println("          </p>");}
	    );

frase	: atomoSimples+;
linha 	: atomo+;
atomo 	: ( NUMERO | PALAVRA | ORDINAL |  WS | HIFEN | PONTUACAO | PONTO
	| NUMEROROMANO | FECHAPARENTESE 
	| SIMBOLOS | VIRGULA | COMPLEMENTO
	| ABREBOLD | FECHABOLD | ABREITALICO | FECHAITALICO
	| ABRETABELA | FECHATABELA | ABRELINHA | FECHALINHA | ABRECELL | FECHACELL
	) {System.out.print($atomo.text);} ;
atomoSimples 	: ( NUMERO | PALAVRA | ORDINAL | WS | HIFEN 
	| NUMEROROMANO | FECHAPARENTESE | PONTUACAO
	| SIMBOLOS | VIRGULA | PONTO | COMPLEMENTO 
	) {System.out.print($atomoSimples.text);} ;







