lexer grammar NormalizaAlt;
options {
    filter=true;
}

Normaliza 	: {getCharPositionInLine()==0}? =>  ('"')
	     {setText("\"\r\n");}
	| {getCharPositionInLine()==0}? =>  ('" ')
	     {setText("\"\r\n");}	
	| ('"' ' '? '(NR)\r')
	     {setText("\r\n\"\r\n(NR)\r");} 	     
	| ('"' ' '? '(AC)\r')
	     {setText("\r\n\"\r\n(AC)\r");} 	     
	| ('"\r')
	     {setText("\r\n\"\r");}
	| ('\n"' ' '?)
	     {setText("\n\"\r\n");}
	| {getCharPositionInLine()==0}? '<<'? '('? ('a'|'A'|'A ') ('n'|'N'|'N ') ('e'|'E'|'E ') ('x'|'X'|'X ') ('o'|'O') ('S'|'s')? (' ')* ('I')* '>>'? 
	    {$type=EOF;}
	| {getCharPositionInLine()==0 && getLine() > 2}? '###'
	    {$type=EOF;}
	| {getCharPositionInLine()==0}? => ('Este texto no substitui o publicado no')
	    {$type=EOF;}  
	| {getCharPositionInLine()==0}? => ('<table><tr><td>')? ('<b>')? (''|'O') ('R'|'r') ('G'|'g') (''|'A'|''|'a') ('O'|'o')
	    {$type=EOF;}
	| {getCharPositionInLine()==0}? => ('<table><tr><td>')? ('<b>')? ('U'|'u') ('N'|'n') ('I'|'i') ('D'|'d') ('A'|'a') ('D'|'d') ('E'|'e')
	    {$type=EOF;}
	| {getCharPositionInLine()==0}? => ('Retificao'|'RETIFICAO'|'retificao'|'REPUBLICAO'|'Republicao'|'republicao')
	    {$type=EOF;}
	| {getCharPositionInLine()==0 && getLine()==1}? => ' '
	    {setText("");}
	| {getCharPositionInLine()==0 && getLine()==1}? => '###' ('A'..'Z' | '0'..'9' | '-')+ '@@@' '\r\n'
	    {setText("");}
	| {getCharPositionInLine()==0}? => ('Art.') ('0'..'9') // inclui branco 
	    {setText("Art. "+ getText().substring(4, 5));}
	;
fragment
COMPLEMENTO    : ('-'('A'..'Z'))+
	;	
fragment
NUMEROROMANO  	: ('I'|'V'|'X'|'L'|'C')+
	;
fragment
PALAVRA	: (' '| ','| 'a'..'z'|'A'..'Z'|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|''|'\'')+;	
	
Resto 	:
	 .;	
