package exemplo2;

import java.io.IOException;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Field.Index;
import org.apache.lucene.document.Field.Store;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;

public class IndexTuningDemo {
	public static void main(String[] args) throws Exception {
		int[][] parametros = {{10,9999999,10}, {100,9999999,10}, {10,9999999,100}, {100,9999999,1000},
				{1000,9999999,1000}, {10,1000,100}};
		
		for (int i =0 ; i < parametros.length ; i++)
		{
			indexar(parametros[i][0],parametros[i][1],parametros[i][2]);
		}
	}

	private static void indexar(int mergeFactor, int maxMergeDocs,
			int minMergeDocs) throws CorruptIndexException,
			LockObtainFailedException, IOException {
		Directory dir = FSDirectory.getDirectory("C:\\lucene\\index\\exemplo2",
				true);
		Analyzer analyzer = new SimpleAnalyzer();
		IndexWriter writer = new IndexWriter(dir, analyzer, true);

		// set variables that affect speed of indexing
		writer.setMergeFactor(mergeFactor);
		writer.setMaxMergeDocs(maxMergeDocs);
		writer.setMaxBufferedDocs(minMergeDocs);

		//writer.setInfoStream(System.out);
		System.out.println("Merge factor: " + writer.getMergeFactor());
		System.out.println("Max merge docs: " + writer.getMaxMergeDocs());
		System.out.println("Min merge docs: " + writer.getMaxBufferedDocs());
		long start = System.currentTimeMillis();
		for (int i = 0; i < 10000; i++) {
			Document doc = new Document();
			doc.add(new Field("fieldname", "Bibamus", Store.YES,
					Index.UN_TOKENIZED));
			writer.addDocument(doc);
		}
		writer.close();
		long stop = System.currentTimeMillis();
		System.out.println("Time: " + (stop - start) + " ms");
		System.out.println("-------------------------------------------------------");
	}
}