package exemplo1;

import java.io.File;
import java.util.Date;

import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParser.Operator;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Searcher {
	public static void main(String[] args) throws Exception {
//		if (args.length != 2) {
//			throw new Exception("Usage: java " + Searcher.class.getName()
//					+ " <index dir> <query>");
//		}

		File indexDir = new File("C:\\lucene\\index\\exemplo1");
		String q = "amazonas fpm";
		if (!indexDir.exists() || !indexDir.isDirectory()) {
			throw new Exception(indexDir
					+ " does not exist or is not a directory.");
		}
		search(indexDir, q);
	}

	public static void search(File indexDir, String q) throws Exception {
		Directory fsDir = FSDirectory.getDirectory(indexDir, false);
		IndexSearcher is = new IndexSearcher(fsDir);
		QueryParser qp = new QueryParser("contents",new StandardAnalyzer());
		
		//***********************
		//qp.setDefaultOperator(Operator.AND);
		
		Query query = qp.parse(q);
		
		long start = new Date().getTime();
		
		// pesquisa
		Hits hits = is.search(query);
		
		long end = new Date().getTime();
		System.err.println("Found " + hits.length() + " document(s) (in "
				+ (end - start) + " milliseconds) that matched query '" + q
				+ "':");
		for (int i = 0; i < hits.length(); i++) {
			Document doc = hits.doc(i);
			System.out.println(doc.get("filename"));
		}
	}
}