package exemplo4;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class AnalyzerDemo {
	private static final String[] examples = {
			"The quick brown fox jumped over the lazy dogs",
			"XY&Z Corporation - xyz@example.com" };
	private static final Analyzer[] analyzers = new Analyzer[] {
			new WhitespaceAnalyzer(), new SimpleAnalyzer(), new StopAnalyzer(),
			new StandardAnalyzer() };

	public static void main(String[] args) throws IOException {
		// Use the embedded example strings, unless
		// command line arguments are specified, then use those.
		String[] strings = examples;
		if (args.length > 0) {
			strings = args;
		}
		for (int i = 0; i < strings.length; i++) {
			analyze(strings[i]);
		}
	}

	private static void analyze(String text) throws IOException {
		System.out.println("Analyzing \"" + text + "\"");
		for (int i = 0; i < analyzers.length; i++) {
			Analyzer analyzer = analyzers[i];
			String name = analyzer.getClass().getName();
			name = name.substring(name.lastIndexOf(".") + 1);
			System.out.println(" " + name + ":");
			System.out.print(" ");
			displayTokens(analyzer, text);
			System.out.println("\n");
		}
	}

	public static Token[] tokensFromAnalysis(Analyzer analyzer, String text)
			throws IOException {
		TokenStream stream = analyzer.tokenStream("contents", new StringReader(
				text));
		ArrayList tokenList = new ArrayList();
		while (true) {
			Token token = stream.next();
			if (token == null)
				break;
			tokenList.add(token);
		}
		return (Token[]) tokenList.toArray(new Token[0]);
	}

	public static void displayTokens(Analyzer analyzer, String text)
			throws IOException {
		Token[] tokens = tokensFromAnalysis(analyzer, text);
		for (int i = 0; i < tokens.length; i++) {
			Token token = tokens[i];
			System.out.print("[" + token.termText() + "] ");
		}
	}
}