package exemplo3;

import java.io.File;
import java.util.Date;

import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Ex_QueryParser {

	public static void main(String[] args) throws Exception {
		File indexDir = new File("C:\\lucene\\index\\exemplo1");

		
		if (!indexDir.exists() || !indexDir.isDirectory()) {
			throw new Exception(indexDir
					+ " does not exist or is not a directory.");
		}

		String q = "amazonas OR fpm";
		search(indexDir, q);
		
		q = "+amazonas +fpm";
		search(indexDir, q);
		
		q = "contents:constituio";
		search(indexDir, q);

		q = "contents:constituio AND (amazonas OR fpm)";
		search(indexDir, q);

		q = "contents:\"estado do amazonas\"";
		search(indexDir, q);

		q = "contents:\"processo problema\"~10";
		search(indexDir, q);

		q = "contents:\"processo relevncia\"~10";
		search(indexDir, q);

		q = "contents:\"processo relevncia\"~20";
		search(indexDir, q);

		q = "amazon*";
		search(indexDir, q);

		q = "bola~";
		search(indexDir, q);
	}

	public static void search(File indexDir, String q) throws Exception {
		Directory fsDir = FSDirectory.getDirectory(indexDir, false);
		IndexSearcher is = new IndexSearcher(fsDir);
		QueryParser qp = new QueryParser("contents",new StandardAnalyzer());
		
		Query query = qp.parse(q);
		
		long start = new Date().getTime();
		
		// pesquisa
		Hits hits = is.search(query);
		
		long end = new Date().getTime();
		System.err.println("Found " + hits.length() + " document(s) (in "
				+ (end - start) + " milliseconds) that matched query '" + q
				+ "':");
//		for (int i = 0; i < hits.length(); i++) {
//			Document doc = hits.doc(i);
//			System.out.println(doc.get("filename"));
//		}
	}
}