/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.ConnectionJDBC3;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.Messages;

public class Driver
implements java.sql.Driver {
    private static String driverPrefix = "jdbc:jtds:";
    static final int MAJOR_VERSION = 0;
    static final int MINOR_VERSION = 9;
    static final String MISC_VERSION = null;
    public static final boolean JDBC3 = "1.4".compareTo(System.getProperty("java.specification.version")) <= 0;
    public static final int TDS42 = 1;
    public static final int TDS50 = 2;
    public static final int TDS70 = 3;
    public static final int TDS80 = 4;
    public static final int TDS81 = 5;
    public static final int SQLSERVER = 1;
    public static final int SYBASE = 2;

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 9;
    }

    public static final String getVersion() {
        return "0.9" + (MISC_VERSION == null ? "" : MISC_VERSION);
    }

    public String toString() {
        return "jTDS " + Driver.getVersion();
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith(driverPrefix);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || !url.toLowerCase().startsWith(driverPrefix)) {
            return null;
        }
        Properties props = Driver.parseURL(url, info);
        if (props == null) {
            throw new SQLException(Messages.get("error.driver.badurl", url), "08001");
        }
        if (props.getProperty(Messages.get("prop.logintimeout")) == null) {
            props.setProperty(Messages.get("prop.logintimeout"), Integer.toString(DriverManager.getLoginTimeout()));
        }
        if (JDBC3) {
            return new ConnectionJDBC3(url, props);
        }
        return new ConnectionJDBC2(url, props);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        Properties parsedProps = Driver.parseURL(url, props == null ? new Properties() : props);
        if (parsedProps == null) {
            throw new SQLException(Messages.get("error.driver.badurl", url), "08001");
        }
        HashMap propertyMap = new HashMap();
        HashMap descriptionMap = new HashMap();
        Messages.loadDriverProperties(propertyMap, descriptionMap);
        Map choicesMap = this.createChoicesMap();
        Map requiredTrueMap = this.createRequiredTrueMap();
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[propertyMap.size()];
        Iterator iterator = propertyMap.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String name = (String)propertyMap.get(key);
            DriverPropertyInfo info = new DriverPropertyInfo(name, parsedProps.getProperty(name));
            info.description = (String)descriptionMap.get(key);
            info.required = requiredTrueMap.containsKey(name);
            if (choicesMap.containsKey(name)) {
                info.choices = (String[])choicesMap.get(name);
            }
            dpi[i] = info;
            ++i;
        }
        return dpi;
    }

    private Map createChoicesMap() {
        HashMap<String, String[]> choicesMap = new HashMap<String, String[]>();
        String[] booleanChoices = new String[]{"true", "false"};
        choicesMap.put(Messages.get("prop.lastupdatecount"), booleanChoices);
        choicesMap.put(Messages.get("prop.namedpipe"), booleanChoices);
        choicesMap.put(Messages.get("prop.useunicode"), booleanChoices);
        String[] prepareSqlChoices = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2), String.valueOf(3), String.valueOf(4)};
        choicesMap.put(Messages.get("prop.preparesql"), prepareSqlChoices);
        String[] serverTypeChoices = new String[]{String.valueOf(1), String.valueOf(2)};
        choicesMap.put(Messages.get("prop.servertype"), serverTypeChoices);
        String[] tdsChoices = new String[]{"4.2", "5.0", "7.0", "8.0"};
        choicesMap.put(Messages.get("prop.tds"), tdsChoices);
        return choicesMap;
    }

    private Map createRequiredTrueMap() {
        HashMap<String, Object> requiredTrueMap = new HashMap<String, Object>();
        requiredTrueMap.put(Messages.get("prop.servername"), null);
        requiredTrueMap.put(Messages.get("prop.servertype"), null);
        return requiredTrueMap;
    }

    private static Properties parseURL(String url, Properties info) {
        Properties props = new Properties();
        Enumeration e = ((Hashtable)info).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = info.getProperty(key);
            if (value == null) continue;
            props.setProperty(key.toUpperCase(), value);
        }
        StringBuffer token = new StringBuffer(16);
        int pos = 0;
        pos = Driver.nextToken(url, pos, token);
        if (!token.toString().equalsIgnoreCase("jdbc")) {
            return null;
        }
        pos = Driver.nextToken(url, pos, token);
        if (!token.toString().equalsIgnoreCase("jtds")) {
            return null;
        }
        pos = Driver.nextToken(url, pos, token);
        String type = token.toString().toLowerCase();
        Integer serverType = DefaultProperties.getServerType(type);
        if (serverType == null) {
            return null;
        }
        props.setProperty(Messages.get("prop.servertype"), String.valueOf(serverType));
        pos = Driver.nextToken(url, pos, token);
        if (token.length() > 0) {
            return null;
        }
        pos = Driver.nextToken(url, pos, token);
        String host = token.toString();
        if (host.length() == 0 && ((host = props.getProperty(Messages.get("prop.servername"))) == null || host.length() == 0)) {
            return null;
        }
        props.setProperty(Messages.get("prop.servername"), host);
        if (url.charAt(pos - 1) == ':' && pos < url.length()) {
            pos = Driver.nextToken(url, pos, token);
            try {
                int port = Integer.parseInt(token.toString());
                props.setProperty(Messages.get("prop.portnumber"), Integer.toString(port));
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
        if (url.charAt(pos - 1) == '/' && pos < url.length()) {
            pos = Driver.nextToken(url, pos, token);
            props.setProperty(Messages.get("prop.databasename"), token.toString());
        }
        while (url.charAt(pos - 1) == ';' && pos < url.length()) {
            pos = Driver.nextToken(url, pos, token);
            String tmp = token.toString();
            int index = tmp.indexOf(61);
            if (index > 0 && index < tmp.length() - 1) {
                props.setProperty(tmp.substring(0, index).toUpperCase(), tmp.substring(index + 1));
                continue;
            }
            props.setProperty(tmp.toUpperCase(), "");
        }
        props = DefaultProperties.addDefaultProperties(props);
        return props;
    }

    private static int nextToken(String url, int pos, StringBuffer token) {
        token.setLength(0);
        while (pos < url.length()) {
            char ch;
            if ((ch = url.charAt(pos++)) == ':' || ch == ';') break;
            if (ch == '/') {
                if (pos >= url.length() || url.charAt(pos) != '/') break;
                ++pos;
                break;
            }
            token.append(ch);
        }
        return pos;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

