/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log.jdk14logging;

import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.DoubleWeakHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Jdk14MLog
extends MLog {
    private static String[] UNKNOWN_ARRAY = new String[]{"UNKNOWN_CLASS", "UNKNOWN_METHOD"};
    private static final String CHECK_CLASS = "java.util.logging.Logger";
    private final Map namedLoggerMap = new DoubleWeakHashMap();
    MLogger global = null;

    public Jdk14MLog() throws ClassNotFoundException {
        Class.forName(CHECK_CLASS);
    }

    public synchronized MLogger getMLogger(String name) {
        MLogger out = (MLogger)this.namedLoggerMap.get(name = name.intern());
        if (out == null) {
            Logger lg = Logger.getLogger(name);
            out = new Jdk14MLogger(lg);
            this.namedLoggerMap.put(name, out);
        }
        return out;
    }

    public synchronized MLogger getMLogger(Class cl) {
        return Jdk14MLog.getLogger(cl.getName());
    }

    public synchronized MLogger getMLogger() {
        if (this.global == null) {
            this.global = new Jdk14MLogger(LogManager.getLogManager().getLogger("global"));
        }
        return this.global;
    }

    private static String[] findCallingClassAndMethod() {
        for (StackTraceElement check : new Throwable().getStackTrace()) {
            String cn = check.getClassName();
            if (cn == null || cn.startsWith("com.mchange.v2.log.jdk14logging")) continue;
            return new String[]{check.getClassName(), check.getMethodName()};
        }
        return UNKNOWN_ARRAY;
    }

    private static final class Jdk14MLogger
    implements MLogger {
        volatile Logger logger;

        Jdk14MLogger(Logger logger2) {
            this.logger = logger2;
        }

        private static Level level(MLevel lvl) {
            return (Level)lvl.asJdk14Level();
        }

        public ResourceBundle getResourceBundle() {
            return this.logger.getResourceBundle();
        }

        public String getResourceBundleName() {
            return this.logger.getResourceBundleName();
        }

        public void setFilter(Object java14Filter) throws SecurityException {
            if (!(java14Filter instanceof Filter)) {
                throw new IllegalArgumentException("MLogger.setFilter( ... ) requires a java.util.logging.Filter. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.setFilter((Filter)java14Filter);
        }

        public Object getFilter() {
            return this.logger.getFilter();
        }

        public void log(MLevel l, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg);
        }

        public void log(MLevel l, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg, param);
        }

        public void log(MLevel l, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg, params);
        }

        public void log(MLevel l, String msg, Throwable t) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Jdk14MLogger.level(l), sa[0], sa[1], msg, t);
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg);
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg, param);
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg, params);
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logp(Jdk14MLogger.level(l), srcClass, srcMeth, msg, t);
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg);
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg, param);
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg, params);
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
            if (!this.logger.isLoggable(Jdk14MLogger.level(l))) {
                return;
            }
            if (srcClass == null && srcMeth == null) {
                String[] sa = Jdk14MLog.findCallingClassAndMethod();
                srcClass = sa[0];
                srcMeth = sa[1];
            }
            this.logger.logrb(Jdk14MLogger.level(l), srcClass, srcMeth, rb, msg, t);
        }

        public void entering(String srcClass, String srcMeth) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth);
        }

        public void entering(String srcClass, String srcMeth, Object param) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth, param);
        }

        public void entering(String srcClass, String srcMeth, Object[] params) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.entering(srcClass, srcMeth, params);
        }

        public void exiting(String srcClass, String srcMeth) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(srcClass, srcMeth);
        }

        public void exiting(String srcClass, String srcMeth, Object result) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.exiting(srcClass, srcMeth, result);
        }

        public void throwing(String srcClass, String srcMeth, Throwable t) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            this.logger.throwing(srcClass, srcMeth, t);
        }

        public void severe(String msg) {
            if (!this.logger.isLoggable(Level.SEVERE)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.SEVERE, sa[0], sa[1], msg);
        }

        public void warning(String msg) {
            if (!this.logger.isLoggable(Level.WARNING)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.WARNING, sa[0], sa[1], msg);
        }

        public void info(String msg) {
            if (!this.logger.isLoggable(Level.INFO)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.INFO, sa[0], sa[1], msg);
        }

        public void config(String msg) {
            if (!this.logger.isLoggable(Level.CONFIG)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.CONFIG, sa[0], sa[1], msg);
        }

        public void fine(String msg) {
            if (!this.logger.isLoggable(Level.FINE)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINE, sa[0], sa[1], msg);
        }

        public void finer(String msg) {
            if (!this.logger.isLoggable(Level.FINER)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINER, sa[0], sa[1], msg);
        }

        public void finest(String msg) {
            if (!this.logger.isLoggable(Level.FINEST)) {
                return;
            }
            String[] sa = Jdk14MLog.findCallingClassAndMethod();
            this.logger.logp(Level.FINEST, sa[0], sa[1], msg);
        }

        public void setLevel(MLevel l) throws SecurityException {
            this.logger.setLevel(Jdk14MLogger.level(l));
        }

        public MLevel getLevel() {
            return MLevel.fromIntValue(this.logger.getLevel().intValue());
        }

        public boolean isLoggable(MLevel l) {
            return this.logger.isLoggable(Jdk14MLogger.level(l));
        }

        public String getName() {
            return this.logger.getName();
        }

        public void addHandler(Object h) throws SecurityException {
            if (!(h instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.addHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.addHandler((Handler)h);
        }

        public void removeHandler(Object h) throws SecurityException {
            if (!(h instanceof Handler)) {
                throw new IllegalArgumentException("MLogger.removeHandler( ... ) requires a java.util.logging.Handler. This is not enforced by the compiler only to permit building under jdk 1.3");
            }
            this.logger.removeHandler((Handler)h);
        }

        public Object[] getHandlers() {
            return this.logger.getHandlers();
        }

        public void setUseParentHandlers(boolean uph) {
            this.logger.setUseParentHandlers(uph);
        }

        public boolean getUseParentHandlers() {
            return this.logger.getUseParentHandlers();
        }
    }
}

