/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheNaturalIdRegion;
import org.hibernate.cache.ehcache.internal.strategy.AbstractReadWriteEhcacheAccessStrategy;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ReadWriteEhcacheNaturalIdRegionAccessStrategy
extends AbstractReadWriteEhcacheAccessStrategy<EhcacheNaturalIdRegion>
implements NaturalIdRegionAccessStrategy {
    public ReadWriteEhcacheNaturalIdRegionAccessStrategy(EhcacheNaturalIdRegion region, SessionFactoryOptions settings) {
        super(region, settings);
    }

    @Override
    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region();
    }

    @Override
    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        ((EhcacheNaturalIdRegion)this.region()).writeLock(key);
        try {
            AbstractReadWriteEhcacheAccessStrategy.Lockable item = (AbstractReadWriteEhcacheAccessStrategy.Lockable)((EhcacheNaturalIdRegion)this.region()).get(key);
            if (item == null) {
                ((EhcacheNaturalIdRegion)this.region()).put(key, new AbstractReadWriteEhcacheAccessStrategy.Item(value, null, ((EhcacheNaturalIdRegion)this.region()).nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ((EhcacheNaturalIdRegion)this.region()).writeUnlock(key);
        }
    }

    @Override
    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        ((EhcacheNaturalIdRegion)this.region()).writeLock(key);
        try {
            AbstractReadWriteEhcacheAccessStrategy.Lockable item = (AbstractReadWriteEhcacheAccessStrategy.Lockable)((EhcacheNaturalIdRegion)this.region()).get(key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteEhcacheAccessStrategy.Lock lockItem = (AbstractReadWriteEhcacheAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                ((EhcacheNaturalIdRegion)this.region()).put(key, new AbstractReadWriteEhcacheAccessStrategy.Item(value, null, ((EhcacheNaturalIdRegion)this.region()).nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            ((EhcacheNaturalIdRegion)this.region()).writeUnlock(key);
        }
    }

    @Override
    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey(naturalIdValues, persister, session);
    }

    @Override
    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues(cacheKey);
    }
}

