/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import net.sourceforge.jtds.jdbc.Support;

public class ColData {
    private Object value = null;
    private boolean updated = false;
    private int length = 0;

    ColData(Object valueIn, int tdsVersion) {
        this.value = valueIn;
        if (this.value instanceof String) {
            this.length = ((String)this.value).length();
            if (tdsVersion < 3 && ((String)this.value).equals(" ")) {
                this.value = "";
                this.length = 0;
            }
        } else if (this.value instanceof byte[]) {
            this.length = ((byte[])this.value).length;
        }
    }

    ColData(ColData col) {
        this.length = col.length;
        this.updated = col.updated;
        this.value = col.value;
    }

    ColData() {
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof byte[]) {
            return Support.toHex((byte[])this.value);
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? "1" : "0";
        }
        return this.value.toString();
    }

    boolean isNull() {
        return this.value == null;
    }

    boolean isUpdated() {
        return this.updated;
    }

    void setValue(Object value) {
        this.value = value;
        this.updated = true;
    }

    Object getValue() {
        return this.value;
    }

    void setLength(int length) {
        this.length = length;
    }

    int getLength() {
        return this.length;
    }
}

