/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.JtdsReader;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.jdbc.TextPtr;
import net.sourceforge.jtds.util.Logger;
import net.sourceforge.jtds.util.ReaderInputStream;
import net.sourceforge.jtds.util.WriterOutputStream;

public class ClobImpl
implements Clob {
    private static final String EMPTY_CLOB = "";
    private final ConnectionJDBC2 _connection;
    private String _clob;
    private File _clobFile;
    private JtdsReader _jtdsReader;

    ClobImpl(Object callerReference) {
        this(callerReference, EMPTY_CLOB);
    }

    ClobImpl(Object callerReference, String clob) {
        if (clob == null) {
            throw new IllegalArgumentException("clob cannot be null.");
        }
        this._clob = clob;
        this._connection = this.getConnection(callerReference);
    }

    ClobImpl(Object callerReference, ResponseStream in, boolean ntext, boolean readTextMode) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in cannot be null.");
        }
        this._connection = this.getConnection(callerReference);
        TextPtr tp = new TextPtr();
        in.read(tp.ptr);
        in.read(tp.ts);
        tp.len = in.readInt();
        readTextMode = false;
        if (readTextMode) {
            if (ntext) {
                char[] buf = new char[tp.len / 2];
                in.read(buf);
                tp.value = buf;
                this._clob = new String((char[])tp.value);
            } else {
                byte[] bytes = new byte[tp.len];
                in.read(bytes);
                tp.value = bytes;
                this._clob = new String((byte[])tp.value);
            }
        } else {
            try {
                if ((long)tp.len < this._connection.getLobBuffer()) {
                    this._clob = ntext ? in.readString(tp.len / 2) : in.readAsciiString(tp.len);
                } else {
                    this._clob = EMPTY_CLOB;
                    Writer writer = this.setCharacterStream(1L);
                    long length = tp.len;
                    while (length > 0L) {
                        int results = (int)Math.min(1024L, length);
                        String data = ntext ? in.readString(results / 2) : in.readAsciiString(results);
                        length -= (long)results;
                        writer.write(data);
                    }
                    writer.close();
                }
                if (in.getTdsVersion() < 3 && this.length() == 1L && this.getSubString(1L, 1).equals(" ")) {
                    this.truncate(0L);
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (ntext && (tp.len & 1) != 0) {
            in.read();
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream(), "ASCII");
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        try {
            if (this._clob != null) {
                return new StringReader(this._clob);
            }
            if (this._clobFile != null) {
                return new BufferedReader(new FileReader(this._clobFile));
            }
            this._jtdsReader.reset();
            return this._jtdsReader;
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException(Messages.get("error.blobclob.badpos"), "HY090");
        }
        if (length < 0) {
            throw new SQLException(Messages.get("error.blobclob.badlen"), "HY090");
        }
        if (pos - 1L + (long)length > this.length()) {
            throw new SQLException(Messages.get("error.blobclob.lentoolong"), "HY090");
        }
        Reader reader = this.getCharacterStream();
        this.skip(reader, pos - 1L);
        try {
            int res;
            char[] buffer = new char[length];
            int bytesRead = 0;
            while ((res = reader.read(buffer, bytesRead, length - bytesRead)) != -1) {
                void var7_7;
                if ((bytesRead += var7_7) != length) continue;
                return new String(buffer);
            }
            throw new SQLException(Messages.get("error.blobclob.readlen"), "HY000");
        }
        catch (IOException ioe) {
            throw new SQLException(Messages.get("error.generic.ioread", "String", ioe.getMessage()), "HY000");
        }
    }

    public synchronized long length() throws SQLException {
        if (this._clob != null) {
            return this._clob.length();
        }
        if (this._clobFile != null) {
            return this._clobFile.length();
        }
        return this._jtdsReader.getLength();
    }

    public long position(String searchStr, long start) throws SQLException {
        return this.position(new ClobImpl(this._connection, searchStr), start);
    }

    /*
     * WARNING - void declaration
     */
    public long position(Clob searchStr, long start) throws SQLException {
        if (searchStr == null) {
            throw new SQLException(Messages.get("error.clob.searchnull"), "HY024");
        }
        try {
            Reader reader = this.getCharacterStream();
            long length = this.length() - searchStr.length();
            boolean reset = true;
            long i = start;
            while (i < length) {
                int searchValue;
                boolean found = true;
                if (reset) {
                    reader = this.getCharacterStream();
                    this.skip(reader, i);
                    reset = false;
                }
                int value = reader.read();
                Reader searchReader = searchStr.getCharacterStream();
                while ((searchValue = searchReader.read()) != -1) {
                    void var13_11;
                    if (value != var13_11) {
                        found = false;
                        break;
                    }
                    reset = true;
                }
                if (found) {
                    return i;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioread", "String", e.getMessage()), "HY000");
        }
        return -1L;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        return new WriterOutputStream(this.setCharacterStream(pos), "ASCII");
    }

    public synchronized Writer setCharacterStream(long pos) throws SQLException {
        long length = this.length();
        if (pos < 1L) {
            throw new SQLException(Messages.get("error.blobclob.badpos"), "HY024");
        }
        if (pos > length && pos != 1L) {
            throw new SQLException(Messages.get("error.blobclob.badposlen"), "HY024");
        }
        return new ClobWriter(pos, length);
    }

    public int setString(long pos, String str) throws SQLException {
        if (str == null) {
            throw new SQLException(Messages.get("error.clob.strnull"), "HY090");
        }
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        Writer writer = this.setCharacterStream(pos);
        try {
            writer.write(str, offset, len);
            writer.close();
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.iowrite", "String", e.getMessage()), "HY000");
        }
        return len;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void truncate(long len) throws SQLException {
        long currentLength = this.length();
        if (len < 0L) {
            throw new SQLException(Messages.get("error.blobclob.badlen"), "HY090");
        }
        if (len > currentLength) {
            throw new SQLException(Messages.get("error.blobclob.lentoolong"), "HY090");
        }
        if (len == currentLength) {
            return;
        }
        if (len <= this._connection.getLobBuffer()) {
            this._clob = this.getSubString(1L, (int)len);
            if (this._clobFile != null) {
                this._clobFile.delete();
                this._clobFile = null;
            }
            this._jtdsReader = null;
        } else {
            try {
                int result;
                Reader reader = this.getCharacterStream();
                File tmpFile = this._clobFile;
                this._clob = EMPTY_CLOB;
                this._clobFile = null;
                this._jtdsReader = null;
                Writer writer = this.setCharacterStream(1L);
                char[] buffer = new char[1024];
                while ((result = reader.read(buffer, 0, (int)Math.min((long)buffer.length, len))) > 0) {
                    void var9_8;
                    len -= (long)var9_8;
                    writer.write(buffer, 0, (int)var9_8);
                }
                writer.close();
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (IOException e) {
                throw new SQLException(Messages.get("error.generic.iowrite", "String", e.getMessage()), "HY000");
            }
        }
    }

    private void skip(Reader reader, long skip) throws SQLException {
        try {
            long skipped = reader.skip(skip);
            if (skipped != skip) {
                throw new SQLException(Messages.get("error.blobclob.badposlen"), "HY090");
            }
        }
        catch (IOException e) {
            throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
        }
    }

    private ConnectionJDBC2 getConnection(Object callerReference) {
        Connection connection;
        block6: {
            if (callerReference == null) {
                throw new IllegalArgumentException("callerReference cannot be null.");
            }
            try {
                if (callerReference instanceof Connection) {
                    connection = (Connection)callerReference;
                    break block6;
                }
                if (callerReference instanceof Statement) {
                    connection = ((Statement)callerReference).getConnection();
                    break block6;
                }
                if (callerReference instanceof ResultSet) {
                    connection = ((ResultSet)callerReference).getStatement().getConnection();
                    break block6;
                }
                throw new IllegalArgumentException("callerReference is invalid.");
            }
            catch (SQLException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        return (ConnectionJDBC2)connection;
    }

    protected void finalize() {
        if (this._clobFile != null) {
            this._clobFile.delete();
        }
    }

    static /* synthetic */ String access$384(ClobImpl x0, Object x1) {
        x0._clob = x0._clob + x1;
        return x0._clob;
    }

    class ClobFileWriter
    extends Writer {
        RandomAccessFile raf;
        char[] singleChar = new char[1];

        ClobFileWriter(long curPos) throws IOException {
            this.raf = new RandomAccessFile(ClobImpl.this._clobFile, "rw");
            this.raf.seek(curPos);
        }

        public void write(int c) throws IOException {
            this.singleChar[0] = (char)c;
            this.write(this.singleChar, 0, 1);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.raf == null) {
                throw new IOException("stream closed");
            }
            if (cbuf == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off > cbuf.length || off + len > cbuf.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            byte[] data = new String(cbuf, off, len).getBytes();
            this.raf.write(data, 0, data.length);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
        }
    }

    class ClobWriter
    extends Writer {
        Writer writer;
        long curPos;
        boolean securityFailure = false;

        ClobWriter(long pos, long length) throws SQLException {
            this.curPos = pos - 1L;
            try {
                if (length > ClobImpl.this._connection.getLobBuffer()) {
                    if (ClobImpl.this._clobFile == null) {
                        this.writeToDisk(ClobImpl.this.getCharacterStream());
                    }
                } else if (ClobImpl.this._jtdsReader != null) {
                    StringWriter sw = new StringWriter((int)length);
                    char[] buffer = new char[1024];
                    int result = -1;
                    while ((result = ClobImpl.this._jtdsReader.read(buffer)) != -1) {
                        sw.write(buffer, 0, result);
                    }
                    ClobImpl.this._clob = sw.toString();
                    ClobImpl.this._jtdsReader = null;
                }
                this.updateWriter();
            }
            catch (IOException e) {
                throw new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "HY000");
            }
        }

        public void write(int c) throws IOException {
            ClobImpl clobImpl = ClobImpl.this;
            synchronized (clobImpl) {
                this.checkSize(1L);
                this.writer.write(c);
                ++this.curPos;
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            ClobImpl clobImpl = ClobImpl.this;
            synchronized (clobImpl) {
                this.checkSize(len);
                this.writer.write(cbuf, off, len);
                this.curPos += (long)len;
            }
        }

        private void checkSize(long length) throws IOException {
            if (this.curPos > ClobImpl.this._connection.getLobBuffer()) {
                return;
            }
            if (ClobImpl.this._clobFile != null) {
                return;
            }
            if (this.securityFailure) {
                return;
            }
            if (this.curPos + length <= ClobImpl.this._connection.getLobBuffer()) {
                return;
            }
            if (ClobImpl.this._clob != null) {
                this.writeToDisk(new StringReader(ClobImpl.this._clob));
                this.updateWriter();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void writeToDisk(Reader reader) throws IOException {
            Writer wtr;
            block13: {
                try {
                    ClobImpl.this._clobFile = File.createTempFile("jtds", ".tmp");
                    ClobImpl.this._clobFile.deleteOnExit();
                    wtr = new BufferedWriter(new FileWriter(ClobImpl.this._clobFile));
                }
                catch (SecurityException e) {
                    this.securityFailure = true;
                    if (ClobImpl.this._clobFile != null) {
                        try {
                            ClobImpl.this._clobFile.delete();
                        }
                        catch (SecurityException ex) {
                            // empty catch block
                        }
                        ClobImpl.this._clobFile = null;
                    }
                    wtr = new StringWriter();
                    if (!Logger.isActive()) break block13;
                    Logger.println("Clob: Unable to buffer data to disk: " + e.getMessage());
                }
            }
            try {
                char[] buffer = new char[1024];
                while (true) {
                    void ex;
                    int result;
                    if ((result = reader.read(buffer)) == -1) {
                        Object var6_7 = null;
                        break;
                    }
                    wtr.write(buffer, 0, (int)ex);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                wtr.flush();
                if (wtr instanceof StringWriter) {
                    ClobImpl.this._clob = wtr.toString();
                } else {
                    ClobImpl.this._clob = null;
                }
                wtr.close();
                throw throwable;
            }
            wtr.flush();
            if (wtr instanceof StringWriter) {
                ClobImpl.this._clob = wtr.toString();
            } else {
                ClobImpl.this._clob = null;
            }
            wtr.close();
        }

        void updateWriter() throws IOException {
            if (ClobImpl.this._clob != null) {
                long startPos = this.curPos;
                this.writer = new Writer(this, startPos){
                    int curPos;
                    boolean closed;
                    char[] singleChar;
                    private final /* synthetic */ long val$startPos;
                    private final /* synthetic */ ClobWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$startPos = val$startPos;
                        this.curPos = (int)this.val$startPos;
                        this.closed = false;
                        this.singleChar = new char[1];
                    }

                    private void checkOpen() throws IOException {
                        if (this.closed) {
                            throw new IOException("stream closed");
                        }
                        if (ClobImpl.access$300(ClobWriter.access$400(this.this$1)) == null) {
                            throw new IOException(Messages.get("error.generic.iowrite", "byte", "_clob = NULL"));
                        }
                    }

                    public void write(int c) throws IOException {
                        this.checkOpen();
                        this.singleChar[0] = (char)c;
                        this.write(this.singleChar, 0, 1);
                    }

                    public void write(char[] cbuf, int off, int len) throws IOException {
                        this.checkOpen();
                        if (cbuf == null) {
                            throw new NullPointerException();
                        }
                        if (off < 0 || len < 0 || off > cbuf.length || off + len > cbuf.length || off + len < 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        if (len == 0) {
                            return;
                        }
                        if (this.curPos + 1 > ClobImpl.access$300(ClobWriter.access$400(this.this$1)).length()) {
                            ClobImpl.access$384(ClobWriter.access$400(this.this$1), new String(cbuf, off, len));
                        } else {
                            String tmpClob = ClobImpl.access$300(ClobWriter.access$400(this.this$1));
                            ClobImpl.access$302(ClobWriter.access$400(this.this$1), tmpClob.substring(0, this.curPos) + new String(cbuf, off, len));
                            if (ClobImpl.access$300(ClobWriter.access$400(this.this$1)).length() < tmpClob.length()) {
                                ClobImpl.access$384(ClobWriter.access$400(this.this$1), tmpClob.substring(this.curPos + len));
                            }
                        }
                        this.curPos += len;
                    }

                    public void flush() {
                    }

                    public void close() {
                        this.closed = true;
                    }
                };
            } else {
                this.writer = new ClobFileWriter(this.curPos);
            }
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void close() throws IOException {
            this.writer.close();
        }

        static /* synthetic */ ClobImpl access$400(ClobWriter x0) {
            return x0.ClobImpl.this;
        }
    }
}

