/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.ColData;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.MSCursorResultSet;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.NtlmAuth;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.ProtocolException;
import net.sourceforge.jtds.jdbc.RequestStream;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.jdbc.SQLDiagnostic;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TdsData;
import net.sourceforge.jtds.jdbc.TextPtr;
import net.sourceforge.jtds.util.Logger;

public class TdsCore {
    public static final int MIN_PKT_SIZE = 512;
    public static final int DEFAULT_MIN_PKT_SIZE_TDS70 = 4096;
    public static final int MAX_PKT_SIZE = 32768;
    static final int PKT_HDR_LEN = 8;
    static final byte QUERY_PKT = 1;
    static final byte LOGIN_PKT = 2;
    static final byte RPC_PKT = 3;
    static final byte REPLY_PKT = 4;
    static final byte CANCEL_PKT = 6;
    static final byte SYBQUERY_PKT = 15;
    static final byte MSLOGIN_PKT = 16;
    static final byte NTLMAUTH_PKT = 17;
    private static final byte TDS5_PARAMFMT2_TOKEN = 32;
    private static final byte TDS_LANG_TOKEN = 33;
    private static final byte TDS5_WIDE_RESULT = 97;
    private static final byte TDS_CLOSE_TOKEN = 113;
    private static final byte TDS_RETURNSTATUS_TOKEN = 121;
    private static final byte TDS_PROCID = 124;
    private static final byte TDS7_RESULT_TOKEN = -127;
    private static final byte TDS7_COMP_RESULT_TOKEN = -120;
    private static final byte TDS_COLNAME_TOKEN = -96;
    private static final byte TDS_COLFMT_TOKEN = -95;
    private static final byte TDS_TABNAME_TOKEN = -92;
    private static final byte TDS_COLINFO_TOKEN = -91;
    private static final byte TDS_OPTIONCMD_TOKEN = -90;
    private static final byte TDS_COMP_NAMES_TOKEN = -89;
    private static final byte TDS_COMP_RESULT_TOKEN = -88;
    private static final byte TDS_ORDER_TOKEN = -87;
    private static final byte TDS_ERROR_TOKEN = -86;
    private static final byte TDS_INFO_TOKEN = -85;
    private static final byte TDS_PARAM_TOKEN = -84;
    private static final byte TDS_LOGINACK_TOKEN = -83;
    private static final byte TDS_CONTROL_TOKEN = -82;
    private static final byte TDS_ROW_TOKEN = -47;
    private static final byte TDS_ALTROW = -45;
    private static final byte TDS5_PARAMS_TOKEN = -41;
    private static final byte TDS_CAP_TOKEN = -30;
    private static final byte TDS_ENVCHANGE_TOKEN = -29;
    private static final byte TDS_MSG50_TOKEN = -27;
    private static final byte TDS_DBRPC_TOKEN = -26;
    private static final byte TDS5_DYNAMIC_TOKEN = -25;
    private static final byte TDS5_PARAMFMT_TOKEN = -20;
    private static final byte TDS_AUTH_TOKEN = -19;
    private static final byte TDS_RESULT_TOKEN = -18;
    private static final byte TDS_DONE_TOKEN = -3;
    private static final byte TDS_DONEPROC_TOKEN = -2;
    private static final byte TDS_DONEINPROC_TOKEN = -1;
    private static final byte TDS_ENV_DATABASE = 1;
    private static final byte TDS_ENV_LANG = 2;
    private static final byte TDS_ENV_CHARSET = 3;
    private static final byte TDS_ENV_PACKSIZE = 4;
    private static final byte TDS_ENV_LCID = 5;
    private static final byte TDS_ENV_SQLCOLLATION = 7;
    private static final ParamInfo[] EMPTY_PARAMETER_INFO = new ParamInfo[0];
    private static final byte DONE_MORE_RESULTS = 1;
    private static final byte DONE_ERROR = 2;
    private static final byte DONE_ROW_COUNT = 16;
    static final byte DONE_CANCEL = 32;
    public static final int UNPREPARED = 0;
    public static final int TEMPORARY_STORED_PROCEDURES = 1;
    public static final int EXECUTE_SQL = 2;
    public static final int PREPARE = 3;
    public static final int PREPEXEC = 4;
    static final int SYB_LONGDATA = 1;
    static final int SYB_DATETIME = 2;
    static final int SYB_BITNULL = 4;
    static final int SYB_EXTCOLINFO = 8;
    static final int SYB_UNICODE = 16;
    private static String hostName = null;
    private ConnectionJDBC2 connection;
    private int tdsVersion;
    private int serverType;
    private SharedSocket socket;
    private RequestStream out;
    private ResponseStream in;
    private boolean endOfResponse = true;
    private boolean endOfResults = true;
    private ColInfo[] columns;
    private ColData[] rowData;
    private TableMetaData[] tables;
    private TdsToken currentToken = new TdsToken();
    private Integer returnStatus;
    private ParamInfo returnParam;
    private ParamInfo[] parameters;
    private int nextParam = -1;
    private SQLDiagnostic messages;
    private boolean isClosed = false;
    private boolean readTextMode = false;
    private static HashMap tds8SpNames = new HashMap();

    TdsCore(ConnectionJDBC2 connection, SQLDiagnostic messages) {
        this.connection = connection;
        this.socket = connection.getSocket();
        this.messages = messages;
        this.serverType = connection.getServerType();
        this.tdsVersion = this.socket.getTdsVersion();
        this.out = this.socket.getRequestStream();
        this.in = this.socket.getResponseStream(this.out);
        this.out.setBufferSize(connection.getNetPacketSize());
        this.out.setMaxPrecision(connection.getMaxPrecision());
    }

    private void checkOpen() throws SQLException {
        if (this.connection.isClosed()) {
            throw new SQLException(Messages.get("error.generic.closed", "Connection"), "HY010");
        }
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    ColInfo[] getColumns() {
        return this.columns;
    }

    ParamInfo[] getParameters() {
        if (this.currentToken.dynamParamInfo != null) {
            ParamInfo[] params = new ParamInfo[this.currentToken.dynamParamInfo.length];
            int i = 0;
            while (i < params.length) {
                ColInfo ci = this.currentToken.dynamParamInfo[i];
                ParamInfo pi = new ParamInfo();
                pi.tdsType = ci.tdsType;
                pi.scale = ci.scale;
                pi.precision = ci.precision;
                pi.name = ci.realName;
                pi.isOutput = false;
                pi.jdbcType = ci.jdbcType;
                pi.sqlType = ci.sqlType;
                params[i] = pi;
                ++i;
            }
            return params;
        }
        return EMPTY_PARAMETER_INFO;
    }

    ColData[] getRowData() {
        return this.rowData;
    }

    void login(String serverName, String database, String user, String password, String domain, String charset, String appName, String progName, String language, String macAddress, int packetSize) throws SQLException {
        try {
            if (this.tdsVersion >= 3) {
                this.sendMSLoginPkt(serverName, database, user, password, domain, appName, progName, language, macAddress, packetSize);
            } else if (this.tdsVersion == 2) {
                this.send50LoginPkt(serverName, user, password, charset, appName, progName, language, packetSize);
            } else {
                this.send42LoginPkt(serverName, user, password, charset, appName, progName, language, packetSize);
            }
            this.nextToken();
            while (!this.endOfResponse) {
                if (this.currentToken.isAuthToken()) {
                    this.sendNtlmChallengeResponse(this.currentToken.nonce, user, password, domain);
                }
                this.nextToken();
            }
            this.messages.checkErrors();
        }
        catch (IOException ioe) {
            throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", ioe.getMessage()), "08S01"), ioe);
        }
    }

    boolean getMoreResults() throws SQLException {
        this.checkOpen();
        this.nextToken();
        this.messages.checkErrors();
        while (!(this.endOfResponse || this.currentToken.isUpdateCount() || this.currentToken.isResultSet())) {
            this.nextToken();
            this.messages.checkErrors();
        }
        if (this.currentToken.isResultSet()) {
            byte saveToken = this.currentToken.token;
            try {
                byte x = (byte)this.in.peek();
                while (x == -92 || x == -91 || x == -82) {
                    this.nextToken();
                    x = (byte)this.in.peek();
                }
            }
            catch (IOException e) {
                this.connection.setClosed();
                throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "08S01"), e);
            }
            this.currentToken.token = saveToken;
        }
        this.messages.checkErrors();
        return this.currentToken.isResultSet();
    }

    boolean isResultSet() {
        return this.currentToken.isResultSet();
    }

    boolean isRowData() {
        return this.currentToken.isRowData();
    }

    boolean isUpdateCount() {
        return this.currentToken.isUpdateCount();
    }

    int getUpdateCount() {
        if (this.currentToken.isEndToken()) {
            return this.currentToken.updateCount;
        }
        return -1;
    }

    boolean isEndOfResponse() {
        return this.endOfResponse;
    }

    void clearResponseQueue() throws SQLException {
        this.checkOpen();
        while (!this.endOfResponse) {
            this.nextToken();
        }
    }

    boolean getNextRow() throws SQLException {
        if (this.endOfResponse || this.endOfResults) {
            return false;
        }
        this.checkOpen();
        this.nextToken();
        while (!this.currentToken.isRowData() && !this.currentToken.isEndToken()) {
            this.nextToken();
        }
        this.messages.checkErrors();
        return this.currentToken.isRowData();
    }

    boolean isDataInResultSet() throws SQLException {
        int x;
        this.checkOpen();
        try {
            x = (byte)(this.endOfResponse ? -3 : (byte)this.in.peek());
            while (x != -47 && x != -3 && x != -1 && x != -2) {
                this.nextToken();
                x = (byte)this.in.peek();
            }
            this.messages.checkErrors();
        }
        catch (IOException e) {
            this.connection.setClosed();
            throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", e.getMessage()), "08S01"), e);
        }
        return x == -47;
    }

    Integer getReturnStatus() {
        return this.returnStatus;
    }

    void closeConnection() {
        try {
            if (this.tdsVersion == 2) {
                this.out.setPacketType((byte)15);
                this.out.write((byte)113);
                this.out.write((byte)0);
                this.out.flush();
                this.endOfResponse = false;
                this.clearResponseQueue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() throws SQLException {
        if (!this.isClosed) {
            try {
                try {
                    this.clearResponseQueue();
                    this.out.close();
                    this.in.close();
                }
                catch (IOException ioe) {
                    this.connection.setClosed();
                    throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", ioe.getMessage()), "08S01"), ioe);
                }
                Object var3_1 = null;
                this.isClosed = true;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.isClosed = true;
                throw throwable;
            }
        }
    }

    void cancel() {
        this.socket.cancel(this.out.getStreamId());
    }

    void submitSQL(String sql) throws SQLException {
        this.checkOpen();
        if (sql.length() == 0) {
            throw new IllegalArgumentException("submitSQL() called with empty SQL String");
        }
        this.executeSQL(sql, null, null, false, 0, -1);
        this.clearResponseQueue();
        this.messages.checkErrors();
    }

    synchronized void executeSQL(String sql, String procName, ParamInfo[] parameters, boolean noMetaData, int timeOut, int maxRows) throws SQLException {
        this.checkOpen();
        this.clearResponseQueue();
        this.messages.exceptions = null;
        this.setRowCount(maxRows);
        this.messages.clearWarnings();
        this.returnStatus = null;
        if (parameters != null && parameters.length == 0) {
            parameters = null;
        }
        this.parameters = parameters;
        if (procName != null && procName.length() == 0) {
            procName = null;
        }
        if (parameters != null && parameters[0].isRetVal) {
            this.returnParam = parameters[0];
            this.returnParam.isSet = false;
            this.nextParam = 0;
        } else {
            this.returnParam = null;
            this.nextParam = -1;
        }
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                if (!parameters[i].isSet && !parameters[i].isOutput) {
                    throw new SQLException(Messages.get("error.prepare.paramnotset", Integer.toString(i + 1)), "07000");
                }
                TdsData.getNativeType(this.connection, parameters[i]);
                ++i;
            }
        }
        try {
            switch (this.tdsVersion) {
                case 1: {
                    this.executeSQL42(sql, procName, parameters, noMetaData);
                    break;
                }
                case 2: {
                    this.executeSQL50(sql, procName, parameters, noMetaData);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.executeSQL70(sql, procName, parameters, noMetaData);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown TDS version " + this.tdsVersion);
                }
            }
            this.endOfResponse = false;
            this.endOfResults = true;
            this.wait(timeOut);
        }
        catch (IOException ioe) {
            this.connection.setClosed();
            throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", ioe.getMessage()), "08S01"), ioe);
        }
    }

    String microsoftPrepare(String sql, ParamInfo[] params, int resultSetType, int resultSetConcurrency) throws SQLException {
        int prepareSql = this.connection.getPrepareSql();
        if (prepareSql == 1) {
            StringBuffer spSql = new StringBuffer(sql.length() + 64);
            String procName = this.connection.getProcName();
            spSql.append("create proc ");
            spSql.append(procName);
            spSql.append(' ');
            int i = 0;
            while (i < params.length) {
                spSql.append("@P");
                spSql.append(i);
                spSql.append(' ');
                spSql.append(params[i].sqlType);
                if (i + 1 < params.length) {
                    spSql.append(',');
                }
                ++i;
            }
            spSql.append(" as ");
            spSql.append(Support.substituteParamMarkers(sql, params));
            try {
                this.submitSQL(spSql.toString());
            }
            catch (SQLException e) {
                if ("08S01".equals(e.getSQLState())) {
                    throw e;
                }
                return null;
            }
            return procName;
        }
        if (prepareSql == 3) {
            boolean needCursor = resultSetType != 1003 || resultSetConcurrency != 1007;
            ParamInfo[] prepParam = new ParamInfo[needCursor ? 6 : 4];
            prepParam[0] = new ParamInfo();
            prepParam[0].isSet = true;
            prepParam[0].jdbcType = 4;
            prepParam[0].isOutput = true;
            prepParam[1] = new ParamInfo();
            prepParam[1].isSet = true;
            prepParam[1].jdbcType = -1;
            prepParam[1].value = Support.getParameterDefinitions(params);
            prepParam[1].length = ((String)prepParam[1].value).length();
            prepParam[1].isUnicode = true;
            prepParam[2] = new ParamInfo();
            prepParam[2].isSet = true;
            prepParam[2].jdbcType = -1;
            prepParam[2].value = Support.substituteParamMarkers(sql, params);
            prepParam[2].length = ((String)prepParam[2].value).length();
            prepParam[2].isUnicode = true;
            prepParam[3] = new ParamInfo();
            prepParam[3].isSet = true;
            prepParam[3].jdbcType = 4;
            prepParam[3].value = new Integer(1);
            if (needCursor) {
                int scrollOpt = MSCursorResultSet.getCursorScrollOpt(resultSetType, true);
                int ccOpt = MSCursorResultSet.getCursorConcurrencyOpt(resultSetConcurrency);
                prepParam[4] = new ParamInfo();
                prepParam[4].isSet = true;
                prepParam[4].jdbcType = 4;
                prepParam[4].value = new Integer(scrollOpt);
                prepParam[4].isOutput = true;
                prepParam[5] = new ParamInfo();
                prepParam[5].isSet = true;
                prepParam[5].jdbcType = 4;
                prepParam[5].value = new Integer(ccOpt);
                prepParam[5].isOutput = true;
                return null;
            }
            this.columns = null;
            this.executeSQL(null, needCursor ? "sp_cursorprepare" : "sp_prepare", prepParam, false, 0, -1);
            this.clearResponseQueue();
            Integer prepareHandle = (Integer)prepParam[0].value;
            if (prepareHandle != null) {
                return prepareHandle.toString();
            }
        }
        return null;
    }

    String sybasePrepare(String sql, ParamInfo[] params) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("sql parameter must be at least 1 character long.");
        }
        String procName = this.connection.getProcName();
        if (procName == null || procName.length() != 11) {
            throw new IllegalArgumentException("procName parameter must be 11 characters long.");
        }
        int i = 0;
        while (i < params.length) {
            if (params[i].sqlType.equals("text") || params[i].sqlType.equals("image")) {
                return null;
            }
            ++i;
        }
        try {
            this.out.setPacketType((byte)15);
            this.out.write((byte)-25);
            byte[] buf = Support.encodeString(this.connection.getCharSet(), sql);
            this.out.write((short)(buf.length + 41));
            this.out.write((byte)1);
            this.out.write((byte)0);
            this.out.write((byte)10);
            this.out.writeAscii(procName.substring(1));
            this.out.write((short)(buf.length + 26));
            this.out.writeAscii("create proc ");
            this.out.writeAscii(procName.substring(1));
            this.out.writeAscii(" as ");
            this.out.write(buf);
            this.out.flush();
            this.endOfResponse = false;
            this.clearResponseQueue();
            this.messages.checkErrors();
        }
        catch (IOException ioe) {
            this.connection.setClosed();
            throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", ioe.getMessage()), "08S01"), ioe);
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().equals("08S01")) {
                throw e;
            }
            return null;
        }
        return procName;
    }

    Object readText(String tabName, String colName, TextPtr textPtr, int offset, int length) throws SQLException {
        this.checkOpen();
        if (colName == null || colName.length() == 0 || tabName == null || tabName.length() == 0) {
            throw new SQLException(Messages.get("error.tdscore.badtext"), "HY000");
        }
        if (textPtr == null) {
            throw new SQLException(Messages.get("error.tdscore.notextptr", tabName + "." + colName), "HY000");
        }
        Object results = null;
        StringBuffer sql = new StringBuffer(256);
        sql.append("set textsize ");
        sql.append((length + 1) * 2);
        sql.append("\r\nreadtext ");
        sql.append(tabName);
        sql.append('.');
        sql.append(colName);
        sql.append(" 0x");
        sql.append(Support.toHex(textPtr.ptr));
        sql.append(' ');
        sql.append(offset);
        sql.append(' ');
        sql.append(length);
        sql.append("\r\nset textsize 1");
        if (Logger.isActive()) {
            Logger.println(sql.toString());
        }
        this.executeSQL(sql.toString(), null, null, false, 0, -1);
        this.readTextMode = true;
        if (this.getMoreResults() && this.getNextRow()) {
            results = this.rowData[0].getValue();
        }
        this.clearResponseQueue();
        this.messages.checkErrors();
        return results;
    }

    int dataLength(String tabName, String colName) throws SQLException {
        this.checkOpen();
        if (colName == null || colName.length() == 0 || tabName == null || tabName.length() == 0) {
            throw new SQLException(Messages.get("error.tdscore.badtext"), "HY000");
        }
        Object results = null;
        StringBuffer sql = new StringBuffer(128);
        sql.append("select datalength(");
        sql.append(colName);
        sql.append(") from ");
        sql.append(tabName);
        this.executeSQL(sql.toString(), null, null, false, 0, -1);
        if (this.getMoreResults() && this.getNextRow()) {
            results = this.rowData[0].getValue();
        }
        this.clearResponseQueue();
        this.messages.checkErrors();
        if (!(results instanceof Number)) {
            throw new SQLException(Messages.get("error.tdscore.badlen", tabName + "." + colName), "HY000");
        }
        return ((Number)results).intValue();
    }

    private void putLoginString(String txt, int len) throws IOException {
        byte[] tmp = Support.encodeString(this.connection.getCharSet(), txt);
        this.out.write(tmp, 0, len);
        this.out.write(tmp.length < len ? (byte)tmp.length : (byte)len);
    }

    private void send42LoginPkt(String serverName, String user, String password, String charset, String appName, String progName, String language, int packetSize) throws IOException {
        byte[] empty = new byte[]{};
        this.out.setPacketType((byte)2);
        this.putLoginString(TdsCore.getHostName(), 30);
        this.putLoginString(user, 30);
        this.putLoginString(password, 30);
        this.putLoginString("00000123", 30);
        this.out.write((byte)3);
        this.out.write((byte)1);
        this.out.write((byte)6);
        this.out.write((byte)10);
        this.out.write((byte)9);
        this.out.write((byte)1);
        this.out.write((byte)1);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write(empty, 0, 7);
        this.putLoginString(appName, 30);
        this.putLoginString(serverName, 30);
        this.out.write((byte)0);
        this.out.write((byte)password.length());
        byte[] tmp = Support.encodeString(this.connection.getCharSet(), password);
        this.out.write(tmp, 0, 253);
        this.out.write((byte)(tmp.length + 2));
        this.out.write((byte)4);
        this.out.write((byte)2);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.putLoginString(progName, 10);
        this.out.write((byte)6);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)13);
        this.out.write((byte)17);
        this.putLoginString(language, 30);
        this.out.write((byte)1);
        this.out.write((short)0);
        this.out.write((byte)0);
        this.out.write(empty, 0, 8);
        this.out.write((short)0);
        this.putLoginString(charset, 30);
        this.out.write((byte)1);
        this.putLoginString(String.valueOf(packetSize), 6);
        this.out.write(empty, 0, 8);
        this.out.flush();
        this.endOfResponse = false;
    }

    private void send50LoginPkt(String serverName, String user, String password, String charset, String appName, String progName, String language, int packetSize) throws IOException {
        byte[] empty = new byte[]{};
        this.out.setPacketType((byte)2);
        this.putLoginString(TdsCore.getHostName(), 30);
        this.putLoginString(user, 30);
        this.putLoginString(password, 30);
        this.putLoginString("00000123", 30);
        this.out.write((byte)3);
        this.out.write((byte)1);
        this.out.write((byte)6);
        this.out.write((byte)10);
        this.out.write((byte)9);
        this.out.write((byte)1);
        this.out.write((byte)1);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write(empty, 0, 7);
        this.putLoginString(appName, 30);
        this.putLoginString(serverName, 30);
        this.out.write((byte)0);
        this.out.write((byte)password.length());
        byte[] tmp = Support.encodeString(this.connection.getCharSet(), password);
        this.out.write(tmp, 0, 253);
        this.out.write((byte)(tmp.length + 2));
        this.out.write((byte)5);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.putLoginString(progName, 10);
        this.out.write((byte)5);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write((byte)13);
        this.out.write((byte)17);
        this.putLoginString(language, 30);
        this.out.write((byte)1);
        this.out.write((short)0);
        this.out.write((byte)0);
        this.out.write(empty, 0, 8);
        this.out.write((short)0);
        this.putLoginString(charset, 30);
        this.out.write((byte)1);
        this.putLoginString(String.valueOf(packetSize), 6);
        this.out.write(empty, 0, 4);
        byte[] capString = new byte[]{1, 10, 3, -124, 14, -17, 101, 127, -1, -1, -1, -42, 2, 10, 0, 2, 0, 7, -98, 6, 72, 0, 0, 0};
        this.out.write((byte)-30);
        this.out.write((short)capString.length);
        this.out.write(capString);
        this.out.flush();
        this.endOfResponse = false;
    }

    private void sendMSLoginPkt(String serverName, String database, String user, String password, String domain, String appName, String progName, String language, String macAddress, int netPacketSize) throws IOException {
        short authLen;
        byte[] empty = new byte[]{};
        String clientName = TdsCore.getHostName();
        boolean ntlmAuth = domain.length() > 0;
        short packSize = (short)(86 + 2 * (clientName.length() + appName.length() + serverName.length() + progName.length() + database.length() + language.length()));
        if (ntlmAuth) {
            authLen = (short)(32 + domain.length());
            packSize = (short)(packSize + authLen);
        } else {
            authLen = 0;
            packSize = (short)(packSize + 2 * (user.length() + password.length()));
        }
        this.out.setPacketType((byte)16);
        this.out.write((int)packSize);
        if (this.tdsVersion == 3) {
            this.out.write(0x70000000);
        } else {
            this.out.write(0x71000001);
        }
        this.out.write(netPacketSize);
        this.out.write(7);
        this.out.write(123);
        this.out.write(0);
        byte flags = 0;
        flags = (byte)(flags | 0x80);
        flags = (byte)(flags | 0x40);
        flags = (byte)(flags | 0x20);
        this.out.write(flags);
        flags = 3;
        if (ntlmAuth) {
            flags = (byte)(flags | 0x80);
        }
        this.out.write(flags);
        this.out.write((byte)0);
        this.out.write((byte)0);
        this.out.write(empty, 0, 4);
        this.out.write(empty, 0, 4);
        short curPos = 86;
        this.out.write(curPos);
        this.out.write((short)clientName.length());
        curPos = (short)(curPos + clientName.length() * 2);
        if (!ntlmAuth) {
            this.out.write(curPos);
            this.out.write((short)user.length());
            curPos = (short)(curPos + user.length() * 2);
            this.out.write(curPos);
            this.out.write((short)password.length());
            curPos = (short)(curPos + password.length() * 2);
        } else {
            this.out.write(curPos);
            this.out.write((short)0);
            this.out.write(curPos);
            this.out.write((short)0);
        }
        this.out.write(curPos);
        this.out.write((short)appName.length());
        curPos = (short)(curPos + appName.length() * 2);
        this.out.write(curPos);
        this.out.write((short)serverName.length());
        curPos = (short)(curPos + serverName.length() * 2);
        this.out.write((short)0);
        this.out.write((short)0);
        this.out.write(curPos);
        this.out.write((short)progName.length());
        curPos = (short)(curPos + progName.length() * 2);
        this.out.write(curPos);
        this.out.write((short)language.length());
        curPos = (short)(curPos + language.length() * 2);
        this.out.write(curPos);
        this.out.write((short)database.length());
        curPos = (short)(curPos + database.length() * 2);
        this.out.write(TdsCore.getMACAddress(macAddress));
        this.out.write(curPos);
        this.out.write(authLen);
        this.out.write((int)packSize);
        this.out.write(clientName);
        if (!ntlmAuth) {
            String scrambledPw = TdsCore.tds7CryptPass(password);
            this.out.write(user);
            this.out.write(scrambledPw);
        }
        this.out.write(appName);
        this.out.write(serverName);
        this.out.write(progName);
        this.out.write(language);
        this.out.write(database);
        if (ntlmAuth) {
            byte[] domainBytes = domain.getBytes("UTF8");
            byte[] header = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
            this.out.write(header);
            this.out.write(1);
            this.out.write(45569);
            this.out.write((short)domainBytes.length);
            this.out.write((short)domainBytes.length);
            this.out.write(32);
            this.out.write((short)0);
            this.out.write((short)0);
            this.out.write(32);
            this.out.write(domainBytes);
        }
        this.out.flush();
        this.endOfResponse = false;
    }

    private void sendNtlmChallengeResponse(byte[] nonce, String user, String password, String domain) throws IOException {
        this.out.setPacketType((byte)17);
        byte[] header = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
        this.out.write(header);
        this.out.write(3);
        int domainLenInBytes = domain.length() * 2;
        int userLenInBytes = user.length() * 2;
        boolean hostLenInBytes = false;
        int pos = 64 + domainLenInBytes + userLenInBytes + 0;
        this.out.write((short)24);
        this.out.write((short)24);
        this.out.write(pos);
        this.out.write((short)24);
        this.out.write((short)24);
        this.out.write(pos += 24);
        pos = 64;
        this.out.write((short)domainLenInBytes);
        this.out.write((short)domainLenInBytes);
        this.out.write(pos);
        this.out.write((short)userLenInBytes);
        this.out.write((short)userLenInBytes);
        this.out.write(pos += domainLenInBytes);
        this.out.write((short)0);
        this.out.write((short)0);
        this.out.write(pos += userLenInBytes);
        this.out.write((short)0);
        this.out.write((short)0);
        this.out.write(pos += 0);
        this.out.write(33281);
        this.out.write(domain);
        this.out.write(user);
        byte[] lmAnswer = NtlmAuth.answerLmChallenge(password, nonce);
        byte[] ntAnswer = NtlmAuth.answerNtChallenge(password, nonce);
        this.out.write(lmAnswer);
        this.out.write(ntAnswer);
        this.out.flush();
    }

    private void nextToken() throws SQLException {
        this.checkOpen();
        if (this.endOfResponse) {
            this.currentToken.token = (byte)-3;
            this.currentToken.status = 0;
            return;
        }
        try {
            this.currentToken.token = (byte)this.in.read();
            switch (this.currentToken.token) {
                case 32: {
                    this.tds5ParamFmt2Token();
                    break;
                }
                case 33: {
                    this.tdsInvalidToken();
                    break;
                }
                case 97: {
                    this.tds5WideResultToken();
                    break;
                }
                case 113: {
                    this.tdsInvalidToken();
                    break;
                }
                case 121: {
                    this.tdsReturnStatusToken();
                    break;
                }
                case 124: {
                    this.tdsProcIdToken();
                    break;
                }
                case -127: {
                    this.tds7ResultToken();
                    break;
                }
                case -120: {
                    this.tdsInvalidToken();
                    break;
                }
                case -96: {
                    this.tds4ColNamesToken();
                    break;
                }
                case -95: {
                    this.tds4ColFormatToken();
                    break;
                }
                case -92: {
                    this.tdsTableNameToken();
                    break;
                }
                case -91: {
                    this.tdsColumnInfoToken();
                    break;
                }
                case -89: {
                    this.tdsInvalidToken();
                    break;
                }
                case -88: {
                    this.tdsInvalidToken();
                    break;
                }
                case -87: {
                    this.tdsOrderByToken();
                    break;
                }
                case -86: 
                case -85: {
                    this.tdsErrorToken();
                    break;
                }
                case -84: {
                    this.tdsOutputParamToken();
                    break;
                }
                case -83: {
                    this.tdsLoginAckToken();
                    break;
                }
                case -82: {
                    this.tdsControlToken();
                    break;
                }
                case -47: {
                    this.tdsRowToken();
                    break;
                }
                case -45: {
                    this.tdsInvalidToken();
                    break;
                }
                case -41: {
                    this.tds5ParamsToken();
                    break;
                }
                case -30: {
                    this.tdsCapabilityToken();
                    break;
                }
                case -29: {
                    this.tdsEnvChangeToken();
                    break;
                }
                case -27: {
                    this.tds5ErrorToken();
                    break;
                }
                case -25: {
                    this.tds5DynamicToken();
                    break;
                }
                case -20: {
                    this.tds5ParamFmtToken();
                    break;
                }
                case -19: {
                    this.tdsNtlmAuthToken();
                    break;
                }
                case -18: {
                    this.tds5ResultToken();
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    this.tdsDoneToken();
                    break;
                }
                default: {
                    throw new ProtocolException("Invalid packet type 0x" + Integer.toHexString(this.currentToken.token));
                }
            }
        }
        catch (IOException ioe) {
            this.connection.setClosed();
            throw Support.linkException(new SQLException(Messages.get("error.generic.ioerror", ioe.getMessage()), "08S01"), ioe);
        }
        catch (ProtocolException pe) {
            this.connection.setClosed();
            throw Support.linkException(new SQLException(Messages.get("error.generic.tdserror", pe.getMessage()), "08S01"), pe);
        }
    }

    private void tdsInvalidToken() throws IOException, ProtocolException {
        this.in.skip(this.in.readShort());
        throw new ProtocolException("Unsupported TDS token: 0x" + Integer.toHexString(this.currentToken.token & 0xFF));
    }

    private void tds5ParamFmt2Token() throws IOException, ProtocolException {
        this.in.readInt();
        int paramCnt = this.in.readShort();
        ColInfo[] params = new ColInfo[paramCnt];
        int i = 0;
        while (i < paramCnt) {
            ColInfo col = new ColInfo();
            int colNameLen = this.in.read();
            col.realName = this.in.readString(colNameLen);
            int column_flags = this.in.readInt();
            col.isCaseSensitive = false;
            col.nullable = (column_flags & 0x20) != 0 ? 1 : 0;
            col.isWriteable = (column_flags & 0x10) != 0;
            col.isIdentity = (column_flags & 0x40) != 0;
            col.isKey = (column_flags & 2) != 0;
            col.isHidden = (column_flags & 1) != 0;
            col.userType = this.in.readInt();
            TdsData.readType(this.in, col);
            this.in.skip(1);
            params[i] = col;
            ++i;
        }
        this.currentToken.previousToken = 32;
        this.currentToken.dynamParamInfo = params;
        this.currentToken.dynamParamData = new ColData[paramCnt];
    }

    private void tds5WideResultToken() throws IOException, ProtocolException {
        this.in.readInt();
        int colCnt = this.in.readShort();
        this.columns = new ColInfo[colCnt];
        this.rowData = new ColData[colCnt];
        this.tables = null;
        int colNum = 0;
        while (colNum < colCnt) {
            ColInfo col = new ColInfo();
            int nameLen = this.in.read();
            col.name = this.in.readString(nameLen);
            nameLen = this.in.read();
            col.catalog = this.in.readString(nameLen);
            nameLen = this.in.read();
            col.schema = this.in.readString(nameLen);
            nameLen = this.in.read();
            col.tableName = this.in.readString(nameLen);
            nameLen = this.in.read();
            col.realName = this.in.readString(nameLen);
            if (col.name == null || col.name.length() == 0) {
                col.name = col.realName;
            }
            int column_flags = this.in.readInt();
            col.isCaseSensitive = false;
            col.nullable = (column_flags & 0x20) != 0 ? 1 : 0;
            col.isWriteable = (column_flags & 0x10) != 0;
            col.isIdentity = (column_flags & 0x40) != 0;
            col.isKey = (column_flags & 2) != 0;
            col.isHidden = (column_flags & 1) != 0;
            col.userType = this.in.readInt();
            TdsData.readType(this.in, col);
            this.in.skip(1);
            this.columns[colNum] = col;
            ++colNum;
        }
        this.endOfResults = false;
    }

    private void tdsReturnStatusToken() throws IOException {
        this.returnStatus = new Integer(this.in.readInt());
        if (this.returnParam != null) {
            this.returnParam.jdbcType = 4;
            this.returnParam.value = this.returnStatus;
            this.returnParam.isSet = true;
        }
    }

    private void tdsProcIdToken() throws IOException {
        this.in.skip(8);
    }

    private void tds7ResultToken() throws IOException, ProtocolException {
        this.endOfResults = false;
        int colCnt = this.in.readShort();
        if (colCnt < 0) {
            return;
        }
        this.columns = new ColInfo[colCnt];
        this.rowData = new ColData[colCnt];
        this.tables = null;
        int i = 0;
        while (i < colCnt) {
            ColInfo col = new ColInfo();
            col.userType = this.in.readShort();
            short flags = this.in.readShort();
            col.nullable = (flags & 1) != 0 ? 1 : 0;
            col.isCaseSensitive = (flags & 2) != 0;
            col.isIdentity = (flags & 0x10) != 0;
            col.isWriteable = (flags & 0xC) != 0;
            TdsData.readType(this.in, col);
            int clen = this.in.read();
            col.name = col.realName = this.in.readString(clen);
            this.columns[i] = col;
            ++i;
        }
    }

    private void tds4ColNamesToken() throws IOException {
        ArrayList<ColInfo> colList = new ArrayList<ColInfo>();
        int pktLen = this.in.readShort();
        this.tables = null;
        int bytesRead = 0;
        while (bytesRead < pktLen) {
            ColInfo col = new ColInfo();
            int nameLen = this.in.read();
            String name = this.in.readString(nameLen);
            bytesRead = bytesRead + 1 + nameLen;
            col.realName = name;
            col.name = name;
            colList.add(col);
        }
        int colCnt = colList.size();
        this.columns = colList.toArray(new ColInfo[colCnt]);
        this.rowData = new ColData[colCnt];
    }

    private void tds4ColFormatToken() throws IOException, ProtocolException {
        int pktLen = this.in.readShort();
        int bytesRead = 0;
        int numColumns = 0;
        while (bytesRead < pktLen) {
            if (numColumns > this.columns.length) {
                throw new ProtocolException("Too many columns in TDS_COL_FMT packet");
            }
            ColInfo col = this.columns[numColumns];
            if (this.serverType == 1) {
                col.userType = this.in.readShort();
                short flags = this.in.readShort();
                col.nullable = (flags & 1) != 0 ? 1 : 0;
                col.isCaseSensitive = (flags & 2) != 0;
                col.isWriteable = (flags & 0xC) != 0;
                col.isIdentity = (flags & 0x10) != 0;
            } else {
                col.isCaseSensitive = false;
                col.isWriteable = true;
                if (col.nullable == 0) {
                    col.nullable = 2;
                }
                col.userType = this.in.readInt();
            }
            bytesRead += 4;
            bytesRead += TdsData.readType(this.in, col);
            ++numColumns;
        }
        if (numColumns != this.columns.length) {
            throw new ProtocolException("Too few columns in TDS_COL_FMT packet");
        }
        this.endOfResults = false;
    }

    private void tdsTableNameToken() throws IOException, ProtocolException {
        int pktLen = this.in.readShort();
        int bytesRead = 0;
        ArrayList<TableMetaData> tableList = new ArrayList<TableMetaData>();
        while (bytesRead < pktLen) {
            TableMetaData table;
            block15: {
                String tabName;
                int nameLen;
                block14: {
                    if (this.tdsVersion < 5) break block14;
                    table = new TableMetaData();
                    ++bytesRead;
                    switch (this.in.read()) {
                        case 3: {
                            nameLen = this.in.readShort();
                            bytesRead += nameLen * 2 + 2;
                            table.catalog = this.in.readString(nameLen);
                        }
                        case 2: {
                            nameLen = this.in.readShort();
                            bytesRead += nameLen * 2 + 2;
                            table.schema = this.in.readString(nameLen);
                        }
                        case 1: {
                            nameLen = this.in.readShort();
                            bytesRead += nameLen * 2 + 2;
                            table.name = this.in.readString(nameLen);
                        }
                        case 0: {
                            break block15;
                        }
                        default: {
                            throw new ProtocolException("Invalid table TAB_NAME_TOKEN");
                        }
                    }
                }
                if (this.tdsVersion >= 3) {
                    nameLen = this.in.readShort();
                    bytesRead += nameLen * 2 + 2;
                    tabName = this.in.readString(nameLen);
                } else {
                    nameLen = this.in.read();
                    ++bytesRead;
                    if (nameLen == 0) break;
                    tabName = this.in.readString(nameLen);
                    bytesRead += nameLen;
                }
                table = new TableMetaData();
                int dotPos = tabName.lastIndexOf(46);
                if (dotPos > 0) {
                    table.name = tabName.substring(dotPos + 1);
                    int nextPos = tabName.lastIndexOf(46, dotPos - 1);
                    if (nextPos + 1 < dotPos) {
                        table.schema = tabName.substring(nextPos + 1, dotPos);
                    }
                    if ((nextPos = tabName.lastIndexOf(46, (dotPos = nextPos) - 1)) + 1 < dotPos) {
                        table.catalog = tabName.substring(nextPos + 1, dotPos);
                    }
                } else {
                    table.name = tabName;
                }
            }
            tableList.add(table);
        }
        if (tableList.size() > 0) {
            this.tables = tableList.toArray(new TableMetaData[tableList.size()]);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tdsColumnInfoToken() throws IOException, ProtocolException {
        block4: {
            pktLen = this.in.readShort();
            bytesRead = 0;
            if (this.tables != null) ** GOTO lbl29
            this.in.skip(pktLen);
            break block4;
lbl-1000:
            // 1 sources

            {
                columnIndex = this.in.read();
                if (columnIndex < 1 || columnIndex > this.columns.length) {
                    throw new ProtocolException("Column index " + columnIndex + " invalid in TDS_COLINFO packet");
                }
                col = this.columns[columnIndex - 1];
                tableIndex = this.in.read();
                if (tableIndex > this.tables.length) {
                    throw new ProtocolException("Table index " + tableIndex + " invalid in TDS_COLINFO packet");
                }
                flags = (byte)this.in.read();
                bytesRead += 3;
                if (tableIndex != 0) {
                    table = this.tables[tableIndex - 1];
                    col.catalog = table.catalog;
                    col.schema = table.schema;
                    col.tableName = table.name;
                }
                col.isKey = (flags & 8) != 0;
                v0 = col.isHidden = (flags & 16) != 0;
                if ((flags & 32) == 0) continue;
                nameLen = this.in.read();
                ++bytesRead;
                colName = this.in.readString(nameLen);
                bytesRead += this.tdsVersion >= 3 ? nameLen * 2 : nameLen;
                col.realName = colName;
lbl29:
                // 3 sources

                ** while (bytesRead < pktLen)
            }
        }
    }

    private void tdsOrderByToken() throws IOException {
        short pktLen = this.in.readShort();
        this.in.skip(pktLen);
    }

    private void tdsErrorToken() throws IOException {
        short pktLen = this.in.readShort();
        int sizeSoFar = 6;
        int number = this.in.readInt();
        int state = this.in.read();
        int severity = this.in.read();
        int msgLen = this.in.readShort();
        String message = this.in.readString(msgLen);
        sizeSoFar += 2 + (this.tdsVersion >= 3 ? msgLen * 2 : msgLen);
        int srvNameLen = this.in.read();
        String server = this.in.readString(srvNameLen);
        sizeSoFar += 1 + (this.tdsVersion >= 3 ? srvNameLen * 2 : srvNameLen);
        int procNameLen = this.in.read();
        String procName = this.in.readString(procNameLen);
        sizeSoFar += 1 + (this.tdsVersion >= 3 ? procNameLen * 2 : procNameLen);
        short line = this.in.readShort();
        if (pktLen - (sizeSoFar += 2) > 0) {
            this.in.skip(pktLen - sizeSoFar);
        }
        if (this.currentToken.token == -86) {
            if (severity < 10) {
                severity = 11;
            }
            this.messages.addDiagnostic(number, state, severity, message, server, procName, line);
        } else {
            if (severity > 9) {
                severity = 9;
            }
            this.messages.addDiagnostic(number, state, severity, message, server, procName, line);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tdsOutputParamToken() throws IOException, ProtocolException, SQLException {
        block5: {
            this.in.readShort();
            this.in.readString(this.in.read());
            this.in.skip(5);
            col = new ColInfo();
            TdsData.readType(this.in, col);
            value = TdsData.readData(this.connection, this.in, col, false);
            if (this.parameters == null) break block5;
            if (this.tdsVersion < 4 || this.returnParam == null || this.returnParam.isSet) ** GOTO lbl28
            if (value != null) {
                this.parameters[this.nextParam].value = Support.convert(this.connection, value, this.parameters[this.nextParam].jdbcType, this.connection.getCharSet());
                this.parameters[this.nextParam].collation = col.collation;
            } else {
                this.parameters[this.nextParam].value = null;
            }
            this.parameters[this.nextParam].isSet = true;
            break block5;
lbl-1000:
            // 1 sources

            {
                if (!this.parameters[this.nextParam].isOutput) continue;
                if (value != null) {
                    this.parameters[this.nextParam].value = Support.convert(this.connection, value, this.parameters[this.nextParam].jdbcType, this.connection.getCharSet());
                    this.parameters[this.nextParam].collation = col.collation;
                } else {
                    this.parameters[this.nextParam].value = null;
                }
                this.parameters[this.nextParam].isSet = true;
                break;
lbl28:
                // 2 sources

                ** while (++this.nextParam < this.parameters.length)
            }
        }
    }

    private void tdsLoginAckToken() throws IOException {
        int minor;
        int major;
        int build = 0;
        this.in.readShort();
        int ack = this.in.read();
        this.tdsVersion = TdsData.getTdsVersion(this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read());
        this.socket.setTdsVersion(this.tdsVersion);
        String product = this.in.readString(this.in.read());
        if (this.tdsVersion >= 3) {
            major = this.in.read();
            minor = this.in.read();
            build = this.in.read() << 8;
            build += this.in.read();
        } else {
            if (product.toLowerCase().startsWith("microsoft")) {
                this.in.skip(1);
                major = this.in.read();
                minor = this.in.read();
            } else {
                major = this.in.read();
                minor = this.in.read() * 10;
                minor += this.in.read();
            }
            this.in.skip(1);
        }
        if (product.length() > 1 && -1 != product.indexOf(0)) {
            product = product.substring(0, product.indexOf(0));
        }
        this.connection.setDBServerInfo(product, major, minor, build);
        if (this.tdsVersion == 2 && ack != 5) {
            this.messages.addDiagnostic(4002, 0, 14, "Login failed", "", "", 0);
            this.currentToken.token = (byte)-86;
        }
    }

    private void tdsControlToken() throws IOException {
        short pktLen = this.in.readShort();
        this.in.skip(pktLen);
    }

    private void tdsRowToken() throws IOException, ProtocolException {
        int i = 0;
        while (i < this.columns.length) {
            this.rowData[i] = new ColData(TdsData.readData(this.connection, this.in, this.columns[i], this.readTextMode), this.tdsVersion);
            ++i;
        }
        this.endOfResults = false;
        this.readTextMode = false;
    }

    private void tds5ParamsToken() throws IOException, ProtocolException, SQLException {
        if (this.currentToken.dynamParamInfo == null) {
            throw new ProtocolException("TDS 5 Param results token (0xD7) not preceded by param format (0xEC or 0X20).");
        }
        int i = 0;
        while (i < this.currentToken.dynamParamData.length) {
            this.currentToken.dynamParamData[i] = new ColData(TdsData.readData(this.connection, this.in, this.currentToken.dynamParamInfo[i], false), this.tdsVersion);
            if (this.parameters != null && this.currentToken.previousToken == 32) {
                while (++this.nextParam < this.parameters.length) {
                    if (!this.parameters[this.nextParam].isOutput) continue;
                    Object value = this.currentToken.dynamParamData[i].getValue();
                    if (value != null) {
                        this.parameters[this.nextParam].value = Support.convert(this.connection, value, this.parameters[this.nextParam].jdbcType, this.connection.getCharSet());
                        break;
                    }
                    this.parameters[this.nextParam].value = null;
                    break;
                }
            }
            ++i;
        }
    }

    private void tdsCapabilityToken() throws IOException, ProtocolException {
        this.in.readShort();
        if (this.in.read() != 1) {
            throw new ProtocolException("TDS_CAPABILITY: expected request string");
        }
        int capLen = this.in.read();
        if (capLen != 10) {
            throw new ProtocolException("TDS_CAPABILITY: byte count not 10");
        }
        byte[] capRequest = new byte[10];
        this.in.read(capRequest);
        if (this.in.read() != 2) {
            throw new ProtocolException("TDS_CAPABILITY: expected response string");
        }
        capLen = this.in.read();
        if (capLen != 10) {
            throw new ProtocolException("TDS_CAPABILITY: byte count not 10");
        }
        byte[] capResponse = new byte[10];
        this.in.read(capResponse);
        int capMask = 0;
        if ((capRequest[6] & 0x30) == 48) {
            capMask |= 1;
        }
        if ((capRequest[0] & 3) == 3) {
            capMask |= 2;
        }
        if ((capRequest[2] & 2) == 2) {
            capMask |= 8;
        }
        if ((capRequest[3] & 4) == 4) {
            capMask |= 4;
        }
        if ((capRequest[1] & 0x80) == 128) {
            capMask |= 0x10;
        }
        this.connection.setSybaseInfo(capMask);
    }

    private void tdsEnvChangeToken() throws IOException, SQLException {
        short len = this.in.readShort();
        int type = this.in.read();
        switch (type) {
            case 1: {
                int clen = this.in.read();
                String newDb = this.in.readString(clen);
                clen = this.in.read();
                String oldDb = this.in.readString(clen);
                this.connection.setDatabase(newDb, oldDb);
                break;
            }
            case 2: {
                int clen = this.in.read();
                String language = this.in.readString(clen);
                clen = this.in.read();
                String oldLang = this.in.readString(clen);
                if (!Logger.isActive()) break;
                Logger.println("Language changed from " + oldLang + " to " + language);
                break;
            }
            case 3: {
                int clen = this.in.read();
                String charset = this.in.readString(clen);
                if (this.tdsVersion >= 3) {
                    this.in.skip(len - 2 - clen * 2);
                } else {
                    this.in.skip(len - 2 - clen);
                }
                this.connection.setCharset(charset);
                break;
            }
            case 4: {
                int clen = this.in.read();
                int blocksize = Integer.parseInt(this.in.readString(clen));
                if (this.tdsVersion >= 3) {
                    this.in.skip(len - 2 - clen * 2);
                } else {
                    this.in.skip(len - 2 - clen);
                }
                this.connection.setNetPacketSize(blocksize);
                this.out.setBufferSize(blocksize);
                if (!Logger.isActive()) break;
                Logger.println("Changed blocksize to " + blocksize);
                break;
            }
            case 5: {
                this.in.skip(len - 1);
                break;
            }
            case 7: {
                int clen = this.in.read();
                byte[] collation = new byte[5];
                if (clen == 5) {
                    this.in.read(collation);
                    this.connection.setCollation(collation);
                    if (Logger.isActive()) {
                        Logger.println("Collation changed to 0x" + Support.toHex(collation));
                    }
                } else {
                    this.in.skip(clen);
                }
                clen = this.in.read();
                this.in.skip(clen);
                break;
            }
            default: {
                if (Logger.isActive()) {
                    Logger.println("Unknown environment change type 0x" + Integer.toHexString(type));
                }
                this.in.skip(len - 1);
            }
        }
    }

    private void tds5ErrorToken() throws IOException {
        short pktLen = this.in.readShort();
        int sizeSoFar = 6;
        int number = this.in.readInt();
        int state = this.in.read();
        int severity = this.in.read();
        int stateLen = this.in.read();
        this.in.readString(stateLen);
        this.in.read();
        this.in.readShort();
        sizeSoFar += 4 + stateLen;
        short msgLen = this.in.readShort();
        String message = this.in.readString(msgLen);
        sizeSoFar += 2 + msgLen;
        int srvNameLen = this.in.read();
        String server = this.in.readString(srvNameLen);
        sizeSoFar += 1 + srvNameLen;
        int procNameLen = this.in.read();
        String procName = this.in.readString(procNameLen);
        sizeSoFar += 1 + procNameLen;
        short line = this.in.readShort();
        if (pktLen - (sizeSoFar += 2) > 0) {
            this.in.skip(pktLen - sizeSoFar);
        }
        if (severity > 10) {
            this.messages.addDiagnostic(number, state, severity, message, server, procName, line);
        } else {
            this.messages.addDiagnostic(number, state, severity, message, server, procName, line);
        }
    }

    private void tds5DynamicToken() throws IOException {
        int pktLen = this.in.readShort();
        byte type = (byte)this.in.read();
        this.in.read();
        pktLen -= 2;
        if (type == 32) {
            int len = this.in.read();
            this.currentToken.dynamicId = this.in.readString(len);
            pktLen -= len + 1;
        }
        this.in.skip(pktLen);
    }

    private void tds5ParamFmtToken() throws IOException, ProtocolException {
        this.in.readShort();
        int paramCnt = this.in.readShort();
        ColInfo[] params = new ColInfo[paramCnt];
        int i = 0;
        while (i < paramCnt) {
            ColInfo col = new ColInfo();
            int colNameLen = this.in.read();
            col.realName = this.in.readString(colNameLen);
            int column_flags = this.in.read();
            col.isCaseSensitive = false;
            col.nullable = (column_flags & 0x20) != 0 ? 1 : 0;
            col.isWriteable = (column_flags & 0x10) != 0;
            col.isIdentity = (column_flags & 0x40) != 0;
            col.isKey = (column_flags & 2) != 0;
            col.isHidden = (column_flags & 1) != 0;
            col.userType = this.in.readInt();
            if ((byte)this.in.peek() == -3) {
                this.currentToken.dynamParamInfo = null;
                this.currentToken.dynamParamData = null;
                this.messages.addDiagnostic(9999, 0, 16, "Prepare failed", "", "", 0);
                return;
            }
            TdsData.readType(this.in, col);
            this.in.skip(1);
            params[i] = col;
            ++i;
        }
        this.currentToken.previousToken = -20;
        this.currentToken.dynamParamInfo = params;
        this.currentToken.dynamParamData = new ColData[paramCnt];
    }

    private void tdsNtlmAuthToken() throws IOException, ProtocolException {
        short hdrLen;
        short pktLen = this.in.readShort();
        if (pktLen < (hdrLen = 40)) {
            throw new ProtocolException("NTLM challenge: packet is too small:" + pktLen);
        }
        this.in.skip(8);
        int seq = this.in.readInt();
        if (seq != 2) {
            throw new ProtocolException("NTLM challenge: got unexpected sequence number:" + seq);
        }
        this.in.skip(4);
        this.in.skip(4);
        this.in.skip(4);
        this.currentToken.nonce = new byte[8];
        this.in.read(this.currentToken.nonce);
        this.in.skip(8);
        this.in.skip(pktLen - hdrLen);
    }

    private void tds5ResultToken() throws IOException, ProtocolException {
        this.in.readShort();
        int colCnt = this.in.readShort();
        this.columns = new ColInfo[colCnt];
        this.rowData = new ColData[colCnt];
        this.tables = null;
        int colNum = 0;
        while (colNum < colCnt) {
            ColInfo col = new ColInfo();
            int colNameLen = this.in.read();
            col.name = col.realName = this.in.readString(colNameLen);
            int column_flags = this.in.read();
            col.isCaseSensitive = false;
            col.nullable = (column_flags & 0x20) != 0 ? 1 : 0;
            col.isWriteable = (column_flags & 0x10) != 0;
            col.isIdentity = (column_flags & 0x40) != 0;
            col.isKey = (column_flags & 2) != 0;
            col.isHidden = (column_flags & 1) != 0;
            col.userType = this.in.readInt();
            TdsData.readType(this.in, col);
            this.in.skip(1);
            this.columns[colNum] = col;
            ++colNum;
        }
        this.endOfResults = false;
    }

    private void tdsDoneToken() throws IOException {
        this.currentToken.status = (byte)this.in.read();
        this.in.skip(1);
        this.currentToken.operation = (byte)this.in.read();
        this.in.skip(1);
        this.currentToken.updateCount = this.in.readInt();
        if (!this.endOfResults) {
            this.currentToken.status = (byte)(this.currentToken.status & 0xFFFFFFEF);
            this.endOfResults = true;
        }
        if ((this.currentToken.status & 1) == 0) {
            this.endOfResponse = true;
        }
        if (this.serverType == 1) {
            switch (this.currentToken.operation) {
                case -58: 
                case -57: 
                case -40: 
                case -33: {
                    this.currentToken.status = (byte)(this.currentToken.status | 0x10);
                    break;
                }
                case -63: {
                    this.currentToken.status = (byte)(this.currentToken.status & 0xFFFFFFEF);
                }
            }
        }
        if ((this.currentToken.status & 0x20) != 0) {
            this.messages.addDiagnostic(9999, 0, 14, "Request cancelled", "", "", 0);
        }
    }

    private void executeSQL42(String sql, String procName, ParamInfo[] parameters, boolean noMetaData) throws IOException, SQLException {
        if (procName != null) {
            this.out.setPacketType((byte)3);
            byte[] buf = Support.encodeString(this.connection.getCharSet(), procName);
            this.out.write((byte)buf.length);
            this.out.write(buf);
            this.out.write(noMetaData ? (short)2 : 0);
            if (parameters != null) {
                int i = this.nextParam + 1;
                while (i < parameters.length) {
                    if (parameters[i].name != null) {
                        buf = Support.encodeString(this.connection.getCharSet(), parameters[i].name);
                        this.out.write((byte)buf.length);
                        this.out.write(buf);
                    } else {
                        this.out.write((byte)0);
                    }
                    this.out.write(parameters[i].isOutput ? (byte)1 : 0);
                    TdsData.writeParam(this.out, this.connection.getCharSet(), this.connection.isWideChar(), null, parameters[i]);
                    ++i;
                }
            }
        } else if (sql.length() > 0) {
            if (parameters != null) {
                sql = Support.substituteParameters(sql, parameters, this.tdsVersion);
            }
            this.out.setPacketType((byte)1);
            this.out.write(sql);
        }
        this.out.flush();
    }

    private void executeSQL50(String sql, String procName, ParamInfo[] parameters, boolean noMetaData) throws IOException, SQLException {
        byte[] buf;
        boolean haveParams = parameters != null;
        boolean useParamNames = false;
        this.currentToken.previousToken = 0;
        this.currentToken.dynamParamInfo = null;
        this.currentToken.dynamParamData = null;
        int i = 0;
        while (haveParams && i < parameters.length) {
            if (parameters[i].sqlType.equals("text") || parameters[i].sqlType.equals("image")) {
                if (procName != null && procName.length() > 0) {
                    if (parameters[i].sqlType.equals("text")) {
                        throw new SQLException(Messages.get("error.chartoolong"), "HY000");
                    }
                    throw new SQLException(Messages.get("error.bintoolong"), "HY000");
                }
                sql = Support.substituteParameters(sql, parameters, this.tdsVersion);
                haveParams = false;
                procName = null;
                break;
            }
            ++i;
        }
        this.out.setPacketType((byte)15);
        if (procName == null) {
            this.out.write((byte)33);
            if (haveParams) {
                sql = Support.substituteParamMarkers(sql, parameters);
            }
            if (this.socket.isWideChars()) {
                buf = Support.encodeString(this.connection.getCharSet(), sql);
                this.out.write(buf.length + 1);
                this.out.write(haveParams ? (byte)1 : 0);
                this.out.write(buf);
            } else {
                this.out.write(sql.length() + 1);
                this.out.write(haveParams ? (byte)1 : 0);
                this.out.write(sql);
            }
        } else if (procName.startsWith("#jtds")) {
            this.out.write((byte)-25);
            this.out.write((short)(procName.length() + 4));
            this.out.write((byte)2);
            this.out.write(haveParams ? (byte)1 : 0);
            this.out.write((byte)(procName.length() - 1));
            this.out.write(procName.substring(1));
            this.out.write((short)0);
        } else {
            buf = Support.encodeString(this.socket.getCharset(), procName);
            this.out.write((byte)-26);
            this.out.write((short)(buf.length + 3));
            this.out.write((byte)buf.length);
            this.out.write(buf);
            this.out.write(haveParams ? (short)2 : 0);
            useParamNames = true;
        }
        if (haveParams) {
            this.out.write((byte)-20);
            int len = 2;
            int i2 = this.nextParam + 1;
            while (i2 < parameters.length) {
                len += TdsData.getTds5ParamSize(this.connection.getCharSet(), this.connection.isWideChar(), parameters[i2], useParamNames);
                ++i2;
            }
            this.out.write((short)len);
            this.out.write(this.nextParam < 0 ? (short)parameters.length : (short)(parameters.length - 1));
            int i3 = this.nextParam + 1;
            while (i3 < parameters.length) {
                TdsData.writeTds5ParamFmt(this.out, this.connection.getCharSet(), this.connection.isWideChar(), parameters[i3], useParamNames);
                ++i3;
            }
            this.out.write((byte)-41);
            int i4 = this.nextParam + 1;
            while (i4 < parameters.length) {
                TdsData.writeTds5Param(this.out, this.connection.getCharSet(), this.connection.isWideChar(), parameters[i4]);
                ++i4;
            }
        }
        this.out.flush();
    }

    public static boolean isPreparedProcedureName(String procName) {
        return procName != null && procName.length() > 0 && Character.isDigit(procName.charAt(0));
    }

    private void executeSQL70(String sql, String procName, ParamInfo[] parameters, boolean noMetaData) throws IOException, SQLException {
        ParamInfo[] params;
        int prepareSql = this.connection.getPrepareSql();
        if (parameters == null && (prepareSql == 2 || prepareSql == 3 || prepareSql == 4)) {
            prepareSql = 0;
        }
        if (TdsCore.isPreparedProcedureName(procName)) {
            if (parameters != null) {
                params = new ParamInfo[1 + parameters.length];
                System.arraycopy(parameters, 0, params, 1, parameters.length);
            } else {
                params = new ParamInfo[]{new ParamInfo()};
            }
            params[0].jdbcType = 4;
            params[0].bufferSize = 4;
            params[0].isSet = true;
            params[0].isUnicode = false;
            params[0].value = new Integer(procName);
            TdsData.getNativeType(this.connection, params[0]);
            parameters = params;
            procName = "sp_execute";
        } else if (procName == null) {
            if (prepareSql == 4) {
                params = new ParamInfo[3 + parameters.length];
                System.arraycopy(parameters, 0, params, 3, parameters.length);
                params[0] = new ParamInfo();
                params[0].isSet = true;
                params[0].jdbcType = 4;
                params[0].isOutput = true;
                TdsData.getNativeType(this.connection, params[0]);
                params[1] = new ParamInfo();
                params[1].isSet = true;
                params[1].jdbcType = -1;
                params[1].value = Support.getParameterDefinitions(parameters);
                params[1].length = ((String)params[1].value).length();
                params[1].isUnicode = true;
                TdsData.getNativeType(this.connection, params[1]);
                params[2] = new ParamInfo();
                params[2].isSet = true;
                params[2].jdbcType = -1;
                params[2].value = Support.substituteParamMarkers(sql, parameters);
                params[2].length = ((String)params[2].value).length();
                params[2].isUnicode = true;
                TdsData.getNativeType(this.connection, params[2]);
                parameters = params;
                procName = "sp_prepexec";
            } else if (prepareSql != 0 && parameters != null) {
                params = new ParamInfo[2 + parameters.length];
                System.arraycopy(parameters, 0, params, 2, parameters.length);
                params[0] = new ParamInfo();
                params[0].jdbcType = 12;
                params[0].isSet = true;
                params[0].isUnicode = true;
                params[0].value = Support.substituteParamMarkers(sql, parameters);
                params[0].length = ((String)params[0].value).length();
                TdsData.getNativeType(this.connection, params[0]);
                params[1] = new ParamInfo();
                params[1].jdbcType = 12;
                params[1].isSet = true;
                params[1].isUnicode = true;
                params[1].value = Support.getParameterDefinitions(parameters);
                params[1].length = ((String)params[1].value).length();
                TdsData.getNativeType(this.connection, params[1]);
                parameters = params;
                procName = "sp_executesql";
            }
        }
        if (procName != null) {
            Integer shortcut;
            this.out.setPacketType((byte)3);
            if (this.tdsVersion >= 4 && (shortcut = (Integer)tds8SpNames.get(procName)) != null) {
                this.out.write((short)-1);
                this.out.write(shortcut.shortValue());
            } else {
                this.out.write((short)procName.length());
                this.out.write(procName);
            }
            this.out.write(noMetaData ? (short)2 : 0);
            if (parameters != null) {
                int i = this.nextParam + 1;
                while (i < parameters.length) {
                    if (parameters[i].name != null) {
                        this.out.write((byte)parameters[i].name.length());
                        this.out.write(parameters[i].name);
                    } else {
                        this.out.write((byte)0);
                    }
                    this.out.write(parameters[i].isOutput ? (byte)1 : 0);
                    TdsData.writeParam(this.out, this.connection.getCharSet(), this.connection.isWideChar(), this.connection.getCollation(), parameters[i]);
                    ++i;
                }
            }
        } else if (sql.length() > 0) {
            if (parameters != null) {
                sql = Support.substituteParameters(sql, parameters, this.tdsVersion);
            }
            this.out.setPacketType((byte)1);
            this.out.write(sql);
        }
        this.out.flush();
    }

    private void setRowCount(int rowCount) throws SQLException {
        if (rowCount >= 0 && rowCount != this.connection.getRowCount()) {
            try {
                this.out.setPacketType((byte)1);
                this.out.write("SET ROWCOUNT " + rowCount);
                this.out.flush();
                this.endOfResponse = false;
                this.endOfResults = true;
                this.wait(0);
                this.clearResponseQueue();
                this.messages.checkErrors();
                this.connection.setRowCount(rowCount);
            }
            catch (IOException ioe) {
                throw new SQLException(Messages.get("error.generic.ioerror", ioe.getMessage()), "08S01");
            }
        }
    }

    private void wait(int timeOut) throws IOException, SQLException {
        try {
            try {
                this.in.setTimeout(timeOut * 1000);
                this.in.peek();
            }
            catch (InterruptedIOException e) {
                this.endOfResponse = true;
                throw new SQLException(Messages.get("error.generic.timeout"), "HYT00");
            }
            Object var4_2 = null;
            this.in.setTimeout(0);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.in.setTimeout(0);
            throw throwable;
        }
    }

    private static byte[] getMACAddress(String macString) {
        byte[] mac = new byte[6];
        boolean ok = false;
        if (macString != null && macString.length() == 12) {
            try {
                int i = 0;
                int j = 0;
                while (i < 6) {
                    mac[i] = (byte)Integer.parseInt(macString.substring(j, j + 2), 16);
                    ++i;
                    j += 2;
                }
                ok = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!ok) {
            Arrays.fill(mac, (byte)0);
        }
        return mac;
    }

    private static String getHostName() {
        String name;
        if (hostName != null) {
            return hostName;
        }
        try {
            name = InetAddress.getLocalHost().getHostName().toUpperCase();
        }
        catch (UnknownHostException e) {
            hostName = "UNKNOWN";
            return hostName;
        }
        int pos = name.indexOf(46);
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        if (name.length() == 0) {
            hostName = "UNKNOWN";
            return hostName;
        }
        try {
            Integer.parseInt(name);
            hostName = "UNKNOWN";
            return hostName;
        }
        catch (NumberFormatException numberFormatException) {
            hostName = name;
            return name;
        }
    }

    private static String tds7CryptPass(String pw) {
        int xormask = 23130;
        int len = pw.length();
        char[] chars = new char[len];
        int i = 0;
        while (i < len) {
            int c = pw.charAt(i) ^ 0x5A5A;
            int m1 = c >> 4 & 0xF0F;
            int m2 = c << 4 & 0xF0F0;
            chars[i] = (char)(m1 | m2);
            ++i;
        }
        return new String(chars);
    }

    static {
        tds8SpNames.put("sp_cursor", new Integer(1));
        tds8SpNames.put("sp_cursoropen", new Integer(2));
        tds8SpNames.put("sp_cursorprepare", new Integer(3));
        tds8SpNames.put("sp_cursorexecute", new Integer(4));
        tds8SpNames.put("sp_cursorprepexec", new Integer(5));
        tds8SpNames.put("sp_cursorunprepare", new Integer(6));
        tds8SpNames.put("sp_cursorfetch", new Integer(7));
        tds8SpNames.put("sp_cursoroption", new Integer(8));
        tds8SpNames.put("sp_cursorclose", new Integer(9));
        tds8SpNames.put("sp_executesql", new Integer(10));
        tds8SpNames.put("sp_prepare", new Integer(11));
        tds8SpNames.put("sp_execute", new Integer(12));
        tds8SpNames.put("sp_prepexec", new Integer(13));
        tds8SpNames.put("sp_prepexecrpc", new Integer(14));
        tds8SpNames.put("sp_unprepare", new Integer(15));
    }

    private static class TableMetaData {
        String catalog;
        String schema;
        String name;

        private TableMetaData() {
        }
    }

    private static class TdsToken {
        byte token;
        byte status;
        byte operation;
        int updateCount;
        byte[] nonce;
        String dynamicId;
        int previousToken;
        ColInfo[] dynamParamInfo;
        ColData[] dynamParamData;

        private TdsToken() {
        }

        boolean isUpdateCount() {
            return this.isEndToken() && (this.status & 0x10) != 0;
        }

        boolean isEndToken() {
            return this.token == -3 || this.token == -1 || this.token == -2;
        }

        boolean isAuthToken() {
            return this.token == -19;
        }

        boolean resultsPending() {
            return !this.isEndToken() || (this.status & 1) != 0;
        }

        boolean isResultSet() {
            return this.token == -95 || this.token == -127 || this.token == -18 || this.token == 97 || this.token == -91 || this.token == -47;
        }

        public boolean isRowData() {
            return this.token == -47;
        }
    }
}

