/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class StandardQueryCache
implements QueryCache {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, StandardQueryCache.class.getName());
    private static final boolean DEBUGGING = LOG.isDebugEnabled();
    private static final boolean TRACING = LOG.isTraceEnabled();
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    public StandardQueryCache(SessionFactoryOptions settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) {
        String prefix;
        String regionNameToUse = regionName;
        if (regionNameToUse == null) {
            regionNameToUse = StandardQueryCache.class.getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionNameToUse = prefix + '.' + regionNameToUse;
        }
        LOG.startingQueryCache(regionNameToUse);
        this.cacheRegion = settings.getServiceRegistry().getService(RegionFactory.class).buildQueryResultsRegion(regionNameToUse, props);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    @Override
    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    @Override
    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyQueryCache(this.cacheRegion.getName(), e.getMessage());
        }
    }

    @Override
    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(QueryKey key, Type[] returnTypes, List result, boolean isNaturalKeyLookup, SessionImplementor session) throws HibernateException {
        if (isNaturalKeyLookup && result.isEmpty()) {
            return false;
        }
        if (DEBUGGING) {
            LOG.debugf("Caching query results in region: %s; timestamp=%s", (Object)this.cacheRegion.getName(), (Object)session.getTimestamp());
        }
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        if (TRACING) {
            StandardQueryCache.logCachedResultDetails(key, null, returnTypes, cacheable);
        }
        cacheable.add(session.getTimestamp());
        boolean isSingleResult = returnTypes.length == 1;
        for (Object aResult : result) {
            Serializable[] cacheItem = isSingleResult ? returnTypes[0].disassemble(aResult, session, null) : TypeHelper.disassemble((Object[])aResult, returnTypes, null, session, null);
            cacheable.add(cacheItem);
            if (!TRACING) continue;
            StandardQueryCache.logCachedResultRowDetails(returnTypes, aResult);
        }
        try {
            session.getEventListenerManager().cachePutStart();
            this.cacheRegion.put(session, key, cacheable);
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
        return true;
    }

    @Override
    public List get(QueryKey key, Type[] returnTypes, boolean isNaturalKeyLookup, Set<Serializable> spaces, SessionImplementor session) throws HibernateException {
        if (DEBUGGING) {
            LOG.debugf("Checking cached query results in region: %s", (Object)this.cacheRegion.getName());
        }
        List cacheable = this.getCachedResults(key, session);
        if (TRACING) {
            StandardQueryCache.logCachedResultDetails(key, spaces, returnTypes, cacheable);
        }
        if (cacheable == null) {
            if (DEBUGGING) {
                LOG.debug("Query results were not found in cache");
            }
            return null;
        }
        Long timestamp = (Long)cacheable.get(0);
        if (!isNaturalKeyLookup && !this.isUpToDate(spaces, timestamp, session)) {
            if (DEBUGGING) {
                LOG.debug("Cached query results were not up-to-date");
            }
            return null;
        }
        if (DEBUGGING) {
            LOG.debug("Returning cached query results");
        }
        boolean singleResult = returnTypes.length == 1;
        for (int i = 1; i < cacheable.size(); ++i) {
            if (singleResult) {
                returnTypes[0].beforeAssemble((Serializable)cacheable.get(i), session);
                continue;
            }
            TypeHelper.beforeAssemble((Serializable[])cacheable.get(i), returnTypes, session);
        }
        return this.assembleCachedResult(key, cacheable, isNaturalKeyLookup, singleResult, returnTypes, session);
    }

    private List assembleCachedResult(QueryKey key, List cacheable, boolean isNaturalKeyLookup, boolean singleResult, Type[] returnTypes, SessionImplementor session) throws HibernateException {
        try {
            ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
            if (singleResult) {
                for (int i = 1; i < cacheable.size(); ++i) {
                    result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                }
            } else {
                for (int i = 1; i < cacheable.size(); ++i) {
                    result.add(TypeHelper.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
                    if (!TRACING) continue;
                    StandardQueryCache.logCachedResultRowDetails(returnTypes, result.get(i - 1));
                }
            }
            return result;
        }
        catch (RuntimeException ex) {
            if (isNaturalKeyLookup && (UnresolvableObjectException.class.isInstance(ex) || EntityNotFoundException.class.isInstance(ex))) {
                if (DEBUGGING) {
                    LOG.debug("Unable to reassemble cached natural-id query result");
                }
                this.cacheRegion.evict(key);
                return null;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCachedResults(QueryKey key, SessionImplementor session) {
        List cacheable = null;
        try {
            session.getEventListenerManager().cacheGetStart();
            cacheable = (List)this.cacheRegion.get(session, key);
            session.getEventListenerManager().cacheGetEnd(cacheable != null);
        }
        catch (Throwable throwable) {
            session.getEventListenerManager().cacheGetEnd(cacheable != null);
            throw throwable;
        }
        return cacheable;
    }

    protected boolean isUpToDate(Set<Serializable> spaces, Long timestamp, SessionImplementor session) {
        if (DEBUGGING) {
            LOG.debugf("Checking query spaces are up-to-date: %s", (Object)spaces);
        }
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp, session);
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }

    private static void logCachedResultDetails(QueryKey key, Set querySpaces, Type[] returnTypes, List result) {
        if (!TRACING) {
            return;
        }
        LOG.trace("key.hashCode=" + key.hashCode());
        LOG.trace("querySpaces=" + querySpaces);
        if (returnTypes == null || returnTypes.length == 0) {
            LOG.trace("Unexpected returnTypes is " + (returnTypes == null ? "null" : "empty") + "! result" + (result == null ? " is null" : ".size()=" + result.size()));
        } else {
            StringBuilder returnTypeInfo = new StringBuilder();
            for (Type returnType : returnTypes) {
                returnTypeInfo.append("typename=").append(returnType.getName()).append(" class=").append(returnType.getReturnedClass().getName()).append(' ');
            }
            LOG.trace("unexpected returnTypes is " + returnTypeInfo.toString() + "! result");
        }
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object result) {
        Object[] objectArray;
        if (result instanceof Object[]) {
            objectArray = (Object[])result;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = result;
        }
        StandardQueryCache.logCachedResultRowDetails(returnTypes, objectArray);
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object[] tuple) {
        if (!TRACING) {
            return;
        }
        if (tuple == null) {
            LOG.tracef("tuple is null; returnTypes is %s", (Object)(returnTypes == null ? "null" : "Type[" + returnTypes.length + "]"));
            if (returnTypes != null && returnTypes.length > 1) {
                LOG.trace("Unexpected result tuple! tuple is null; should be Object[" + returnTypes.length + "]!");
            }
        } else {
            if (returnTypes == null || returnTypes.length == 0) {
                LOG.trace("Unexpected result tuple! tuple is null; returnTypes is " + (returnTypes == null ? "null" : "empty"));
            }
            LOG.tracef("tuple is Object[%s]; returnTypes is %s", tuple.length, (Object)(returnTypes == null ? "null" : "Type[" + returnTypes.length + "]"));
            if (returnTypes != null && tuple.length != returnTypes.length) {
                LOG.trace("Unexpected tuple length! transformer= expected=" + returnTypes.length + " got=" + tuple.length);
            } else {
                for (int j = 0; j < tuple.length; ++j) {
                    if (tuple[j] == null || returnTypes == null || returnTypes[j].getReturnedClass().isInstance(tuple[j])) continue;
                    LOG.trace("Unexpected tuple value type! transformer= expected=" + returnTypes[j].getReturnedClass().getName() + " got=" + tuple[j].getClass().getName());
                }
            }
        }
    }
}

