/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.hibernate.internal.CoreLogging;
import org.hibernate.tool.schema.internal.exec.AbstractScriptTargetOutput;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.jboss.logging.Logger;

public class ScriptTargetOutputToFile
extends AbstractScriptTargetOutput
implements ScriptTargetOutput {
    private static final Logger log = CoreLogging.logger(ScriptTargetOutputToFile.class);
    private final File file;
    private Writer writer;

    public ScriptTargetOutputToFile(File file) {
        this.file = file;
    }

    @Override
    protected Writer writer() {
        if (this.writer == null) {
            throw new SchemaManagementException("Illegal state : writer null - not prepared");
        }
        return this.writer;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.writer = ScriptTargetOutputToFile.toFileWriter(this.file);
    }

    @Override
    public void release() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new SchemaManagementException("Unable to close file writer : " + e.toString());
            }
            finally {
                this.writer = null;
            }
        }
    }

    static Writer toFileWriter(File file) {
        try {
            if (!file.exists()) {
                log.debug("Attempting to create non-existent script target file : " + file.getAbsolutePath());
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
        }
        catch (Exception e) {
            log.debug("Exception calling File#createNewFile : " + e.toString());
        }
        try {
            return new FileWriter(file, true);
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to open specified script target file for writing : " + file, e);
        }
    }
}

