/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.util.hibernate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleHqlBuilder {
    private final String selectClause;
    private final List<String> whereOperators = new ArrayList<String>();
    private final List<String> whereClauses = new ArrayList<String>();
    private final List<Object> paramValues = new ArrayList<Object>();
    private String orderByClause;

    public SimpleHqlBuilder(String selectClause) {
        this.selectClause = selectClause;
    }

    public void orderBy(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public SimpleHqlBuilder and(String whereClause, Object ... paramValues) {
        return this.addWhereClause(" and ", whereClause, paramValues);
    }

    public SimpleHqlBuilder or(String whereClause, Object ... paramValues) {
        return this.addWhereClause(" or ", whereClause, paramValues);
    }

    private SimpleHqlBuilder addWhereClause(String whereOperator, String whereClause, Object ... paramValues) {
        this.whereClauses.add(whereClause);
        this.whereOperators.add(whereOperator);
        this.paramValues.addAll(Arrays.asList(paramValues));
        return this;
    }

    public String getHql() {
        StringBuilder where = new StringBuilder();
        if (!this.whereClauses.isEmpty()) {
            boolean first = true;
            int size = this.whereClauses.size();
            for (int i = 0; i < size; ++i) {
                if (first) {
                    where.append(" where ");
                    first = false;
                } else {
                    where.append(this.whereOperators.get(i));
                }
                where.append(this.whereClauses.get(i));
            }
        }
        return SimpleHqlBuilder.toJpqlStyle(this.selectClause + where + (this.orderByClause != null ? " order by " + this.orderByClause : ""));
    }

    private static String toJpqlStyle(String query) {
        StringBuilder sb = new StringBuilder(query);
        int j = -1;
        int count = 1;
        while ((j = sb.indexOf("?", j + 1)) != -1) {
            sb.insert(j + 1, count++);
        }
        return sb.toString();
    }

    public Object[] getParams() {
        return this.paramValues.toArray();
    }
}

