/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import net.sf.ehcache.util.ProductInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChecker
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChecker.class.getName());
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int CONNECT_TIMEOUT = 3000;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String UPDATE_CHECK_URL = "http://www.terracotta.org/kit/reflector?pageID=update.properties";
    private static final long START_TIME = System.currentTimeMillis();
    private final Map<String, String> params = new HashMap<String, String>();

    public UpdateChecker() {
        this.prepareParams();
    }

    private void prepareParams() {
        ProductInfo productInfo = new ProductInfo();
        String productName = productInfo.getName().toLowerCase();
        String kitId = "ehcache.default";
        if (productName.contains("ehcache")) {
            kitId = "ehcache.default";
        } else if (productName.contains("bigmemory")) {
            kitId = "bigmemory.default";
        } else {
            throw new AssertionError((Object)("Unknown product name: " + productName));
        }
        this.putUrlSafe("kitID", kitId);
        this.putUrlSafe("id", Integer.toString(this.getClientId()));
        this.putUrlSafe("os-name", this.getProperty("os.name"));
        this.putUrlSafe("jvm-name", this.getProperty("java.vm.name"));
        this.putUrlSafe("jvm-version", this.getProperty("java.version"));
        this.putUrlSafe("platform", this.getProperty("os.arch"));
        this.putUrlSafe("tc-version", productInfo.getVersion());
        this.putUrlSafe("tc-product", productInfo.getName() + " " + productInfo.getVersion());
        this.putUrlSafe("source", productInfo.getName());
        this.putUrlSafe("uptime-secs", Long.toString(this.getUptimeInSeconds()));
        this.putUrlSafe("patch", productInfo.getPatchLevel());
    }

    protected void putUrlSafe(String key, String value) {
        this.params.put(key, this.urlEncode(value));
    }

    @Override
    public void run() {
        this.checkForUpdate();
    }

    public void checkForUpdate() {
        try {
            if (!Boolean.getBoolean("net.sf.ehcache.skipUpdateCheck")) {
                this.doCheck();
            }
        }
        catch (Throwable t) {
            LOG.debug("Update check failed: ", t);
        }
    }

    private void doCheck() throws IOException {
        this.updateParams();
        URL updateUrl = this.buildUpdateCheckUrl();
        if (Boolean.getBoolean("net.sf.ehcache.debug.updatecheck")) {
            LOG.info("Update check url: {}", updateUrl);
        }
        Properties updateProps = this.getUpdateProperties(updateUrl);
        String currentVersion = new ProductInfo().getVersion();
        String propVal = updateProps.getProperty("general.notice");
        if (this.notBlank(propVal)) {
            LOG.info(propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".notices"))) {
            LOG.info(propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".updates"))) {
            StringBuilder sb = new StringBuilder();
            String[] newVersions = propVal.split(",");
            for (int i = 0; i < newVersions.length; ++i) {
                String newVersion = newVersions[i].trim();
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(newVersion);
                propVal = updateProps.getProperty(newVersion + ".release-notes");
                if (!this.notBlank(propVal)) continue;
                sb.append(" [");
                sb.append(propVal);
                sb.append("]");
            }
            if (sb.length() > 0) {
                LOG.info("New update(s) found: " + sb.toString() + ". Please check http://ehcache.org for the latest version.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getUpdateProperties(URL updateUrl) throws IOException {
        URLConnection connection = updateUrl.openConnection();
        connection.setConnectTimeout(3000);
        InputStream in = connection.getInputStream();
        try {
            Properties props = new Properties();
            props.load(connection.getInputStream());
            Properties properties = props;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private URL buildUpdateCheckUrl() throws MalformedURLException, UnsupportedEncodingException {
        String url = System.getProperty("ehcache.update-check.url", UPDATE_CHECK_URL);
        String connector = url.indexOf(63) > 0 ? "&" : "?";
        return new URL(url + connector + this.buildParamsString());
    }

    protected void updateParams() {
        this.putUrlSafe("uptime-secs", Long.toString(this.getUptimeInSeconds()));
    }

    private String buildParamsString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private long getUptimeInSeconds() {
        long uptime = System.currentTimeMillis() - START_TIME;
        return uptime > 0L ? uptime / 1000L : 0L;
    }

    private int getClientId() {
        try {
            return InetAddress.getLocalHost().hashCode();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private String urlEncode(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getProperty(String prop) {
        return System.getProperty(prop, UNKNOWN);
    }

    private boolean notBlank(String s) {
        return s != null && s.trim().length() > 0;
    }
}

