/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyEnhancedImpl;
import org.hibernate.property.access.spi.EnhancedSetterImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;

public class PropertyAccessEnhancedImpl
implements PropertyAccess {
    private final PropertyAccessStrategyEnhancedImpl strategy;
    private final Getter getter;
    private final Setter setter;

    public PropertyAccessEnhancedImpl(PropertyAccessStrategyEnhancedImpl strategy, Class containerJavaType, String propertyName) {
        this.strategy = strategy;
        Field field = PropertyAccessEnhancedImpl.fieldOrNull(containerJavaType, propertyName);
        if (field == null) {
            throw new PropertyAccessBuildingException(String.format("Could not locate field for property [%s] on bytecode-enhanced Class [%s]", propertyName, containerJavaType.getName()));
        }
        this.getter = new GetterFieldImpl(containerJavaType, propertyName, field);
        this.setter = PropertyAccessEnhancedImpl.resolveEnhancedSetterForField(containerJavaType, propertyName, field);
    }

    private static Field fieldOrNull(Class containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Method getterMethodOrNull(Class containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findGetterMethod(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Method setterMethodOrNull(Class containerJavaType, String propertyName, Class propertyJavaType) {
        try {
            return ReflectHelper.findSetterMethod(containerJavaType, propertyName, propertyJavaType);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Setter resolveEnhancedSetterForField(Class<?> containerClass, String propertyName, Field field) {
        try {
            String enhancedSetterName = "$$_hibernate_write_" + propertyName;
            Method enhancedSetter = containerClass.getDeclaredMethod(enhancedSetterName, field.getType());
            enhancedSetter.setAccessible(true);
            return new EnhancedSetterImpl(containerClass, propertyName, enhancedSetter);
        }
        catch (NoSuchMethodException e) {
            return new SetterFieldImpl(containerClass, propertyName, field);
        }
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this.getter;
    }

    @Override
    public Setter getSetter() {
        return this.setter;
    }
}

