/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.borda.dao.JPAUtil;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.util.hibernate.SimpleHqlBuilder;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.log4j.Logger;

public abstract class AbstractDAO {
    private static final Logger logger = Logger.getLogger(AbstractDAO.class.getName());
    private static boolean loaded_auto_ids = false;

    protected final EntityManager getEntityManager() {
        EntityManager em = null;
        try {
            em = JPAUtil.getEntityManager();
        }
        catch (ConfigFailedException e) {
            logger.error("N\u00e3o foi poss\u00edvel a cria\u00e7\u00e3o de um EntityManager!!!", e);
        }
        if (loaded_auto_ids || AbstractDAO.checkTablesReady(em)) {
            return em;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkTablesReady(EntityManager em) {
        Class<AbstractDAO> clazz = AbstractDAO.class;
        synchronized (AbstractDAO.class) {
            if (loaded_auto_ids) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            try {
                RegistroItemErro.setNextId(1);
                Query queryE = em.createQuery("SELECT max(rie.idRegistroItemErro) FROM RegistroItemErro rie");
                queryE.setMaxResults(1);
                Number maxId = (Number)queryE.getSingleResult();
                if (null != maxId) {
                    RegistroItemErro.setNextId(maxId.intValue() + 1);
                }
            }
            catch (NoResultException e) {
                logger.debug("Utilizando o valor 1 para o maximo valor da chave para a tabela regitro_item_erro.");
            }
            loaded_auto_ids = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loaded_auto_ids;
        }
    }

    public final synchronized void beginTransaction() {
        try {
            JPAUtil.beginTransaction();
        }
        catch (ConfigFailedException e) {
            logger.error("Falha ao iniciar transa\u00e7\u00e3o!!!", e);
        }
    }

    public final void commit() {
        try {
            JPAUtil.commit();
        }
        catch (ConfigFailedException e) {
            logger.error("Falha ao comprometer transa\u00e7\u00e3o!!!", e);
        }
    }

    public final void rollback() {
        try {
            JPAUtil.rollback();
        }
        catch (ConfigFailedException e) {
            logger.error("Falha ao desfazer transa\u00e7\u00e3o!!!", e);
        }
    }

    public final void clear() {
        JPAUtil.clear();
    }

    protected void updateObject(Object p_obj) {
        this.getEntityManager().merge(p_obj);
        this.getEntityManager().flush();
    }

    protected void saveObject(Object p_obj) {
        this.getEntityManager().persist(p_obj);
        this.getEntityManager().flush();
    }

    protected Query createQuery(SimpleHqlBuilder builder) {
        if (logger.isDebugEnabled()) {
            logger.debug("------------------------------------");
            logger.debug("Query: " + builder.getHql());
            int i = 1;
            for (Object p : builder.getParams()) {
                logger.debug("Parametro " + i++ + ": " + p);
            }
            logger.debug("------------------------------------");
        }
        Query q = this.getEntityManager().createQuery(builder.getHql());
        int i = 1;
        for (Object p : builder.getParams()) {
            q.setParameter(i++, p);
        }
        return q;
    }

    public static Date fimDoDia(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }
}

