/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.install;

import br.gov.lexml.borda.install.ConfigDb;
import br.gov.lexml.borda.install.ContextoInstalacao;
import br.gov.lexml.borda.install.PassoInstalacaoInterativo;
import java.util.List;

public class PassoDbSgbd
extends PassoInstalacaoInterativo<ContextoInstalacao> {
    private static ConfigDb configDb = ConfigDb.getInstance();

    @Override
    public void imprimePergunta() {
        System.out.println("Selecione o tipo do seu banco de dados:\n");
        List<ConfigDb.DbInfo> dbs = configDb.getDbInfos();
        int i = 1;
        for (ConfigDb.DbInfo db : dbs) {
            System.out.println("\t" + i++ + " - " + db.getSgbd());
        }
        System.out.print("\n[" + (((ContextoInstalacao)this.contexto).getDbSgbd() + 1) + "]: ");
    }

    @Override
    public boolean validaResposta(String resposta) {
        boolean sucesso = true;
        if (resposta.trim().equals("")) {
            ((ContextoInstalacao)this.contexto).setDbPorta(configDb.getDbInfo(((ContextoInstalacao)this.contexto).getDbSgbd()).getDefaultPort());
            return true;
        }
        int sgbd = 0;
        try {
            sgbd = Integer.parseInt(resposta);
        }
        catch (Exception e) {
            sucesso = false;
        }
        int maxOpcao = configDb.getDbInfos().size();
        if (!(sucesso &= sgbd >= 1 && sgbd <= maxOpcao)) {
            System.out.println("Selecione uma opcao valida entre 1 e " + maxOpcao + ".\n");
        } else {
            ((ContextoInstalacao)this.contexto).setDbSgbd(--sgbd);
            ((ContextoInstalacao)this.contexto).setDbPorta(configDb.getDbInfo(sgbd).getDefaultPort());
        }
        return sucesso;
    }
}

