/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.borda.dao.EMFFactory;
import br.gov.lexml.exceptions.ConfigFailedException;
import javax.persistence.EntityManager;

public class JPAUtil {
    private static final ThreadLocal<EntityManager> EM_HOLDER = new ThreadLocal();

    public static EntityManager getEntityManager() throws ConfigFailedException {
        EntityManager em = EM_HOLDER.get();
        if (em == null) {
            em = EMFFactory.getEMF().createEntityManager();
            em.clear();
            EM_HOLDER.set(em);
        }
        return em;
    }

    public static void closeEntityManager() {
        EntityManager em = EM_HOLDER.get();
        if (em != null) {
            EM_HOLDER.set(null);
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    public static void beginTransaction() throws ConfigFailedException {
        if (!JPAUtil.getEntityManager().getTransaction().isActive()) {
            JPAUtil.getEntityManager().getTransaction().begin();
        }
    }

    public static void commit() throws ConfigFailedException {
        if (JPAUtil.getEntityManager().getTransaction().isActive()) {
            JPAUtil.getEntityManager().flush();
            JPAUtil.getEntityManager().getTransaction().commit();
        }
    }

    public static void rollback() throws ConfigFailedException {
        if (JPAUtil.getEntityManager().getTransaction().isActive()) {
            JPAUtil.getEntityManager().getTransaction().rollback();
        }
    }

    public static void clear() {
        EntityManager em = EM_HOLDER.get();
        if (em != null) {
            em.clear();
        }
    }
}

