/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.TargetTypeHelper;

public class ToolKitDAO {
    private static final Logger logger = Logger.getLogger(ToolKitDAO.class.getName());

    public void instalaBancoDeDados(Properties props) throws NamingException, ConfigFailedException {
        if (props == null) {
            props = LexMLUtil.getJPAProperties();
        }
        if (null == props) {
            logger.error("Foi recebido um null no lugar das propriedades para o JPA.");
            throw new ConfigFailedException("Propriedades recebidas s\u00e3o podem ser nulas");
        }
        try {
            BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
            StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
            ssrBuilder.applySettings(props);
            StandardServiceRegistry serviceRegistry = ssrBuilder.build();
            MetadataImplementor metadata = ToolKitDAO.buildMetadata(serviceRegistry);
            new SchemaExport().setHaltOnError(false).setOutputFile("lexml_create_ddl.sql").setDelimiter(";").setFormat(true).execute(TargetTypeHelper.parseLegacyCommandLineOptions(true, true, "lexml_create_ddl.sql"), SchemaExport.Action.BOTH, metadata, serviceRegistry);
        }
        catch (Exception e) {
            logger.error("Falha durante a execu\u00e7\u00e3o da cria\u00e7\u00e3o do banco de dados", e);
        }
    }

    private static MetadataImplementor buildMetadata(StandardServiceRegistry serviceRegistry) {
        MetadataSources metadataSources = new MetadataSources(serviceRegistry);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        metadataSources.addAnnotatedClass(RegistroItem.class);
        metadataSources.addAnnotatedClass(RegistroItemErro.class);
        metadataSources.addAnnotatedClass(TipoErro.class);
        metadataSources.addAnnotatedClass(ConjuntoItem.class);
        return (MetadataImplementor)metadataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validaBancoDeDados(Properties props) {
        boolean ret = true;
        Connection conn = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            conn = this.openConnection(props);
            st = conn.prepareStatement("select count(*) from conjunto_item");
            rs = st.executeQuery();
        }
        catch (Exception e) {
            ret = false;
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public void testaConexaoBancoDeDados(Properties p) throws Exception {
        Connection conn = this.openConnection(p);
        conn.commit();
        conn.close();
    }

    public Connection openConnection(String driver, String jdbcUrl, String usuario, String senha) throws Exception {
        Class.forName(driver);
        Connection conn = DriverManager.getConnection(jdbcUrl, usuario, senha);
        conn.setAutoCommit(false);
        return conn;
    }

    public Connection openConnection(Properties p) throws Exception {
        return this.openConnection(p.getProperty("hibernate.connection.driver_class"), p.getProperty("hibernate.connection.url"), p.getProperty("hibernate.connection.username"), p.getProperty("hibernate.connection.password"));
    }
}

