/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.helper;

import br.gov.lexml.borda.dao.TipoErroDAO;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.TipoErro;
import org.apache.log4j.Logger;

public class BOHelper {
    private static Logger logger = Logger.getLogger(BOHelper.class.getName());
    public static final String CONJUNTO_ITEM_ID_DEFAULT = "lexml";
    public static final String CONJUNTO_ITEM_DE_DEFAULT = "Registros oai_lexml";
    private static BOHelper instance = null;
    public Erro ERRO_GENERICO = null;
    public Erro ERRO_XML_MAL_FORMADO = null;
    public Erro ERRO_XML_INVALIDO = null;
    public Erro ERRO_URN_MAL_FORMADO = null;
    public Erro ERRO_URN_INVALIDO = null;
    public Erro ERRO_URN_INCOMPATIVEL = null;
    private ConjuntoItem CONJUNTO_DEFAULT = null;
    private boolean inicializada = false;

    public static BOHelper getInstance() {
        if (null == instance) {
            instance = new BOHelper();
        }
        return instance;
    }

    private BOHelper() {
        this.inicializar();
    }

    private void inicializar() {
        if (this.inicializada) {
            return;
        }
        logger.debug("Inicializando as tabelas com os erros padr\u00e3o e o conjunto padr\u00e3o para importa\u00e7\u00e3o de registros");
        TipoErroDAO m_dao = new TipoErroDAO();
        m_dao.beginTransaction();
        if (null == this.ERRO_GENERICO) {
            this.ERRO_GENERICO = new Erro(1, "Um erro nao previsto ocorreu durante a validacao", "Erro Generico", m_dao);
        }
        if (null == this.ERRO_XML_MAL_FORMADO) {
            this.ERRO_XML_MAL_FORMADO = new Erro(2, "Falha na validacao por motivo de XML mal formado", "XML mal formado", m_dao);
        }
        if (null == this.ERRO_XML_INVALIDO) {
            this.ERRO_XML_INVALIDO = new Erro(3, "Falha de XML invalido", "XML invalido", m_dao);
        }
        if (null == this.ERRO_URN_MAL_FORMADO) {
            this.ERRO_URN_MAL_FORMADO = new Erro(4, "Falha no DocumentoIndividual: URN mal formado", "URN mal formado", m_dao);
        }
        if (null == this.ERRO_URN_INVALIDO) {
            this.ERRO_URN_INVALIDO = new Erro(5, "Falha no DocumentoIndividual: URN invalida", "URN invalido", m_dao);
        }
        if (null == this.ERRO_URN_INCOMPATIVEL) {
            this.ERRO_URN_INCOMPATIVEL = new Erro(6, "Falha no DocumentoIndividual: URN incompati\ufffdvel com o perfil do provedor local", "URN incompativel com o perfil do provedor", m_dao);
        }
        m_dao.commit();
        this.inicializada = true;
    }

    public class Erro {
        public TipoErro tipo;
        public String msg;

        public Erro(int cod, String msgUsuario, String msgErro, TipoErroDAO p_dao) {
            this.msg = msgUsuario;
            TipoErro tipo2 = p_dao.load(cod);
            if (null == tipo2) {
                tipo2 = new TipoErro();
                tipo2.setIdTipoErro(cod);
                tipo2.setNoTipoErro(msgErro);
                p_dao.save(tipo2);
            }
            this.tipo = tipo2;
        }
    }
}

