/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.install;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.dao.ToolKitDAO;
import br.gov.lexml.borda.helper.ToolKitHelper;
import br.gov.lexml.borda.install.ConfigDb;
import br.gov.lexml.borda.install.ContextoInstalacao;
import br.gov.lexml.borda.install.PassoDbSgbd;
import br.gov.lexml.borda.install.PassoDbVerificarPreconfiguracao;
import br.gov.lexml.borda.install.PassoInstalacaoInterativo;
import br.gov.lexml.exceptions.InstalacaoException;
import de.schlichtherle.io.FileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;

public class PassoDbInstalarSchema
extends PassoInstalacaoInterativo<ContextoInstalacao> {
    private static ConfigDb configDb = ConfigDb.getInstance();

    @Override
    public void imprimePergunta() throws Exception {
        if (((ContextoInstalacao)this.contexto).isDbPreconfigurado()) {
            System.out.println("Lembre-se de copiar o .jar do driver do seu banco de dados\npara a pasta /lib.\n\nO dados abaixo para conexao com o banco de dados estao corretos? (s/n)\n");
            Properties p = this.loadJpaProperties();
            for (Object key : p.keySet()) {
                System.out.println(key + " = " + p.get(key));
            }
        } else {
            this.geraPropertyFile();
            System.out.println("O dados abaixo para conexao com o banco de dados estao corretos? (s/n)\n");
            System.out.println("Tipo:       " + configDb.getDbInfo(((ContextoInstalacao)this.contexto).getDbSgbd()).getSgbd());
            System.out.println("Servidor:   " + ((ContextoInstalacao)this.contexto).getDbServidor());
            System.out.println("Porta:      " + ((ContextoInstalacao)this.contexto).getDbPorta());
            System.out.println("Nome do BD: " + ((ContextoInstalacao)this.contexto).getDbNome());
            System.out.println("Usuario:    " + ((ContextoInstalacao)this.contexto).getDbUsuario());
            System.out.println("Senha:      " + ((ContextoInstalacao)this.contexto).getDbSenha());
        }
        System.out.print("\n[s]: ");
    }

    @Override
    public String executaPasso(String resposta) throws Exception {
        if (resposta.equals("") || resposta.equalsIgnoreCase("s")) {
            Properties p = this.loadJpaProperties();
            ToolKitDAO dao = new ToolKitDAO();
            try {
                dao.testaConexaoBancoDeDados(p);
            }
            catch (Exception e) {
                throw new InstalacaoException("Nao foi possivel conectar com o banco de dados.", e);
            }
            try {
                boolean existeSchema = dao.validaBancoDeDados(p);
                if (!existeSchema || this.confirmaSobreposicao()) {
                    System.out.println("\nInstalando schema do banco de dados.\n\nIgnore erros relativos a nao existencia de objetos no banco de dados.\n");
                    dao.instalaBancoDeDados(p);
                    ((ContextoInstalacao)this.contexto).setBdOk(true);
                }
                if (existeSchema) {
                    ((ContextoInstalacao)this.contexto).setBdOk(true);
                }
            }
            catch (Exception e) {
                throw new InstalacaoException("Falha ao instalar o schema do banco de dados.", e);
            }
            return null;
        }
        if (((ContextoInstalacao)this.contexto).isDbPreconfigurado()) {
            return PassoDbVerificarPreconfiguracao.class.getName();
        }
        return PassoDbSgbd.class.getName();
    }

    private Properties loadJpaProperties() throws FileNotFoundException, IOException {
        Properties p = new Properties();
        File jpaProperties = LexMLUtil.getPathJpaProperties();
        p.load(new FileInputStream(jpaProperties));
        return p;
    }

    private boolean confirmaSobreposicao() throws Exception {
        System.out.print("\nAs tabelas do lexml ja existem no banco de dados.\nVoce deseja apaga-las? (s/n)\n\n[n]: ");
        String resposta = ToolKitHelper.readUserInput();
        return resposta.equalsIgnoreCase("s");
    }

    private File geraPropertyFile() throws Exception {
        File file = LexMLUtil.getPathJpaProperties();
        System.out.println("Gerando arquivo " + file.getCanonicalPath() + " ...\n");
        PrintWriter writer = new PrintWriter(file);
        PassoDbInstalarSchema.writeProperties(writer, (ContextoInstalacao)this.contexto);
        writer.close();
        return file;
    }

    private static void writeProperties(Writer writer, ContextoInstalacao contexto) throws Exception {
        ConfigDb.DbInfo info = ConfigDb.getInstance().getDbInfo(contexto.getDbSgbd());
        String jdbcUrl = info.getUrl(contexto.getDbServidor(), contexto.getDbPorta(), contexto.getDbNome());
        writer.write("hibernate.dialect=" + info.getDialect() + "\n");
        writer.write("hibernate.connection.driver_class=" + info.getDriver() + "\n");
        writer.write("hibernate.connection.url=" + jdbcUrl + "\n");
        writer.write("hibernate.connection.username=" + contexto.getDbUsuario() + "\n");
        writer.write("hibernate.connection.password=" + contexto.getDbSenha() + "\n");
    }
}

