/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.cachedstore;

import com.mchange.lang.PotentiallySecondary;
import com.mchange.v1.cachedstore.CacheFlushException;
import com.mchange.v1.cachedstore.CachedStore;
import com.mchange.v1.cachedstore.CachedStoreException;
import com.mchange.v1.cachedstore.TweakableCachedStore;
import com.mchange.v1.cachedstore.WritableCachedStore;
import com.mchange.v1.lang.Synchronizer;

public final class CachedStoreUtils {
    static final boolean DEBUG = true;

    public static CachedStore synchronizedCachedStore(CachedStore orig) {
        return (CachedStore)Synchronizer.createSynchronizedWrapper(orig);
    }

    public static TweakableCachedStore synchronizedTweakableCachedStore(TweakableCachedStore orig) {
        return (TweakableCachedStore)Synchronizer.createSynchronizedWrapper(orig);
    }

    public static WritableCachedStore synchronizedWritableCachedStore(WritableCachedStore orig) {
        return (WritableCachedStore)Synchronizer.createSynchronizedWrapper(orig);
    }

    public static CachedStore untweakableCachedStore(final TweakableCachedStore orig) {
        return new CachedStore(){

            public Object find(Object key) throws CachedStoreException {
                return orig.find(key);
            }

            public void reset() throws CachedStoreException {
                orig.reset();
            }
        };
    }

    static CachedStoreException toCachedStoreException(Throwable t) {
        Throwable t2;
        t.printStackTrace();
        if (t instanceof CachedStoreException) {
            return (CachedStoreException)t;
        }
        if (t instanceof PotentiallySecondary && (t2 = ((PotentiallySecondary)((Object)t)).getNestedThrowable()) instanceof CachedStoreException) {
            return (CachedStoreException)t2;
        }
        return new CachedStoreException(t);
    }

    static CacheFlushException toCacheFlushException(Throwable t) {
        t.printStackTrace();
        if (t instanceof CacheFlushException) {
            return (CacheFlushException)t;
        }
        return new CacheFlushException(t);
    }

    private CachedStoreUtils() {
    }
}

