/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheEntityRegion;
import org.hibernate.cache.ehcache.internal.strategy.AbstractReadWriteEhcacheAccessStrategy;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ReadWriteEhcacheEntityRegionAccessStrategy
extends AbstractReadWriteEhcacheAccessStrategy<EhcacheEntityRegion>
implements EntityRegionAccessStrategy {
    public ReadWriteEhcacheEntityRegionAccessStrategy(EhcacheEntityRegion region, SessionFactoryOptions settings) {
        super(region, settings);
    }

    @Override
    public EntityRegion getRegion() {
        return (EntityRegion)this.region();
    }

    @Override
    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        ((EhcacheEntityRegion)this.region()).writeLock(key);
        try {
            AbstractReadWriteEhcacheAccessStrategy.Lockable item = (AbstractReadWriteEhcacheAccessStrategy.Lockable)((EhcacheEntityRegion)this.region()).get(key);
            if (item == null) {
                ((EhcacheEntityRegion)this.region()).put(key, new AbstractReadWriteEhcacheAccessStrategy.Item(value, version, ((EhcacheEntityRegion)this.region()).nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ((EhcacheEntityRegion)this.region()).writeUnlock(key);
        }
    }

    @Override
    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        ((EhcacheEntityRegion)this.region()).writeLock(key);
        try {
            AbstractReadWriteEhcacheAccessStrategy.Lockable item = (AbstractReadWriteEhcacheAccessStrategy.Lockable)((EhcacheEntityRegion)this.region()).get(key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteEhcacheAccessStrategy.Lock lockItem = (AbstractReadWriteEhcacheAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                ((EhcacheEntityRegion)this.region()).put(key, new AbstractReadWriteEhcacheAccessStrategy.Item(value, currentVersion, ((EhcacheEntityRegion)this.region()).nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            ((EhcacheEntityRegion)this.region()).writeUnlock(key);
        }
    }

    @Override
    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createEntityKey(id, persister, factory, tenantIdentifier);
    }

    @Override
    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getEntityId(cacheKey);
    }
}

