/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.LexMLConfig;
import br.gov.lexml.borda.business.AbstractBO;
import br.gov.lexml.borda.business.URNBO;
import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.borda.helper.BOHelper;
import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.oaiLexml.LexMLDocument;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class ValidadorBO
extends AbstractBO {
    private static Logger logger = Logger.getLogger(ValidadorBO.class.getName());
    private static int BUCKET_SIZE = 1000;
    private List<RegistroItemErro> errosList = new ArrayList<RegistroItemErro>();
    private List<RegistroItem> atualizados = new ArrayList<RegistroItem>();
    private RegistroItemDAO m_dao;
    private LexMLConfig m_config;
    private final URNBO m_URN;
    private BOHelper m_helper;
    private XmlOptions validationOptions = new XmlOptions();
    private ArrayList<Object> validationErrors;

    public ValidadorBO() throws ConfigFailedException {
        this.m_helper = BOHelper.getInstance();
        this.m_URN = new URNBO(this.m_helper);
        this.m_config = LexMLConfig.getInstance();
        this.m_dao = new RegistroItemDAO();
        this.validationOptions.setCharacterEncoding("UTF-8");
        this.validationOptions.setLoadStripProcinsts();
    }

    public boolean validarRegistroItem(RegistroItem ri) {
        block10: {
            LexMLDocument doc;
            block9: {
                doc = null;
                if (ri == null) {
                    logger.error("RV#4 Objeto RegistroItem ri passado \u00e9 nulo");
                    return false;
                }
                this.m_dao.deleteRegistroItemErro(ri);
                ri.setCdValidacao("E");
                if (!ri.getIdRegistroItem().trim().equals(ri.getIdRegistroItem())) {
                    this.logError(ri, this.m_helper.ERRO_GENERICO.tipo, "RV#1 ID_REGISTRO_ITEM n\u00e3o pode conter espa\u00e7os em branco");
                    return false;
                }
                String xml = ri.getTxMetadadoXml();
                if (StringUtils.isEmpty(xml)) {
                    this.logError(ri, this.m_helper.ERRO_XML_MAL_FORMADO.tipo, "RV#2 XML nulo foi passado para valida\u00e7\u00e3o");
                    return false;
                }
                this.validationErrors = new ArrayList();
                this.validationOptions.setErrorListener(this.validationErrors);
                doc = LexMLDocument.Factory.parse(xml, this.validationOptions);
                if (doc.validate(this.validationOptions)) break block9;
                Iterator<Object> iterErros = this.validationErrors.iterator();
                StringBuilder sb = new StringBuilder("RV#3 Xml n\u00e3o \u00e9 v\u00e1lido segundo o schema: ");
                while (iterErros.hasNext()) {
                    sb.append(iterErros.next() + " \n");
                }
                this.logError(ri, this.m_helper.ERRO_XML_INVALIDO.tipo, sb.toString());
                return false;
            }
            RegistroItemErro erro = this.m_URN.validaDocumento(ri, doc);
            if (erro == null) break block10;
            this.logError(ri, erro);
            return false;
        }
        try {
            ri.setCdValidacao("O");
            return true;
        }
        catch (XmlException e) {
            this.logError(ri, this.m_helper.ERRO_XML_MAL_FORMADO.tipo, String.valueOf(e.getMessage()) + ": " + e.getErrors());
        }
        catch (Throwable e) {
            this.logError(ri, this.m_helper.ERRO_XML_MAL_FORMADO.tipo, e.getMessage());
        }
        return false;
    }

    public void validarRegistrosIndefinidos() {
        double per;
        String ultimoId;
        if (this.m_config == null) {
            logger.fatal("Ambiente nao configurado, verifique arquivo de configuracao:lexml_nbconfig.xml");
            return;
        }
        List<RegistroItem> list = this.m_dao.listNotValid(null, BUCKET_SIZE);
        if (list.isEmpty()) {
            logger.warn("N\u00e3o havia registros indefinidos para serem validados");
            return;
        }
        long total = this.m_dao.countNotValid();
        logger.info("Come\u00e7ando a validar " + total + " registros.");
        long sucessos = 0L;
        long erros = 0L;
        DecimalFormat df = new DecimalFormat("#00.0");
        do {
            this.m_dao.beginTransaction();
            for (RegistroItem ri : list) {
                if (this.validarRegistroItem(ri)) {
                    ++sucessos;
                } else {
                    ++erros;
                }
                this.atualizados.add(ri);
            }
            this.saveLists();
            long subtotal = sucessos + erros;
            per = (float)subtotal * 100.0f / (float)total;
            logger.info("... " + subtotal + " (" + df.format(per) + "%)");
        } while (!(list = this.m_dao.listNotValid(ultimoId = list.get(list.size() - 1).getIdRegistroItem(), BUCKET_SIZE)).isEmpty());
        logger.info("-----------------------------------");
        logger.info("Total de registros processados: " + total);
        logger.info("Processados com sucesso: " + sucessos);
        logger.info("Registros com erros: " + erros);
        per = (float)sucessos * 100.0f / (float)total;
        String strPer = df.format(per);
        logger.info("Aproveitamento de " + strPer + "%");
        this.validationOptions = null;
        System.gc();
    }

    private void saveLists() {
        logger.debug("Iniciando COMMIT");
        logger.debug("de " + this.atualizados.size() + " registroItem");
        this.m_dao.updateCdValidacao(this.atualizados);
        this.atualizados = new ArrayList<RegistroItem>();
        logger.debug("de " + this.errosList.size() + " registroItemErro");
        this.m_dao.saveList(this.errosList);
        this.errosList = new ArrayList<RegistroItemErro>();
        this.m_dao.commit();
        this.m_dao.clear();
        System.gc();
        this.m_dao.beginTransaction();
        logger.debug("Commit finalizado.");
    }

    private void logError(RegistroItem ri, TipoErro tipo, String msg) {
        this.logError(ri, new RegistroItemErro(ri, tipo, msg));
    }

    private void logError(RegistroItem ri, RegistroItemErro erro) {
        logger.error("[" + ri.getIdRegistroItem() + "] " + erro.getTipoErro().getNoTipoErro());
        logger.error(erro.getDeDetalheItemErro());
        this.errosList.add(erro);
    }
}

