/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.install;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.install.ConfigDb;
import br.gov.lexml.borda.install.ContextoInstalacao;
import br.gov.lexml.borda.install.PassoInstalacao;
import br.gov.lexml.exceptions.InstalacaoException;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassoConfigurarWar
extends PassoInstalacao<ContextoInstalacao> {
    private static ConfigDb configDb = ConfigDb.getInstance();

    @Override
    public String executa() throws Exception {
        try {
            this.configuraWar();
        }
        catch (Exception e) {
            throw new InstalacaoException("Falha configurar a aplicacao.", e);
        }
        return null;
    }

    private void configuraWar() throws Exception {
        String pathWar = this.encontraWar();
        System.out.println("\nAtualizando arquivo " + pathWar + " ...");
        de.schlichtherle.io.File war = new de.schlichtherle.io.File(pathWar);
        de.schlichtherle.io.File origem = new de.schlichtherle.io.File(LexMLUtil.getPathJpaProperties());
        de.schlichtherle.io.File destino = new de.schlichtherle.io.File((File)war, "WEB-INF/classes/lexml-db.properties");
        destino.delete();
        PassoConfigurarWar.copyFile(origem, destino);
        origem = new de.schlichtherle.io.File(LexMLUtil.getPathPerfilNodoBorda());
        destino = new de.schlichtherle.io.File((File)war, "WEB-INF/classes/lexml_nbconfig.xml");
        PassoConfigurarWar.copyFile(origem, destino);
        de.schlichtherle.io.File.umount(war);
        ((ContextoInstalacao)this.contexto).setWarOk(true);
    }

    private String encontraWar() throws Exception {
        de.schlichtherle.io.File dir2;
        de.schlichtherle.io.File file = dir2 = LexMLUtil.isDesenvolvimento() ? new de.schlichtherle.io.File("oai") : new de.schlichtherle.io.File("../oai");
        if (!dir2.isDirectory()) {
            throw new FileNotFoundException("Diretorio \"oai\" nao encontrado.");
        }
        String[] files = dir2.list(new FilenameFilter(){

            public boolean accept(File dir2, String name) {
                return name.startsWith("oai") && name.endsWith(".war");
            }
        });
        if (files.length == 0) {
            throw new FileNotFoundException("Arquivo oai.war nao encontrado.");
        }
        return String.valueOf(dir2.getCanonicalPath()) + de.schlichtherle.io.File.separator + files[0];
    }

    public static void copyFile(de.schlichtherle.io.File from, de.schlichtherle.io.File to) throws IOException {
        byte[] buffer = new byte[102400];
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        int i = 0;
        while ((i = in.read(buffer)) > 0) {
            out.write(buffer, 0, i);
        }
        in.close();
        out.close();
    }
}

