/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.util.LEDataOutputStream;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class BasicZipOutputStream
extends FilterOutputStream {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final String charset;
    private final CRC32 crc = new CRC32();
    private final ZipDeflater def = new ZipDeflater();
    private final byte[] dbuf = new byte[65536];
    private final byte[] sbuf = new byte[1];
    private String comment = "";
    private short method = (short)8;
    private final Map entries = new LinkedHashMap();
    private long dataStart;
    private long cdOffset;
    private long cdLength;
    private boolean finished;
    private boolean closed;
    private ZipEntry entry;
    private boolean deflate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicZipOutputStream(OutputStream out) throws NullPointerException {
        super(BasicZipOutputStream.toLEDataOutputStream(out));
        if (out == null) {
            throw new NullPointerException();
        }
        this.charset = DEFAULT_CHARSET;
    }

    public BasicZipOutputStream(OutputStream out, String charset) throws NullPointerException, UnsupportedEncodingException {
        super(BasicZipOutputStream.toLEDataOutputStream(out));
        if (out == null || charset == null) {
            throw new NullPointerException();
        }
        "".getBytes(charset);
        this.charset = charset;
    }

    private static LEDataOutputStream toLEDataOutputStream(OutputStream out) {
        return out instanceof LEDataOutputStream ? (LEDataOutputStream)out : new LEDataOutputStream(out);
    }

    public String getEncoding() {
        return this.charset;
    }

    public int size() {
        return this.entries.size();
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String name) {
        return (ZipEntry)this.entries.get(name);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getLevel() {
        return this.def.getLevel();
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = (short)method;
    }

    public long length() {
        return ((LEDataOutputStream)this.out).size();
    }

    public boolean isBusy() {
        return this.entry != null;
    }

    public final void putNextEntry(ZipEntry entry) throws IOException {
        this.putNextEntry(entry, true);
    }

    public void putNextEntry(ZipEntry entry, boolean deflate) throws IOException {
        this.closeEntry();
        String name = entry.getName();
        long size = entry.getNameLength(this.charset) + entry.getExtraLength() + entry.getCommentLength(this.charset);
        if (size > 65535L) {
            throw new ZipException(entry.getName() + ": sum of name, extra fields and comment too long: " + size);
        }
        int method = entry.getMethod();
        if (method == -1) {
            method = this.getMethod();
        }
        switch (method) {
            case 0: {
                BasicZipOutputStream.checkLocalFileHeaderData(entry);
                this.deflate = false;
                break;
            }
            case 8: {
                if (!deflate) {
                    BasicZipOutputStream.checkLocalFileHeaderData(entry);
                }
                this.deflate = deflate;
                break;
            }
            default: {
                throw new ZipException(entry.getName() + ": unsupported compression method: " + method);
            }
        }
        if (entry.getPlatform() == -1) {
            entry.setPlatform((short)0);
        }
        if (entry.getMethod() == -1) {
            entry.setMethod(method);
        }
        if (entry.getTime() == -1L) {
            entry.setTime(System.currentTimeMillis());
        }
        this.entry = entry;
        this.writeLocalFileHeader();
        ZipEntry old = this.entries.put(name, entry);
        if (!$assertionsDisabled && old != null) {
            throw new AssertionError();
        }
    }

    private static void checkLocalFileHeaderData(ZipEntry entry) throws ZipException {
        if (entry.getCrc() == -1L) {
            throw new ZipException("unknown CRC checksum");
        }
        if (entry.getCompressedSize() == -1L) {
            throw new ZipException("unknown compressed size");
        }
        if (entry.getSize() == -1L) {
            throw new ZipException("unknown size");
        }
    }

    private void writeLocalFileHeader() throws IOException {
        if (!$assertionsDisabled && this.entry == null) {
            throw new AssertionError();
        }
        ZipEntry entry = this.entry;
        LEDataOutputStream dos = (LEDataOutputStream)this.out;
        long offset = dos.size();
        this.finished = false;
        dos.writeInt(67324752);
        boolean dataDescriptor = entry.getCrc() == -1L || entry.getCompressedSize() == -1L || entry.getSize() == -1L;
        boolean utf8 = DEFAULT_CHARSET.equalsIgnoreCase(this.charset);
        int general = (dataDescriptor ? 8 : 0) | (utf8 ? 2048 : 0);
        dos.writeShort(dataDescriptor ? 20 : 10);
        dos.writeShort(general);
        dos.writeShort(entry.getMethod());
        dos.writeInt((int)entry.getDosTime());
        if (dataDescriptor) {
            dos.writeInt(0);
            dos.writeInt(0);
            dos.writeInt(0);
        } else {
            dos.writeInt((int)entry.getCrc());
            dos.writeInt((int)entry.getCompressedSize());
            dos.writeInt((int)entry.getSize());
        }
        byte[] name = entry.getName().getBytes(this.charset);
        dos.writeShort(name.length);
        byte[] extra = entry.getExtra();
        if (extra == null) {
            extra = new byte[]{};
        }
        dos.writeShort(extra.length);
        dos.write(name);
        dos.write(extra);
        entry.setGeneral(general);
        entry.offset = offset;
        this.dataStart = dos.size();
    }

    public void write(int b) throws IOException {
        byte[] buf = this.sbuf;
        buf[0] = (byte)b;
        this.write(buf, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.entry != null) {
            if (len == 0) {
                return;
            }
            if (this.deflate) {
                if (!$assertionsDisabled && this.def.finished()) {
                    throw new AssertionError();
                }
                this.def.setInput(b, off, len);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
                this.crc.update(b, off, len);
            } else {
                this.out.write(b, off, len);
                if (this.entry.getMethod() != 8) {
                    this.crc.update(b, off, len);
                }
            }
        } else {
            this.out.write(b, off, len);
        }
    }

    private final void deflate() throws IOException {
        int dlen = this.def.deflate(this.dbuf, 0, this.dbuf.length);
        if (dlen > 0) {
            this.out.write(this.dbuf, 0, dlen);
        }
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        switch (this.entry.getMethod()) {
            case 0: {
                long expectedCrc = this.crc.getValue();
                if (expectedCrc != this.entry.getCrc()) {
                    throw new ZipException(this.entry.getName() + ": bad entry CRC-32: " + Long.toHexString(this.entry.getCrc()) + " expected: " + Long.toHexString(expectedCrc));
                }
                long written = ((LEDataOutputStream)this.out).size();
                if (this.entry.getSize() == written - this.dataStart) break;
                throw new ZipException(this.entry.getName() + ": bad entry size: " + this.entry.getSize() + " expected: " + (written - this.dataStart));
            }
            case 8: {
                if (!this.deflate) break;
                if (!$assertionsDisabled && this.def.finished()) {
                    throw new AssertionError();
                }
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
                this.entry.setCrc(this.crc.getValue());
                this.entry.setCompressedSize((long)this.def.getTotalOut() & 0xFFFFFFFFL);
                this.entry.setSize((long)this.def.getTotalIn() & 0xFFFFFFFFL);
                this.def.reset();
                break;
            }
            default: {
                throw new ZipException(this.entry.getName() + ": unsupported compression method: " + this.entry.getMethod());
            }
        }
        this.writeDataDescriptor();
        this.flush();
        this.crc.reset();
        this.entry = null;
    }

    private void writeDataDescriptor() throws IOException {
        ZipEntry entry = this.entry;
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError();
        }
        if (!entry.getGeneralBit(3)) {
            return;
        }
        LEDataOutputStream dos = (LEDataOutputStream)this.out;
        dos.writeInt(134695760);
        dos.writeInt((int)entry.getCrc());
        dos.writeInt((int)entry.getCompressedSize());
        dos.writeInt((int)entry.getSize());
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.closeEntry();
        LEDataOutputStream dos = (LEDataOutputStream)this.out;
        this.cdOffset = dos.size();
        Iterator i = this.entries.values().iterator();
        while (i.hasNext()) {
            this.writeCentralFileHeader((ZipEntry)i.next());
        }
        this.cdLength = dos.size() - this.cdOffset;
        this.writeEndOfCentralDirectory();
    }

    private void writeCentralFileHeader(ZipEntry ze) throws IOException {
        if (!$assertionsDisabled && ze == null) {
            throw new AssertionError();
        }
        LEDataOutputStream dos = (LEDataOutputStream)this.out;
        dos.writeInt(33639248);
        dos.writeShort(ze.getPlatform() << 8 | 0x3F);
        dos.writeShort(ze.getGeneralBit(3) ? 20 : 10);
        dos.writeShort(ze.getGeneral());
        dos.writeShort(ze.getMethod());
        dos.writeInt((int)ze.getDosTime());
        dos.writeInt((int)ze.getCrc());
        dos.writeInt((int)ze.getCompressedSize());
        dos.writeInt((int)ze.getSize());
        byte[] name = ze.getName().getBytes(this.charset);
        dos.writeShort(name.length);
        byte[] extra = ze.getExtra();
        if (extra == null) {
            extra = new byte[]{};
        }
        dos.writeShort(extra.length);
        String comment = ze.getComment();
        if (comment == null) {
            comment = "";
        }
        byte[] data = comment.getBytes(this.charset);
        dos.writeShort(data.length);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeInt(0);
        dos.writeInt((int)ze.offset);
        dos.write(name);
        dos.write(extra);
        dos.write(data);
    }

    private void writeEndOfCentralDirectory() throws IOException {
        LEDataOutputStream dos = (LEDataOutputStream)this.out;
        dos.writeInt(101010256);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(this.entries.size());
        dos.writeShort(this.entries.size());
        dos.writeInt((int)this.cdLength);
        dos.writeInt((int)this.cdOffset);
        String comment = this.getComment();
        if (comment == null) {
            comment = "";
        }
        byte[] data = comment.getBytes(this.charset);
        dos.writeShort(data.length);
        dos.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.finish();
        }
        finally {
            this.entries.clear();
            super.close();
        }
    }

    static {
        $assertionsDisabled = !BasicZipOutputStream.class.desiredAssertionStatus();
    }

    private static class ZipDeflater
    extends Deflater {
        private int level = -1;

        public ZipDeflater() {
            super(-1, true);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            super.setLevel(level);
            this.level = level;
        }
    }
}

