/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.util.Hashtable;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTASessionContext
implements CurrentSessionContext {
    private static final Logger log = LoggerFactory.getLogger(JTASessionContext.class);
    protected final SessionFactoryImplementor factory;
    private transient Map currentSessionMap = new Hashtable();

    public JTASessionContext(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    public Session currentSession() throws HibernateException {
        Transaction txn;
        TransactionManager transactionManager = this.factory.getTransactionManager();
        if (transactionManager == null) {
            throw new HibernateException("No TransactionManagerLookup specified");
        }
        try {
            txn = transactionManager.getTransaction();
            if (txn == null) {
                throw new HibernateException("Unable to locate current JTA transaction");
            }
            if (!JTAHelper.isInProgress(txn.getStatus())) {
                throw new HibernateException("Current transaction is not in progress");
            }
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new HibernateException("Problem locating/validating JTA transaction", t);
        }
        Transaction txnIdentifier = this.factory.getSettings().getTransactionManagerLookup() == null ? txn : this.factory.getSettings().getTransactionManagerLookup().getTransactionIdentifier(txn);
        Session currentSession = (Session)this.currentSessionMap.get(txnIdentifier);
        if (currentSession == null) {
            currentSession = this.buildOrObtainSession();
            try {
                txn.registerSynchronization(this.buildCleanupSynch(txnIdentifier));
            }
            catch (Throwable t) {
                try {
                    currentSession.close();
                }
                catch (Throwable ignore) {
                    log.debug("Unable to release generated current-session on failed synch registration", ignore);
                }
                throw new HibernateException("Unable to register cleanup Synchronization with TransactionManager");
            }
            this.currentSessionMap.put(txnIdentifier, currentSession);
        }
        return currentSession;
    }

    private CleanupSynch buildCleanupSynch(Object transactionIdentifier) {
        return new CleanupSynch(transactionIdentifier, this);
    }

    protected Session buildOrObtainSession() {
        return this.factory.openSession(null, this.isAutoFlushEnabled(), this.isAutoCloseEnabled(), this.getConnectionReleaseMode());
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    protected static class CleanupSynch
    implements Synchronization {
        private Object transactionIdentifier;
        private JTASessionContext context;

        public CleanupSynch(Object transactionIdentifier, JTASessionContext context) {
            this.transactionIdentifier = transactionIdentifier;
            this.context = context;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            this.context.currentSessionMap.remove(this.transactionIdentifier);
        }
    }
}

