/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.javassist;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.javassist.SerializableProxy;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;
import org.slf4j.LoggerFactory;

public class JavassistLazyInitializer
extends BasicLazyInitializer
implements MethodHandler {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return m.getParameterTypes().length != 0 || !m.getName().equals("finalize");
        }
    };
    private Class[] interfaces;
    private boolean constructed = false;

    private JavassistLazyInitializer(String entityName, Class persistentClass, Class[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, SessionImplementor session) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        this.interfaces = interfaces;
    }

    public static HibernateProxy getProxy(String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        try {
            JavassistLazyInitializer instance = new JavassistLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(interfaces.length == 1 ? persistentClass : null);
            factory.setInterfaces(interfaces);
            factory.setFilter(FINALIZE_FILTER);
            Class cl = factory.createClass();
            HibernateProxy proxy = (HibernateProxy)cl.newInstance();
            ((ProxyObject)((Object)proxy)).setHandler(instance);
            instance.constructed = true;
            return proxy;
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(BasicLazyInitializer.class).error("Javassist Enhancement failed: " + entityName, t);
            throw new HibernateException("Javassist Enhancement failed: " + entityName, t);
        }
    }

    public static HibernateProxy getProxy(Class factory, String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        HibernateProxy proxy;
        JavassistLazyInitializer instance = new JavassistLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        try {
            proxy = (HibernateProxy)factory.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Javassist Enhancement failed: " + persistentClass.getName(), e);
        }
        ((ProxyObject)((Object)proxy)).setHandler(instance);
        instance.constructed = true;
        return proxy;
    }

    public static Class getProxyFactory(Class persistentClass, Class[] interfaces) throws HibernateException {
        try {
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(interfaces.length == 1 ? persistentClass : null);
            factory.setInterfaces(interfaces);
            factory.setFilter(FINALIZE_FILTER);
            return factory.createClass();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(BasicLazyInitializer.class).error("Javassist Enhancement failed: " + persistentClass.getName(), t);
            throw new HibernateException("Javassist Enhancement failed: " + persistentClass.getName(), t);
        }
    }

    public Object invoke(Object proxy, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (this.constructed) {
            Object result;
            try {
                result = this.invoke(thisMethod, args, proxy);
            }
            catch (Throwable t) {
                throw new Exception(t.getCause());
            }
            if (result == INVOKE_IMPLEMENTATION) {
                Object target = this.getImplementation();
                try {
                    Object returnValue;
                    if (ReflectHelper.isPublic(this.persistentClass, thisMethod)) {
                        if (!thisMethod.getDeclaringClass().isInstance(target)) {
                            throw new ClassCastException(target.getClass().getName());
                        }
                        returnValue = thisMethod.invoke(target, args);
                    } else {
                        if (!thisMethod.isAccessible()) {
                            thisMethod.setAccessible(true);
                        }
                        returnValue = thisMethod.invoke(target, args);
                    }
                    return returnValue == target ? proxy : returnValue;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return result;
        }
        if (thisMethod.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        return proceed.invoke(proxy, args);
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifier(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

