/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import org.apache.tools.ant.BuildException;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.util.ReflectHelper;

public class GenericExporterTask
extends ExporterTask {
    String templateName;
    String exporterClass;
    String filePattern;
    String forEach;

    public GenericExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setForEach(String forEach) {
        this.forEach = forEach;
    }

    public void setTemplate(String templateName) {
        this.templateName = templateName;
    }

    public void setExporterClass(String exporterClass) {
        this.exporterClass = exporterClass;
    }

    protected Exporter createExporter() {
        if (this.exporterClass == null) {
            return new GenericExporter();
        }
        try {
            Class theClass = ReflectHelper.classForName(this.exporterClass);
            return (Exporter)theClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Could not find custom exporter class: " + this.exporterClass, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Could not create custom exporter class: " + this.exporterClass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Could not access custom exporter class: " + this.exporterClass, (Throwable)e);
        }
    }

    protected Exporter configureExporter(Exporter exp) {
        super.configureExporter(exp);
        if (exp instanceof GenericExporter) {
            GenericExporter exporter = (GenericExporter)exp;
            if (this.filePattern != null) {
                exporter.setFilePattern(this.filePattern);
            }
            if (this.templateName != null) {
                exporter.setTemplateName(this.templateName);
            }
            if (this.forEach != null) {
                exporter.setForEach(this.forEach);
            }
        }
        return exp;
    }

    public String getName() {
        StringBuffer buf = new StringBuffer("generic exporter");
        if (this.exporterClass != null) {
            buf.append("class: " + this.exporterClass);
        }
        if (this.templateName != null) {
            buf.append("template: " + this.templateName);
        }
        return buf.toString();
    }
}

