/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.visitor.EntityNameFromValueVisitor;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.EntityModelDetector;

public class BadCachingDetector
extends EntityModelDetector {
    public String getName() {
        return "cache";
    }

    public void visitProperty(Configuration configuration, PersistentClass clazz, Property property, IssueCollector collector) {
        PersistentClass classMapping;
        String entityName;
        Collection col;
        Value value = property.getValue();
        if (value instanceof Collection && (col = (Collection)value).getCacheConcurrencyStrategy() != null && !col.getElement().isSimpleValue() && (entityName = (String)col.getElement().accept(new EntityNameFromValueVisitor())) != null && (classMapping = configuration.getClassMapping(entityName)).getCacheConcurrencyStrategy() == null) {
            collector.reportIssue(new Issue("CACHE_COLLECTION_NONCACHABLE_TARGET", 100, "Entity '" + classMapping.getEntityName() + "' is referenced from the cache-enabled collection '" + col.getRole() + "' without the entity being cachable"));
        }
    }
}

