/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.LexMLConfig;
import br.gov.lexml.LexMLConstants;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.helper.BOHelper;
import br.gov.lexml.exceptions.ConfigFailedException;
import br.gov.lexml.oaiLexml.LexMLDocument;
import br.gov.lexml.oaiLexml.LexMLType;
import br.gov.lexml.oaiLexml.RelacionamentoType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlAnySimpleType;

public class URNBO
implements LexMLConstants {
    private static Logger logger = Logger.getLogger(BOHelper.class.getName());
    private Set<String> nucleosValidos;
    private LexMLConfig config;
    private String tstNucleoURN;
    private String tstNucleoURNAutoridadeReduzida;
    private String tstNucleoURNTipoReduzida;
    private BOHelper m_helper;

    public URNBO(BOHelper helper) throws ConfigFailedException {
        this.m_helper = helper;
        this.config = LexMLConfig.getInstance();
        this.compilarPerfisValidos();
    }

    private void compilarPerfisValidos() {
        if (this.nucleosValidos != null) {
            return;
        }
        this.nucleosValidos = new HashSet<String>();
        for (LexMLConfig.Publicador publicador : this.config.getPublicadores()) {
            BigInteger idPublicador = publicador.getIdPublicador();
            ArrayList<LexMLConfig.Perfil> perfis = publicador.getPerfil();
            if (perfis == null) continue;
            for (LexMLConfig.Perfil perfil : perfis) {
                String nucleo = perfil.getNucleoUrn();
                String tipoPerfil = perfil.getTipoPerfil();
                if (tipoPerfil.equals("T")) {
                    this.nucleosValidos.add(idPublicador + ":" + "D" + ":" + nucleo);
                    this.nucleosValidos.add(idPublicador + ":" + "R" + ":" + nucleo);
                    continue;
                }
                this.nucleosValidos.add(idPublicador + ":" + tipoPerfil + ":" + nucleo);
            }
        }
        logger.debug("TOTAL DE " + this.nucleosValidos.size() + " PERFIS ADICIONADOS");
    }

    private boolean isEstruturalmenteValid(String urn) {
        if (!urn.startsWith("urn:lex:")) {
            return false;
        }
        String[] part = urn.substring(8).split(":");
        if (part.length < 3) {
            return false;
        }
        this.tstNucleoURNAutoridadeReduzida = null;
        this.tstNucleoURNTipoReduzida = null;
        this.tstNucleoURN = String.valueOf(part[0]) + ":" + part[1] + ":" + part[2];
        if (part[1].contains(";") && part[2].contains(";")) {
            String autoridade = part[1].substring(0, part[1].indexOf(";"));
            String tipo = part[2].substring(0, part[2].indexOf(";"));
            this.tstNucleoURNAutoridadeReduzida = String.valueOf(part[0]) + ":" + autoridade + ":" + part[2];
            this.tstNucleoURNTipoReduzida = String.valueOf(part[0]) + ":" + part[1] + ":" + tipo;
        }
        return true;
    }

    private boolean isDocumentoIndividualValid(BigInteger p_idPublicador) {
        if (p_idPublicador == null) {
            return false;
        }
        if (this.isCoreValid(p_idPublicador, this.tstNucleoURN, "D")) {
            return true;
        }
        return this.isCoreValid(p_idPublicador, this.tstNucleoURNAutoridadeReduzida, "D") && this.isCoreValid(p_idPublicador, this.tstNucleoURNTipoReduzida, "D");
    }

    private boolean isRelacionamentoValid(String p_urn, BigInteger p_idPublicador) {
        if (!this.isEstruturalmenteValid(p_urn)) {
            return false;
        }
        if (this.isCoreValid(p_idPublicador, this.tstNucleoURN, "R")) {
            return true;
        }
        return this.isCoreValid(p_idPublicador, this.tstNucleoURNAutoridadeReduzida, "R") && this.isCoreValid(p_idPublicador, this.tstNucleoURNTipoReduzida, "R");
    }

    private boolean isCoreValid(BigInteger p_idPublicador, String nucleoURN, String p_tipoCore) {
        if (nucleoURN == null) {
            return false;
        }
        return this.nucleosValidos.contains(p_idPublicador + ":" + p_tipoCore + ":" + nucleoURN);
    }

    public RegistroItemErro validaDocumento(RegistroItem ri, LexMLDocument doc) {
        XmlAnySimpleType relacionamento;
        BigInteger idPublicador;
        String tstURNDocumentoIndividual = doc.getLexML().getDocumentoIndividual().getStringValue();
        LexMLType.Item[] itens = doc.getLexML().getItemArray();
        RelacionamentoType[] relacionamentos = doc.getLexML().getRelacionamentoArray();
        if (!this.isEstruturalmenteValid(tstURNDocumentoIndividual)) {
            return new RegistroItemErro(ri, this.m_helper.ERRO_URN_INVALIDO.tipo, "RV#5 A URN de DocumentoIndividual \"" + tstURNDocumentoIndividual + "\" \u00e9 estruturalmente inv\u00e1lida");
        }
        ArrayList<BigInteger> idPublicadoresTestados = new ArrayList<BigInteger>();
        XmlAnySimpleType[] xmlAnySimpleTypeArray = itens;
        int n = itens.length;
        int n2 = 0;
        while (n2 < n) {
            LexMLType.Item item = xmlAnySimpleTypeArray[n2];
            idPublicador = item.getIdPublicador();
            if (!idPublicadoresTestados.contains(idPublicador)) {
                if (!this.isDocumentoIndividualValid(idPublicador)) {
                    return new RegistroItemErro(ri, this.m_helper.ERRO_URN_INCOMPATIVEL.tipo, "RV#5 A URN de DocumentoIndividual \"" + tstURNDocumentoIndividual + "\" n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual em rela\u00e7\u00e3o ao perfil para o publicador \"" + item.getIdPublicador() + "\"");
                }
                idPublicadoresTestados.add(idPublicador);
            }
            ++n2;
        }
        xmlAnySimpleTypeArray = relacionamentos;
        n = relacionamentos.length;
        n2 = 0;
        while (n2 < n) {
            relacionamento = xmlAnySimpleTypeArray[n2];
            idPublicador = this.getIdPublicadorRelacionamento((RelacionamentoType)relacionamento, itens);
            if (!idPublicadoresTestados.contains(idPublicador)) {
                if (!this.isDocumentoIndividualValid(idPublicador)) {
                    return new RegistroItemErro(ri, this.m_helper.ERRO_URN_INCOMPATIVEL.tipo, "RV#5 A URN de DocumentoIndividual \"" + tstURNDocumentoIndividual + "\" n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual em rela\u00e7\u00e3o ao perfil para o relacionamento do publicador \"" + idPublicador + "\"");
                }
                idPublicadoresTestados.add(idPublicador);
            }
            ++n2;
        }
        xmlAnySimpleTypeArray = relacionamentos;
        n = relacionamentos.length;
        n2 = 0;
        while (n2 < n) {
            relacionamento = xmlAnySimpleTypeArray[n2];
            idPublicador = this.getIdPublicadorRelacionamento((RelacionamentoType)relacionamento, itens);
            String tstURNRelacionamento = relacionamento.getStringValue().trim();
            if (idPublicador == null) {
                return new RegistroItemErro(ri, this.m_helper.ERRO_URN_INCOMPATIVEL.tipo, "RV#8 A URN de Relacionamento \"" + tstURNRelacionamento + "\" n\u00e3o pode ser validada por aus\u00eancia de idPublicador");
            }
            if (!this.isRelacionamentoValid(tstURNRelacionamento, idPublicador)) {
                return new RegistroItemErro(ri, this.m_helper.ERRO_URN_INCOMPATIVEL.tipo, "RV#7 A URN de Relacionamento \"" + tstURNRelacionamento + "\" n\u00e3o \u00e9 compat\u00edvel com a configura\u00e7\u00e3o atual de perfil");
            }
            ++n2;
        }
        return null;
    }

    private BigInteger getIdPublicadorRelacionamento(RelacionamentoType relacionamento, LexMLType.Item[] itens) {
        BigInteger idPublicador = relacionamento.getIdPublicador();
        if (idPublicador == null && itens != null && itens.length > 0) {
            idPublicador = itens[0].getIdPublicador();
        }
        return idPublicador;
    }
}

