/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.ejb.Ejb3ConfigurationObjectFactory;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.EventListenerConfigurator;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.InjectionSettingsFactory;
import org.hibernate.ejb.Version;
import org.hibernate.ejb.connection.InjectedDataSourceConnectionProvider;
import org.hibernate.ejb.instrument.InterceptFieldClassFileTransformer;
import org.hibernate.ejb.packaging.ClassFilter;
import org.hibernate.ejb.packaging.Entry;
import org.hibernate.ejb.packaging.FileFilter;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.PackageFilter;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.hibernate.ejb.transaction.JoinableCMTTransactionFactory;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.ejb.util.LogHelper;
import org.hibernate.ejb.util.NamingHelper;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.event.EventListeners;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Configuration
implements Serializable,
Referenceable {
    private static final String IMPLEMENTATION_NAME = HibernatePersistence.class.getName();
    private static final String META_INF_ORM_XML = "META-INF/orm.xml";
    private final Logger log = LoggerFactory.getLogger(Ejb3Configuration.class);
    private static EntityNotFoundDelegate ejb3EntityNotFoundDelegate = new Ejb3EntityNotFoundDelegate();
    private static Configuration DEFAULT_CONFIGURATION = new AnnotationConfiguration();
    private String persistenceUnitName;
    private String cfgXmlResource;
    private AnnotationConfiguration cfg;
    private SettingsFactory settingsFactory = new InjectionSettingsFactory();
    private transient EventListenerConfigurator listenerConfigurator;
    private PersistenceUnitTransactionType transactionType;
    private boolean discardOnClose;
    private transient ClassLoader overridenClassLoader;
    private boolean isConfigurationProcessed = false;

    public Ejb3Configuration() {
        this.cfg = new AnnotationConfiguration(this.settingsFactory);
        this.cfg.setEntityNotFoundDelegate(ejb3EntityNotFoundDelegate);
        this.listenerConfigurator = new EventListenerConfigurator(this);
    }

    public void setDataSource(DataSource ds) {
        if (ds != null) {
            HashMap<String, DataSource> cpInjection = new HashMap<String, DataSource>();
            cpInjection.put("dataSource", ds);
            ((InjectionSettingsFactory)this.settingsFactory).setConnectionProviderInjectionData(cpInjection);
            this.setProperty("hibernate.connection.provider_class", InjectedDataSourceConnectionProvider.class.getName());
        }
    }

    private Ejb3Configuration configure(PersistenceMetadata metadata, Map overrides) {
        this.log.debug("Creating Factory: {}", (Object)metadata.getName());
        HashMap<String, Object> workingVars = new HashMap<String, Object>();
        workingVars.put("hibernate.ejb.persistenceUnitName", metadata.getName());
        this.persistenceUnitName = metadata.getName();
        if (StringHelper.isNotEmpty(metadata.getJtaDatasource())) {
            this.setProperty("hibernate.connection.datasource", metadata.getJtaDatasource());
        } else if (StringHelper.isNotEmpty(metadata.getNonJtaDatasource())) {
            this.setProperty("hibernate.connection.datasource", metadata.getNonJtaDatasource());
        }
        this.defineTransactionType((Object)metadata.getTransactionType(), workingVars);
        if (metadata.getClasses().size() > 0) {
            workingVars.put("hibernate.ejb.classes", metadata.getClasses());
        }
        if (metadata.getPackages().size() > 0) {
            workingVars.put("hibernate.ejb.packages", metadata.getPackages());
        }
        if (metadata.getMappingFiles().size() > 0) {
            workingVars.put("hibernate.ejb.xml_files", metadata.getMappingFiles());
        }
        if (metadata.getHbmfiles().size() > 0) {
            workingVars.put("hibernate.hbmxml.files", metadata.getHbmfiles());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metadata.getProps());
        if (overrides != null) {
            for (Map.Entry entry : overrides.entrySet()) {
                Object value = entry.getValue();
                props.put(entry.getKey(), value == null ? "" : value);
            }
        }
        this.configure(props, workingVars);
        return this;
    }

    public Ejb3Configuration configure(String persistenceUnitName, Map integration) {
        try {
            this.log.debug("Look up for persistence unit: {}", (Object)persistenceUnitName);
            integration = integration == null ? CollectionHelper.EMPTY_MAP : Collections.unmodifiableMap(integration);
            Enumeration<URL> xmls = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            if (!xmls.hasMoreElements()) {
                this.log.info("Could not find any META-INF/persistence.xml file in the classpath");
            }
            while (xmls.hasMoreElements()) {
                URL url = xmls.nextElement();
                this.log.trace("Analysing persistence.xml: {}", url);
                List<PersistenceMetadata> metadataFiles = PersistenceXmlLoader.deploy(url, integration, this.cfg.getEntityResolver(), PersistenceUnitTransactionType.RESOURCE_LOCAL);
                for (PersistenceMetadata metadata : metadataFiles) {
                    this.log.trace("{}", metadata);
                    if (metadata.getProvider() != null && !IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProvider())) continue;
                    JarVisitor visitor = null;
                    if (metadata.getName() == null) {
                        visitor = this.getMainJarVisitor(url, metadata, integration);
                        metadata.setName(visitor.getUnqualifiedJarName());
                    }
                    if (persistenceUnitName == null && xmls.hasMoreElements()) {
                        throw new PersistenceException("No name provided and several persistence units found");
                    }
                    if (persistenceUnitName != null && !metadata.getName().equals(persistenceUnitName)) continue;
                    if (visitor == null) {
                        visitor = this.getMainJarVisitor(url, metadata, integration);
                    }
                    Ejb3Configuration.addMetadataFromVisitor(visitor, metadata);
                    Filter[] otherXmlFilter = this.getFilters(metadata, integration, false);
                    for (String jarFile : metadata.getJarFiles()) {
                        visitor = JarVisitorFactory.getVisitor(jarFile, otherXmlFilter);
                        Ejb3Configuration.addMetadataFromVisitor(visitor, metadata);
                    }
                    return this.configure(metadata, integration);
                }
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof PersistenceException) {
                throw (PersistenceException)e;
            }
            throw new PersistenceException(this.getExceptionHeader() + "Unable to configure EntityManagerFactory", e);
        }
    }

    private JarVisitor getMainJarVisitor(URL url, PersistenceMetadata metadata, Map integration) {
        URL jarURL = JarVisitorFactory.getJarURLFromURLEntry(url, "/META-INF/persistence.xml");
        Filter[] persistenceXmlFilter = this.getFilters(metadata, integration, metadata.getExcludeUnlistedClasses());
        return JarVisitorFactory.getVisitor(jarURL, persistenceXmlFilter);
    }

    private static void addMetadataFromVisitor(JarVisitor visitor, PersistenceMetadata metadata) throws IOException {
        List<String> classes = metadata.getClasses();
        List<String> packages = metadata.getPackages();
        List<NamedInputStream> hbmFiles = metadata.getHbmfiles();
        List<String> mappingFiles = metadata.getMappingFiles();
        Ejb3Configuration.addScannedEntries(visitor, classes, packages, hbmFiles, mappingFiles);
    }

    private static void addScannedEntries(JarVisitor visitor, List<String> classes, List<String> packages, List<NamedInputStream> hbmFiles, List<String> mappingFiles) throws IOException {
        Filter[] filters = visitor.getFilters();
        Set[] entries = visitor.getMatchingEntries();
        int size = filters.length;
        for (int index = 0; index < size; ++index) {
            for (Object o : entries[index]) {
                Entry entry = (Entry)o;
                if (filters[index] instanceof ClassFilter) {
                    classes.add(entry.getName());
                    continue;
                }
                if (filters[index] instanceof PackageFilter) {
                    packages.add(entry.getName());
                    continue;
                }
                if (!(filters[index] instanceof FileFilter)) continue;
                hbmFiles.add(new NamedInputStream(entry.getName(), entry.getInputStream()));
                if (mappingFiles == null) continue;
                mappingFiles.remove(entry.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration configure(PersistenceUnitInfo info, Map integration) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing {}", (Object)LogHelper.logPersistenceUnitInfo(info));
        } else {
            this.log.info("Processing PersistenceUnitInfo [\n\tname: {}\n\t...]", (Object)info.getPersistenceUnitName());
        }
        integration = integration != null ? Collections.unmodifiableMap(integration) : CollectionHelper.EMPTY_MAP;
        String provider = (String)integration.get("javax.persistence.provider");
        if (provider == null) {
            provider = info.getPersistenceProviderClassName();
        }
        if (provider != null && !provider.trim().startsWith(IMPLEMENTATION_NAME)) {
            this.log.info("Required a different provider: {}", (Object)provider);
            return null;
        }
        if (info.getClassLoader() == null) {
            throw new IllegalStateException("[PersistenceUnit: " + info.getPersistenceUnitName() == null ? "" : info.getPersistenceUnitName() + "] " + "PersistenceUnitInfo.getClassLoader() id null");
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        boolean sameClassLoader = info.getClassLoader().equals(contextClassLoader);
        if (!sameClassLoader) {
            this.overridenClassLoader = info.getClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        } else {
            this.overridenClassLoader = null;
        }
        try {
            PersistenceUnitTransactionType transactionType;
            String dataSource;
            HashMap<String, Object> workingVars = new HashMap<String, Object>();
            workingVars.put("hibernate.ejb.persistenceUnitName", info.getPersistenceUnitName());
            this.persistenceUnitName = info.getPersistenceUnitName();
            ArrayList<String> entities = new ArrayList<String>(50);
            if (info.getManagedClassNames() != null) {
                entities.addAll(info.getManagedClassNames());
            }
            ArrayList<NamedInputStream> hbmFiles = new ArrayList<NamedInputStream>();
            ArrayList<String> packages = new ArrayList<String>();
            ArrayList<String> xmlFiles = new ArrayList<String>(50);
            if (info.getMappingFileNames() != null) {
                xmlFiles.addAll(info.getMappingFileNames());
            }
            boolean searchForORMFiles = !xmlFiles.contains(META_INF_ORM_XML);
            boolean[] detectArtifactForOtherJars = this.getDetectedArtifacts(info.getProperties(), null, false);
            boolean[] detectArtifactForMainJar = this.getDetectedArtifacts(info.getProperties(), null, info.excludeUnlistedClasses());
            for (URL jar : info.getJarFileUrls()) {
                this.scanForClasses(jar, packages, entities, hbmFiles, detectArtifactForOtherJars, searchForORMFiles);
            }
            this.scanForClasses(info.getPersistenceUnitRootUrl(), packages, entities, hbmFiles, detectArtifactForMainJar, searchForORMFiles);
            Properties properties = info.getProperties() != null ? info.getProperties() : new Properties();
            ConfigurationHelper.overrideProperties(properties, integration);
            this.addXMLEntities(xmlFiles, info, entities);
            if ("true".equalsIgnoreCase(properties.getProperty("hibernate.ejb.use_class_enhancer"))) {
                info.addTransformer(new InterceptFieldClassFileTransformer(entities));
            }
            workingVars.put("hibernate.ejb.classes", entities);
            workingVars.put("hibernate.ejb.packages", packages);
            workingVars.put("hibernate.ejb.xml_files", xmlFiles);
            if (hbmFiles.size() > 0) {
                workingVars.put("hibernate.hbmxml.files", hbmFiles);
            }
            Boolean isJTA = null;
            boolean overridenDatasource = false;
            if (integration.containsKey("javax.persistence.jtaDataSource")) {
                dataSource = (String)integration.get("javax.persistence.jtaDataSource");
                overridenDatasource = true;
                properties.setProperty("hibernate.connection.datasource", dataSource);
                isJTA = Boolean.TRUE;
            }
            if (integration.containsKey("javax.persistence.nonJtaDataSource")) {
                dataSource = (String)integration.get("javax.persistence.nonJtaDataSource");
                overridenDatasource = true;
                properties.setProperty("hibernate.connection.datasource", dataSource);
                if (isJTA == null) {
                    isJTA = Boolean.FALSE;
                }
            }
            if (!(overridenDatasource || info.getJtaDataSource() == null && info.getNonJtaDataSource() == null)) {
                isJTA = info.getJtaDataSource() != null ? Boolean.TRUE : Boolean.FALSE;
                this.setDataSource(isJTA != false ? info.getJtaDataSource() : info.getNonJtaDataSource());
                this.setProperty("hibernate.connection.provider_class", InjectedDataSourceConnectionProvider.class.getName());
            }
            if ((transactionType = info.getTransactionType()) == null) {
                transactionType = isJTA == Boolean.TRUE ? PersistenceUnitTransactionType.JTA : (isJTA == Boolean.FALSE ? PersistenceUnitTransactionType.RESOURCE_LOCAL : PersistenceUnitTransactionType.JTA);
            }
            this.defineTransactionType((Object)transactionType, workingVars);
            this.configure(properties, workingVars);
        }
        finally {
            if (!sameClassLoader) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
        return this;
    }

    private void addXMLEntities(List<String> xmlFiles, PersistenceUnitInfo info, List<String> entities) {
        ClassLoader newTempClassLoader = info.getNewTempClassLoader();
        if (newTempClassLoader == null) {
            this.log.warn("Persistence provider caller does not implement the EJB3 spec correctly. PersistenceUnitInfo.getNewTempClassLoader() is null.");
            return;
        }
        XMLHelper xmlHelper = new XMLHelper();
        ArrayList errors = new ArrayList();
        SAXReader saxReader = xmlHelper.createSAXReader("XML InputStream", errors, this.cfg.getEntityResolver());
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://java.sun.com/xml/ns/persistence/orm orm_1_0.xsd");
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
        for (String xmlFile : xmlFiles) {
            InputStream resourceAsStream = newTempClassLoader.getResourceAsStream(xmlFile);
            if (resourceAsStream == null) continue;
            BufferedInputStream is = new BufferedInputStream(resourceAsStream);
            try {
                errors.clear();
                Document doc = saxReader.read(is);
                if (errors.size() != 0) {
                    throw new MappingException("invalid mapping: " + xmlFile, (Throwable)errors.get(0));
                }
                Element rootElement = doc.getRootElement();
                if (rootElement != null && "entity-mappings".equals(rootElement.getName())) {
                    String classname;
                    Element element = rootElement.element("package");
                    String defaultPackage = element != null ? element.getTextTrim() : null;
                    List elements = rootElement.elements("entity");
                    for (Element subelement : elements) {
                        classname = XMLContext.buildSafeClassName(subelement.attributeValue("class"), defaultPackage);
                        if (entities.contains(classname)) continue;
                        entities.add(classname);
                    }
                    elements = rootElement.elements("mapped-superclass");
                    for (Element subelement : elements) {
                        classname = XMLContext.buildSafeClassName(subelement.attributeValue("class"), defaultPackage);
                        if (entities.contains(classname)) continue;
                        entities.add(classname);
                    }
                    elements = rootElement.elements("embeddable");
                    for (Element subelement : elements) {
                        classname = XMLContext.buildSafeClassName(subelement.attributeValue("class"), defaultPackage);
                        if (entities.contains(classname)) continue;
                        entities.add(classname);
                    }
                    continue;
                }
                if (rootElement == null || !"hibernate-mappings".equals(rootElement.getName())) continue;
            }
            catch (DocumentException e) {
                throw new MappingException("Could not parse mapping document in input stream", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    this.log.warn("Could not close input stream", ioe);
                }
            }
        }
    }

    private void defineTransactionType(Object overridenTxType, Map workingVars) {
        if (overridenTxType != null) {
            if (overridenTxType instanceof String) {
                this.transactionType = PersistenceXmlLoader.getTransactionType((String)overridenTxType);
            } else if (overridenTxType instanceof PersistenceUnitTransactionType) {
                this.transactionType = (PersistenceUnitTransactionType)((Object)overridenTxType);
            } else {
                throw new PersistenceException(this.getExceptionHeader() + "javax.persistence.transactionType" + " of the wrong class type" + ": " + overridenTxType.getClass());
            }
        }
    }

    public Ejb3Configuration setProperty(String key, String value) {
        this.cfg.setProperty(key, value);
        return this;
    }

    private boolean[] getDetectedArtifacts(Properties properties, Map overridenProperties, boolean excludeIfNotOverriden) {
        boolean[] result = new boolean[]{false, false};
        String detect = overridenProperties != null ? (String)overridenProperties.get("hibernate.archive.autodetection") : null;
        String string = detect = detect == null ? properties.getProperty("hibernate.archive.autodetection") : detect;
        if (detect == null && excludeIfNotOverriden) {
            return result;
        }
        if (detect == null) {
            detect = "class,hbm";
        }
        StringTokenizer st = new StringTokenizer(detect, ", ", false);
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            if ("class".equalsIgnoreCase(element)) {
                result[0] = true;
            }
            if (!"hbm".equalsIgnoreCase(element)) continue;
            result[1] = true;
        }
        this.log.debug("Detect class: {}; detect hbm: {}", result[0], (Object)result[1]);
        return result;
    }

    private Filter[] getFilters(PersistenceMetadata metadata, Map overridenProperties, boolean excludeIfNotOverriden) {
        Properties properties = metadata.getProps();
        List<String> mappingFiles = metadata.getMappingFiles();
        boolean[] detectedArtifacts = this.getDetectedArtifacts(properties, overridenProperties, excludeIfNotOverriden);
        return this.getFilters(detectedArtifacts, true, mappingFiles);
    }

    private Filter[] getFilters(final boolean[] detectedArtifacts, final boolean searchORM, final List<String> mappingFiles) {
        final int mappingFilesSize = mappingFiles != null ? mappingFiles.size() : 0;
        int size = (detectedArtifacts[0] ? 2 : 0) + (searchORM || detectedArtifacts[1] || mappingFilesSize > 0 ? 1 : 0);
        Filter[] filters = new Filter[size];
        if (detectedArtifacts[0]) {
            filters[0] = new PackageFilter(false, null){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
            filters[1] = new ClassFilter(false, new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class}){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
        }
        if (detectedArtifacts[1] || searchORM || mappingFilesSize > 0) {
            filters[size - 1] = new FileFilter(true){

                public boolean accept(String javaElementName) {
                    return detectedArtifacts[1] && javaElementName.endsWith("hbm.xml") || searchORM && javaElementName.endsWith(Ejb3Configuration.META_INF_ORM_XML) || mappingFilesSize > 0 && mappingFiles.contains(javaElementName);
                }
            };
        }
        return filters;
    }

    private void scanForClasses(URL jar, List<String> packages, List<String> entities, List<NamedInputStream> hbmFiles, boolean[] detectedArtifacts, boolean searchORM) {
        if (jar == null) {
            this.log.error("Container is providing a null PersistenceUnitRootUrl: discovery impossible");
            return;
        }
        try {
            JarVisitor visitor = JarVisitorFactory.getVisitor(jar, this.getFilters(detectedArtifacts, searchORM, null));
            Ejb3Configuration.addScannedEntries(visitor, entities, packages, hbmFiles, null);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("error trying to scan <jar-file>: " + jar.toString(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading " + jar.toString(), e);
        }
    }

    public EntityManagerFactory createEntityManagerFactory(Map workingVars) {
        Properties props = new Properties();
        if (workingVars != null) {
            props.putAll((Map<?, ?>)workingVars);
            props.remove("hibernate.ejb.classes");
            props.remove("hibernate.ejb.packages");
            props.remove("hibernate.hbmxml.files");
            props.remove("hibernate.ejb.loaded.classes");
        }
        this.configure(props, workingVars);
        return this.buildEntityManagerFactory();
    }

    public EntityManagerFactory createEntityManagerFactory() {
        this.configure(this.cfg.getProperties(), new HashMap());
        return this.buildEntityManagerFactory();
    }

    public EntityManagerFactory buildEntityManagerFactory() {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.configure((Properties)null, null);
            NamingHelper.bind(this);
            EntityManagerFactoryImpl entityManagerFactoryImpl = new EntityManagerFactoryImpl(this.cfg.buildSessionFactory(), this.transactionType, this.discardOnClose, this.getSessionInterceptorClass(this.cfg.getProperties()));
            return entityManagerFactoryImpl;
        }
        catch (HibernateException e) {
            throw new PersistenceException(this.getExceptionHeader() + "Unable to build EntityManagerFactory", e);
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    private Class getSessionInterceptorClass(Properties properties) {
        String sessionInterceptorClassname = (String)properties.get("hibernate.ejb.interceptor.session_scoped");
        if (StringHelper.isNotEmpty(sessionInterceptorClassname)) {
            try {
                Class interceptorClass = ReflectHelper.classForName(sessionInterceptorClassname, Ejb3Configuration.class);
                interceptorClass.newInstance();
                return interceptorClass;
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to load " + "hibernate.ejb.interceptor.session_scoped" + ": " + sessionInterceptorClassname, e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to instanciate " + "hibernate.ejb.interceptor.session_scoped" + ": " + sessionInterceptorClassname, e);
            }
            catch (InstantiationException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to instanciate " + "hibernate.ejb.interceptor.session_scoped" + ": " + sessionInterceptorClassname, e);
            }
        }
        return null;
    }

    @Override
    public Reference getReference() throws NamingException {
        byte[] serialized;
        this.log.debug("Returning a Reference to the Ejb3Configuration");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(stream);
            out.writeObject(this);
            out.close();
            serialized = stream.toByteArray();
            stream.close();
        }
        catch (IOException e) {
            NamingException namingException = new NamingException("Unable to serialize Ejb3Configuration");
            namingException.setRootCause(e);
            throw namingException;
        }
        return new Reference(Ejb3Configuration.class.getName(), new BinaryRefAddr("object", serialized), Ejb3ConfigurationObjectFactory.class.getName(), null);
    }

    private Ejb3Configuration configure(Properties properties, Map workingVars) {
        if (this.isConfigurationProcessed) {
            return this;
        }
        this.isConfigurationProcessed = true;
        Properties preparedProperties = this.prepareProperties(properties, workingVars);
        if (workingVars == null) {
            workingVars = CollectionHelper.EMPTY_MAP;
        }
        if (preparedProperties.containsKey("hibernate.ejb.cfgfile")) {
            String cfgFileName = preparedProperties.getProperty("hibernate.ejb.cfgfile");
            this.cfg.configure(cfgFileName);
        }
        this.cfg.addProperties(preparedProperties);
        this.addClassesToSessionFactory(workingVars);
        ArrayList<String> jaccKeys = new ArrayList<String>();
        Interceptor defaultInterceptor = DEFAULT_CONFIGURATION.getInterceptor();
        NamingStrategy defaultNamingStrategy = DEFAULT_CONFIGURATION.getNamingStrategy();
        for (Object uncastObject : preparedProperties.keySet()) {
            if (uncastObject == null || !(uncastObject instanceof String)) continue;
            String propertyKey = (String)uncastObject;
            if (propertyKey.startsWith("hibernate.ejb.classcache")) {
                this.setCacheStrategy(propertyKey, preparedProperties, true, workingVars);
                continue;
            }
            if (propertyKey.startsWith("hibernate.ejb.collectioncache")) {
                this.setCacheStrategy(propertyKey, preparedProperties, false, workingVars);
                continue;
            }
            if (!propertyKey.startsWith("hibernate.jacc") || propertyKey.equals("hibernate.jacc.ctx.id") || propertyKey.equals("hibernate.jacc.enabled")) continue;
            jaccKeys.add(propertyKey);
        }
        if (preparedProperties.containsKey("hibernate.ejb.interceptor") && (this.cfg.getInterceptor() == null || this.cfg.getInterceptor().equals(defaultInterceptor))) {
            String interceptorName = preparedProperties.getProperty("hibernate.ejb.interceptor");
            try {
                Class interceptor = this.classForName(interceptorName);
                this.cfg.setInterceptor((Interceptor)interceptor.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to find interceptor class: " + interceptorName, e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to access interceptor class: " + interceptorName, e);
            }
            catch (InstantiationException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to instanciate interceptor class: " + interceptorName, e);
            }
            catch (ClassCastException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Interceptor class does not implement Interceptor interface: " + interceptorName, e);
            }
        }
        if (preparedProperties.containsKey("hibernate.ejb.naming_strategy") && (this.cfg.getNamingStrategy() == null || this.cfg.getNamingStrategy().equals(defaultNamingStrategy))) {
            String namingStrategyName = preparedProperties.getProperty("hibernate.ejb.naming_strategy");
            try {
                Class namingStragegy = this.classForName(namingStrategyName);
                this.cfg.setNamingStrategy((NamingStrategy)namingStragegy.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to find naming strategy class: " + namingStrategyName, e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to access naming strategy class: " + namingStrategyName, e);
            }
            catch (InstantiationException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Unable to instanciate naming strategy class: " + namingStrategyName, e);
            }
            catch (ClassCastException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Naming strategyy class does not implement NmaingStrategy interface: " + namingStrategyName, e);
            }
        }
        if (jaccKeys.size() > 0) {
            this.addSecurity(jaccKeys, preparedProperties, workingVars);
        }
        this.listenerConfigurator.setProperties(preparedProperties);
        this.listenerConfigurator.configure();
        if (!"true".equalsIgnoreCase(this.cfg.getProperty("hibernate.connection.autocommit"))) {
            this.log.warn("{} = false break the EJB3 specification", (Object)"hibernate.connection.autocommit");
        }
        this.discardOnClose = preparedProperties.getProperty("hibernate.ejb.discard_pc_on_close").equals("true");
        return this;
    }

    private void addClassesToSessionFactory(Map workingVars) {
        if (workingVars.containsKey("hibernate.ejb.classes")) {
            Collection classNames = (Collection)workingVars.get("hibernate.ejb.classes");
            this.addNamedAnnotatedClasses(this, classNames, workingVars);
        }
        if (workingVars.containsKey("hibernate.ejb.loaded.classes")) {
            Collection classes = (Collection)workingVars.get("hibernate.ejb.loaded.classes");
            for (Class clazz : classes) {
                this.cfg.addAnnotatedClass(clazz);
            }
        }
        if (workingVars.containsKey("hibernate.ejb.packages")) {
            Collection packages = (Collection)workingVars.get("hibernate.ejb.packages");
            for (String pkg : packages) {
                this.cfg.addPackage(pkg);
            }
        }
        if (workingVars.containsKey("hibernate.ejb.xml_files")) {
            Collection xmlFiles = (Collection)workingVars.get("hibernate.ejb.xml_files");
            for (String xmlFile : xmlFiles) {
                Boolean useMetaInf = null;
                try {
                    if (xmlFile.endsWith(META_INF_ORM_XML)) {
                        useMetaInf = true;
                    }
                    this.cfg.addResource(xmlFile);
                }
                catch (MappingNotFoundException e) {
                    if (!xmlFile.endsWith(META_INF_ORM_XML)) {
                        throw new PersistenceException(this.getExceptionHeader() + "Unable to find XML mapping file in classpath: " + xmlFile);
                    }
                    useMetaInf = false;
                }
                catch (MappingException me) {
                    throw new PersistenceException(this.getExceptionHeader() + "Error while reading JPA XML file: " + xmlFile, me);
                }
                if (!this.log.isInfoEnabled()) continue;
                if (Boolean.TRUE.equals(useMetaInf)) {
                    this.log.info("{} {} found", (Object)this.getExceptionHeader(), (Object)META_INF_ORM_XML);
                    continue;
                }
                if (!Boolean.FALSE.equals(useMetaInf)) continue;
                this.log.info("{} No {} found", (Object)this.getExceptionHeader(), (Object)META_INF_ORM_XML);
            }
        }
        if (workingVars.containsKey("hibernate.hbmxml.files")) {
            Collection hbmXmlFiles = (Collection)workingVars.get("hibernate.hbmxml.files");
            for (NamedInputStream is : hbmXmlFiles) {
                try {
                    this.cfg.addInputStream(new BufferedInputStream(is.getStream()));
                }
                catch (MappingException me) {
                    if (StringHelper.isEmpty(is.getName())) {
                        throw me;
                    }
                    throw new MappingException("Error while parsing file: " + is.getName(), me);
                }
            }
        }
    }

    private String getExceptionHeader() {
        if (StringHelper.isNotEmpty(this.persistenceUnitName)) {
            return "[PersistenceUnit: " + this.persistenceUnitName + "] ";
        }
        return "";
    }

    private Properties prepareProperties(Properties properties, Map workingVars) {
        Properties preparedProperties = new Properties();
        preparedProperties.setProperty("hibernate.connection.release_mode", "auto");
        preparedProperties.setProperty("hibernate.query.jpaql_strict_compliance", "true");
        preparedProperties.setProperty("hibernate.connection.autocommit", "true");
        preparedProperties.setProperty("hibernate.use_identifier_rollback", "false");
        preparedProperties.setProperty("hibernate.transaction.flush_before_completion", "false");
        preparedProperties.setProperty("hibernate.ejb.discard_pc_on_close", "false");
        if (this.cfgXmlResource != null) {
            preparedProperties.setProperty("hibernate.ejb.cfgfile", this.cfgXmlResource);
            this.cfgXmlResource = null;
        }
        if (this.cfg.getProperties() != null) {
            preparedProperties.putAll((Map<?, ?>)this.cfg.getProperties());
        }
        if (properties != null) {
            preparedProperties.putAll((Map<?, ?>)properties);
        }
        if (this.transactionType == null) {
            this.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        this.defineTransactionType(preparedProperties.getProperty("javax.persistence.transactionType"), workingVars);
        boolean hasTxStrategy = StringHelper.isNotEmpty(preparedProperties.getProperty("hibernate.transaction.factory_class"));
        if (!hasTxStrategy && this.transactionType == PersistenceUnitTransactionType.JTA) {
            preparedProperties.setProperty("hibernate.transaction.factory_class", JoinableCMTTransactionFactory.class.getName());
        } else if (!hasTxStrategy && this.transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            preparedProperties.setProperty("hibernate.transaction.factory_class", JDBCTransactionFactory.class.getName());
        }
        if (hasTxStrategy) {
            this.log.warn("Overriding {} is dangerous, this might break the EJB3 specification implementation", (Object)"hibernate.transaction.factory_class");
        }
        if (preparedProperties.getProperty("hibernate.transaction.flush_before_completion").equals("true")) {
            preparedProperties.setProperty("hibernate.transaction.flush_before_completion", "false");
            this.log.warn("Defining {}=true ignored in HEM", (Object)"hibernate.transaction.flush_before_completion");
        }
        return preparedProperties;
    }

    private Class classForName(String className) throws ClassNotFoundException {
        return ReflectHelper.classForName(className, this.getClass());
    }

    private void setCacheStrategy(String propertyKey, Map properties, boolean isClass, Map workingVars) {
        String role = propertyKey.substring((isClass ? "hibernate.ejb.classcache".length() : "hibernate.ejb.collectioncache".length()) + 1);
        String value = (String)properties.get(propertyKey);
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            error.append(isClass ? "hibernate.ejb.classcache" : "hibernate.ejb.collectioncache");
            error.append(": ").append(propertyKey).append(" ").append(value);
            throw new PersistenceException(this.getExceptionHeader() + error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        if (isClass) {
            boolean lazyProperty = true;
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
            this.cfg.setCacheConcurrencyStrategy(role, usage, region, lazyProperty);
        } else {
            this.cfg.setCollectionCacheConcurrencyStrategy(role, usage, region);
        }
    }

    private void addSecurity(List<String> keys, Map properties, Map workingVars) {
        this.log.debug("Adding security");
        if (!properties.containsKey("hibernate.jacc.ctx.id")) {
            throw new PersistenceException(this.getExceptionHeader() + "Entities have been configured for JACC, but " + "hibernate.jacc.ctx.id" + " has not been set");
        }
        String contextId = (String)properties.get("hibernate.jacc.ctx.id");
        this.setProperty("hibernate.jacc_context_id", contextId);
        int roleStart = "hibernate.jacc".length() + 1;
        for (String key : keys) {
            JACCConfiguration jaccCfg = new JACCConfiguration(contextId);
            try {
                String role = key.substring(roleStart, key.indexOf(46, roleStart));
                int classStart = roleStart + role.length() + 1;
                String clazz = key.substring(classStart, key.length());
                String actions = (String)properties.get(key);
                jaccCfg.addPermission(role, clazz, actions);
            }
            catch (IndexOutOfBoundsException e) {
                throw new PersistenceException(this.getExceptionHeader() + "Illegal usage of " + "hibernate.jacc" + ": " + key);
            }
        }
    }

    private void addNamedAnnotatedClasses(Ejb3Configuration cfg, Collection<String> classNames, Map workingVars) {
        for (String name : classNames) {
            try {
                Class clazz = this.classForName(name);
                cfg.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Package pkg;
                try {
                    pkg = this.classForName(name + ".package-info").getPackage();
                }
                catch (ClassNotFoundException e) {
                    pkg = null;
                }
                if (pkg == null) {
                    throw new PersistenceException(this.getExceptionHeader() + "class or package not found", cnfe);
                }
                cfg.addPackage(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings buildSettings() throws HibernateException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            Settings settings = this.settingsFactory.buildSettings(this.cfg.getProperties());
            return settings;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Ejb3Configuration addProperties(Properties props) {
        this.cfg.addProperties(props);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addAnnotatedClass(Class persistentClass) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addAnnotatedClass(persistentClass);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Ejb3Configuration configure(String resource) throws HibernateException {
        if (this.cfgXmlResource != null) {
            throw new PersistenceException("configure(String) method already called for " + this.cfgXmlResource);
        }
        this.cfgXmlResource = resource;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addPackage(String packageName) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addPackage(packageName);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addFile(String xmlFile) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addFile(xmlFile);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addClass(Class persistentClass) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addClass(persistentClass);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addFile(File xmlFile) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addFile(xmlFile);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildMappings() {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.buildMappings();
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getClassMappings() {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            Iterator iterator = this.cfg.getClassMappings();
            return iterator;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public EventListeners getEventListeners() {
        return this.cfg.getEventListeners();
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        return this.cfg.buildSessionFactory();
    }

    public Iterator getTableMappings() {
        return this.cfg.getTableMappings();
    }

    public PersistentClass getClassMapping(String persistentClass) {
        return this.cfg.getClassMapping(persistentClass);
    }

    public org.hibernate.mapping.Collection getCollectionMapping(String role) {
        return this.cfg.getCollectionMapping(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.cfg.setEntityResolver(entityResolver);
    }

    public Map getNamedQueries() {
        return this.cfg.getNamedQueries();
    }

    public Interceptor getInterceptor() {
        return this.cfg.getInterceptor();
    }

    public Properties getProperties() {
        return this.cfg.getProperties();
    }

    public Ejb3Configuration setInterceptor(Interceptor interceptor) {
        this.cfg.setInterceptor(interceptor);
        return this;
    }

    public Ejb3Configuration setProperties(Properties properties) {
        this.cfg.setProperties(properties);
        return this;
    }

    public Map getFilterDefinitions() {
        return this.cfg.getFilterDefinitions();
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.cfg.addFilterDefinition(definition);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        this.cfg.addAuxiliaryDatabaseObject(object);
    }

    public NamingStrategy getNamingStrategy() {
        return this.cfg.getNamingStrategy();
    }

    public Ejb3Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.cfg.setNamingStrategy(namingStrategy);
        return this;
    }

    public void setListeners(String type, String[] listenerClasses) {
        this.cfg.setListeners(type, listenerClasses);
    }

    public void setListeners(String type, Object[] listeners) {
        this.cfg.setListeners(type, listeners);
    }

    public AnnotationConfiguration getHibernateConfiguration() {
        return this.cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addInputStream(xmlInputStream);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ejb3Configuration addResource(String path) throws MappingException {
        Thread thread = null;
        ClassLoader contextClassLoader = null;
        if (this.overridenClassLoader != null) {
            thread = Thread.currentThread();
            contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.overridenClassLoader);
        }
        try {
            this.cfg.addResource(path);
            Ejb3Configuration ejb3Configuration = this;
            return ejb3Configuration;
        }
        finally {
            if (thread != null) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Ejb3Configuration addResource(String path, ClassLoader classLoader) throws MappingException {
        this.cfg.addResource(path, classLoader);
        return this;
    }

    static {
        Version.touch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum XML_SEARCH {
        HBM,
        ORM_XML,
        BOTH,
        NONE;


        public static XML_SEARCH getType(boolean searchHbm, boolean searchOrm) {
            return searchHbm ? (searchOrm ? BOTH : HBM) : (searchOrm ? ORM_XML : NONE);
        }
    }

    private static class Ejb3EntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        private Ejb3EntityNotFoundDelegate() {
        }

        public void handleEntityNotFound(String entityName, Serializable id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }
}

