/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.Support;

class ParamInfo {
    int tdsType = 0;
    int jdbcType = 0;
    public String name = null;
    String sqlType = null;
    public int markerPos = -1;
    Object value = null;
    int bufferSize = 0;
    int precision = -1;
    int scale = -1;
    int length = -1;
    boolean isOutput = false;
    boolean isRetVal = false;
    boolean isSet = false;
    boolean isUnicode = true;
    byte[] collation = null;

    ParamInfo() {
    }

    ParamInfo(ParamInfo pi) {
        this.bufferSize = pi.bufferSize;
        this.collation = pi.collation;
        this.isOutput = pi.isOutput;
        this.isRetVal = pi.isRetVal;
        this.isSet = pi.isSet;
        this.isUnicode = pi.isUnicode;
        this.jdbcType = pi.jdbcType;
        this.length = pi.length;
        this.markerPos = pi.markerPos;
        this.name = pi.name;
        this.precision = pi.precision;
        this.scale = pi.scale;
        this.sqlType = pi.sqlType;
        this.tdsType = pi.tdsType;
        this.value = pi.value;
    }

    ParamInfo(int pos) {
        this.markerPos = pos;
    }

    String getString(String charset) throws SQLException, IOException {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof InputStream) {
            try {
                this.value = ParamInfo.loadFromReader(new InputStreamReader((InputStream)this.value, charset), this.length);
                this.length = ((String)this.value).length();
                return (String)this.value;
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("I/O Error: UnsupportedEncodingException: " + e.getMessage());
            }
        }
        if (this.value instanceof Reader) {
            this.value = ParamInfo.loadFromReader((Reader)this.value, this.length);
            return (String)this.value;
        }
        return this.value.toString();
    }

    byte[] getBytes(String charset) throws SQLException, IOException {
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        if (this.value instanceof InputStream) {
            this.value = ParamInfo.loadFromStream((InputStream)this.value, this.length);
            return (byte[])this.value;
        }
        if (this.value instanceof Reader) {
            String tmp = ParamInfo.loadFromReader((Reader)this.value, this.length);
            this.value = tmp.getBytes();
            return (byte[])this.value;
        }
        if (this.value instanceof String) {
            return Support.encodeString(charset, (String)this.value);
        }
        return new byte[0];
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] loadFromStream(InputStream in, int length) throws IOException {
        int res;
        byte[] buf = new byte[length];
        int pos = 0;
        while (pos != length && (res = in.read(buf, pos, length - pos)) != -1) {
            void var4_4;
            pos += var4_4;
        }
        if (pos != length) {
            throw new IOException("Data in stream less than specified by length");
        }
        if (in.read() >= 0) {
            throw new IOException("More data in stream than specified by length");
        }
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    private static String loadFromReader(Reader in, int length) throws IOException {
        int res;
        char[] buf = new char[length];
        int pos = 0;
        while (pos != length && (res = in.read(buf, pos, length - pos)) != -1) {
            void var4_4;
            pos += var4_4;
        }
        if (pos != length) {
            throw new IOException("Data in stream less than specified by length");
        }
        if (in.read() >= 0) {
            throw new IOException("More data in stream than specified by length");
        }
        return new String(buf);
    }
}

