/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.business;

import br.gov.lexml.LexMLConfig;
import br.gov.lexml.borda.business.AbstractBO;
import br.gov.lexml.borda.dao.RegistroItemDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.borda.helper.BOHelper;
import br.gov.lexml.coleta.validador.TipoErroValidacao;
import br.gov.lexml.coleta.validador.ValidadorRegistroItem;
import br.gov.lexml.coleta.validador.ValidadorService;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ValidadorBO
extends AbstractBO
implements ValidadorService {
    private static Logger logger = Logger.getLogger(ValidadorBO.class.getName());
    private static int BUCKET_SIZE = 1000;
    private List<RegistroItemErro> errosList = new ArrayList<RegistroItemErro>();
    private List<RegistroItem> atualizados = new ArrayList<RegistroItem>();
    private final RegistroItemDAO dao;
    private final LexMLConfig config;
    private final BOHelper helper;
    private Set<String> nucleosValidos;
    private final ValidadorRegistroItem validador;
    private final Map<TipoErroValidacao, TipoErro> mapErros = new HashMap<TipoErroValidacao, TipoErro>();

    public ValidadorBO() throws ConfigFailedException {
        this.helper = BOHelper.getInstance();
        this.config = LexMLConfig.getInstance();
        this.dao = new RegistroItemDAO();
        this.validador = new ValidadorRegistroItem();
        this.validador.setValidadorService(this);
        this.mapErros.put(TipoErroValidacao.ERRO_GENERICO, this.helper.ERRO_GENERICO.tipo);
        this.mapErros.put(TipoErroValidacao.URN_INCOMPATIVEL, this.helper.ERRO_URN_INCOMPATIVEL.tipo);
        this.mapErros.put(TipoErroValidacao.URN_INVALIDO, this.helper.ERRO_URN_INVALIDO.tipo);
        this.mapErros.put(TipoErroValidacao.URN_MAL_FORMADO, this.helper.ERRO_URN_MAL_FORMADO.tipo);
        this.mapErros.put(TipoErroValidacao.XML_INVALIDO, this.helper.ERRO_XML_INVALIDO.tipo);
        this.mapErros.put(TipoErroValidacao.XML_MAL_FORMADO, this.helper.ERRO_XML_MAL_FORMADO.tipo);
        this.compilarPerfisValidos();
    }

    public boolean validarRegistroItem(RegistroItem ri, CorretorRegistroAntigo corretor) {
        Object doc = null;
        if (null == ri) {
            logger.error("RV#4 Objeto RegistroItem ri passado \u00e9 nulo");
            return false;
        }
        this.dao.deleteRegistroItemErro(ri);
        ri.setCdValidacao("E");
        String xml = corretor.corrigeRegistro(ri.getTxMetadadoXml());
        if (this.validador.validar(ri.getIdRegistroItem(), xml, ri)) {
            ri.setCdValidacao("O");
            return true;
        }
        return false;
    }

    public void validarRegistrosIndefinidos() {
        double per;
        String ultimoId;
        if (null == this.config) {
            logger.fatal("Ambiente nao configurado, verifique arquivo de configuracao:lexml_nbconfig.xml");
            return;
        }
        List<RegistroItem> list = this.dao.listNotValid(null, BUCKET_SIZE);
        if (list.isEmpty()) {
            logger.warn("N\u00e3o havia registros indefinidos para serem validados");
            return;
        }
        long total = this.dao.countNotValid();
        logger.info("Come\u00e7ando a validar " + total + " registros.");
        long sucessos = 0L;
        long erros = 0L;
        DecimalFormat df = new DecimalFormat("#00.0");
        CorretorRegistroAntigo corretor = new CorretorRegistroAntigo();
        do {
            this.dao.beginTransaction();
            for (RegistroItem ri : list) {
                if (this.validarRegistroItem(ri, corretor)) {
                    ++sucessos;
                } else {
                    ++erros;
                }
                this.atualizados.add(ri);
            }
            this.saveLists();
            long subtotal = sucessos + erros;
            per = (float)subtotal * 100.0f / (float)total;
            logger.info("... " + subtotal + " (" + df.format(per) + "%)");
        } while (!(list = this.dao.listNotValid(ultimoId = list.get(list.size() - 1).getIdRegistroItem(), BUCKET_SIZE)).isEmpty());
        if (corretor.qtdRegistrosAntigos > 0) {
            logger.warn("-----------------------------------");
            logger.warn("Foram encontrados " + corretor.qtdRegistrosAntigos + " registros em formato antigo. " + "Veja o arquivo correcao-schema.txt");
        }
        logger.info("-----------------------------------");
        logger.info("Total de registros processados: " + total);
        logger.info("Processados com sucesso: " + sucessos);
        logger.info("Registros com erros: " + erros);
        per = (float)sucessos * 100.0f / (float)total;
        String strPer = df.format(per);
        logger.info("Aproveitamento de " + strPer + "%");
        System.gc();
    }

    private void saveLists() {
        logger.debug("Iniciando COMMIT");
        logger.debug("de " + this.atualizados.size() + " registroItem");
        this.dao.updateCdValidacao(this.atualizados);
        this.atualizados = new ArrayList<RegistroItem>();
        logger.debug("de " + this.errosList.size() + " registroItemErro");
        this.dao.saveList(this.errosList);
        this.errosList = new ArrayList<RegistroItemErro>();
        this.dao.commit();
        this.dao.clear();
        System.gc();
        this.dao.beginTransaction();
        logger.debug("Commit finalizado.");
    }

    public boolean isNucleoValido(String nucleo) {
        return this.nucleosValidos.contains(nucleo);
    }

    public void logError(String idRegistroItem, TipoErroValidacao tipoErroValidacao, String msg, Object ctx) {
        RegistroItem ri = (RegistroItem)ctx;
        TipoErro te = this.mapErros.get((Object)tipoErroValidacao);
        RegistroItemErro erro = new RegistroItemErro(ri, te, msg);
        logger.error("[" + idRegistroItem + "] " + te.getNoTipoErro());
        logger.error(msg);
        this.errosList.add(erro);
    }

    private void compilarPerfisValidos() {
        if (null != this.nucleosValidos) {
            return;
        }
        this.nucleosValidos = new HashSet<String>();
        for (LexMLConfig.Publicador publicador : this.config.getPublicadores()) {
            BigInteger idPublicador = publicador.getIdPublicador();
            ArrayList<LexMLConfig.Perfil> perfis = publicador.getPerfil();
            if (null == perfis) continue;
            for (LexMLConfig.Perfil perfil : perfis) {
                String nucleo = perfil.getNucleoUrn();
                String tipoPerfil = perfil.getTipoPerfil();
                if (tipoPerfil.equals("T")) {
                    this.nucleosValidos.add(idPublicador + ":" + "D" + ":" + nucleo);
                    this.nucleosValidos.add(idPublicador + ":" + "R" + ":" + nucleo);
                    continue;
                }
                this.nucleosValidos.add(idPublicador + ":" + tipoPerfil + ":" + nucleo);
            }
        }
        logger.debug("TOTAL DE " + this.nucleosValidos.size() + " PERFIS ADICIONADOS");
    }

    private class CorretorRegistroAntigo {
        public int qtdRegistrosAntigos;

        private CorretorRegistroAntigo() {
        }

        public String corrigeRegistro(String xml) {
            if (xml != null && xml.contains("<lexml:LexML") && xml.contains("<DocumentoIndividual")) {
                ++this.qtdRegistrosAntigos;
                xml = StringUtils.replace(xml, "<lexml:", "<");
                xml = StringUtils.replace(xml, "</lexml:", "</");
                xml = StringUtils.replace(xml, "xmlns:lexml=", "xmlns=");
            }
            return xml;
        }
    }
}

