/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.domain.ConjuntoItem;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.TipoErro;
import br.gov.lexml.exceptions.ConfigFailedException;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.log4j.Logger;
import org.hibernate.ejb.Ejb3Configuration;

public class EMFFactory {
    private static Logger logger = Logger.getLogger(EMFFactory.class.getName());
    private static EntityManagerFactory emf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final EntityManagerFactory getEMF(Properties properties) {
        if (null != emf) {
            return emf;
        }
        logger.debug("Criando EntityManagerFactory para a Persistence Unit: borda-db");
        Class<EMFFactory> clazz = EMFFactory.class;
        synchronized (EMFFactory.class) {
            if (emf != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return emf;
            }
            if (null == properties) {
                logger.error("Properties passado \u00e9 nulo");
            } else {
                Ejb3Configuration cfg = new Ejb3Configuration();
                properties.put("hibernate.transaction.factory_class", (Object)PersistenceUnitTransactionType.RESOURCE_LOCAL);
                cfg.addProperties(properties).addAnnotatedClass(RegistroItem.class).addAnnotatedClass(RegistroItemErro.class).addAnnotatedClass(TipoErro.class).addAnnotatedClass(ConjuntoItem.class);
                emf = cfg.buildEntityManagerFactory();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (null == emf) {
                logger.error("N\u00e3o foi possivel criar EntityManagerFactory.");
            }
            return emf;
        }
    }

    public static final EntityManagerFactory getEMF() throws ConfigFailedException {
        return EMFFactory.getEMF(LexMLUtil.getJPAProperties());
    }
}

