/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.install;

import br.gov.lexml.borda.install.PassoInstalacao;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GerenteInstalacao<K> {
    private List<PassoInstalacao<K>> passos = new ArrayList<PassoInstalacao<K>>();
    private K contexto;

    public GerenteInstalacao(K contexto) {
        this.contexto = contexto;
    }

    public void executa() throws Exception {
        PassoInstalacao<K> passo = null;
        if (!this.passos.isEmpty()) {
            passo = this.passos.get(0);
        }
        while (passo != null) {
            String nomeProximo = passo.executa();
            passo = this.getProximo(passo, nomeProximo);
        }
    }

    private PassoInstalacao<K> getProximo(PassoInstalacao<K> passoAtual, String nomeProximo) {
        if (nomeProximo != null) {
            for (PassoInstalacao<K> passo : this.passos) {
                if (!nomeProximo.equals(passo.getNome())) continue;
                return passo;
            }
        } else {
            int i = 0;
            for (PassoInstalacao<K> passo : this.passos) {
                if (passoAtual.equals(passo)) break;
                ++i;
            }
            if (++i < this.passos.size()) {
                return this.passos.get(i);
            }
        }
        return null;
    }

    public GerenteInstalacao<K> addPasso(PassoInstalacao<K> passo) {
        passo.setContexto(this.contexto);
        this.passos.add(passo);
        return this;
    }
}

