/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CascadingAction {
    private static final Logger log = LoggerFactory.getLogger(CascadingAction.class);
    public static final CascadingAction DELETE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to delete: " + entityName);
            }
            session.delete(entityName, child, isCascadeDeleteEnabled, (Set)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getAllElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public String toString() {
            return "ACTION_DELETE";
        }
    };
    public static final CascadingAction LOCK = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to lock: " + entityName);
            }
            session.lock(entityName, child, LockMode.NONE);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 2.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_LOCK";
        }
    };
    public static final CascadingAction REFRESH = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to refresh: " + entityName);
            }
            session.refresh(child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 3.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REFRESH";
        }
    };
    public static final CascadingAction EVICT = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to evict: " + entityName);
            }
            session.evict(child);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 4.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_EVICT";
        }
    };
    public static final CascadingAction SAVE_UPDATE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to saveOrUpdate: " + entityName);
            }
            session.saveOrUpdate(entityName, child);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 5.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE";
        }
    };
    public static final CascadingAction MERGE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to merge: " + entityName);
            }
            session.merge(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 6.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_MERGE";
        }
    };
    public static final CascadingAction SAVE_UPDATE_COPY = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to saveOrUpdateCopy: " + entityName);
            }
            session.saveOrUpdateCopy(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 7.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_SAVE_UPDATE_COPY";
        }
    };
    public static final CascadingAction PERSIST = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to persist: " + entityName);
            }
            session.persist(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getAllElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        public String toString() {
            return "ACTION_PERSIST";
        }
    };
    public static final CascadingAction PERSIST_ON_FLUSH = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to persistOnFlush: " + entityName);
            }
            session.persistOnFlush(entityName, child, (Map)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return CascadingAction.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return true;
        }

        public boolean requiresNoCascadeChecking() {
            return true;
        }

        public void noCascade(EventSource session, Object child, Object parent, EntityPersister persister, int propertyIndex) {
            if (child == null) {
                return;
            }
            Type type = persister.getPropertyTypes()[propertyIndex];
            if (type.isEntityType()) {
                String childEntityName = ((EntityType)type).getAssociatedEntityName(session.getFactory());
                if (!this.isInManagedState(child, session) && !(child instanceof HibernateProxy) && ForeignKeys.isTransient(childEntityName, child, null, session)) {
                    String parentEntiytName = persister.getEntityName();
                    String propertyName = persister.getPropertyNames()[propertyIndex];
                    throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + parentEntiytName + "." + propertyName + " -> " + childEntityName);
                }
            }
        }

        public boolean performOnLazyProperty() {
            return false;
        }

        private boolean isInManagedState(Object child, EventSource session) {
            EntityEntry entry = session.getPersistenceContext().getEntry(child);
            return entry != null && (entry.getStatus() == Status.MANAGED || entry.getStatus() == Status.READ_ONLY);
        }

        public String toString() {
            return "ACTION_PERSIST_ON_FLUSH";
        }
    };
    public static final CascadingAction REPLICATE = new CascadingAction(){

        public void cascade(EventSource session, Object child, String entityName, Object anything, boolean isCascadeDeleteEnabled) throws HibernateException {
            if (log.isTraceEnabled()) {
                log.trace("cascading to replicate: " + entityName);
            }
            session.replicate(entityName, child, (ReplicationMode)anything);
        }

        public Iterator getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return 10.getLoadedElementsIterator(session, collectionType, collection);
        }

        public boolean deleteOrphans() {
            return false;
        }

        public String toString() {
            return "ACTION_REPLICATE";
        }
    };

    CascadingAction() {
    }

    public abstract void cascade(EventSource var1, Object var2, String var3, Object var4, boolean var5) throws HibernateException;

    public abstract Iterator getCascadableChildrenIterator(EventSource var1, CollectionType var2, Object var3);

    public abstract boolean deleteOrphans();

    public boolean requiresNoCascadeChecking() {
        return false;
    }

    public void noCascade(EventSource session, Object child, Object parent, EntityPersister persister, int propertyIndex) {
    }

    public boolean performOnLazyProperty() {
        return true;
    }

    private static Iterator getAllElementsIterator(EventSource session, CollectionType collectionType, Object collection) {
        return collectionType.getElementsIterator(collection, session);
    }

    public static Iterator getLoadedElementsIterator(SessionImplementor session, CollectionType collectionType, Object collection) {
        if (CascadingAction.collectionIsInitialized(collection)) {
            return collectionType.getElementsIterator(collection, session);
        }
        return ((PersistentCollection)collection).queuedAdditionIterator();
    }

    private static boolean collectionIsInitialized(Object collection) {
        return !(collection instanceof PersistentCollection) || ((PersistentCollection)collection).wasInitialized();
    }
}

