/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

public class LexMLLocalEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean {
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Building JPA EntityManagerFactory for persistence unit '" + this.getPersistenceUnitName() + "'");
        }
        Properties properties = LexMLUtil.getJPAProperties();
        Map props = this.getJpaPropertyMap();
        props.putAll(properties);
        PersistenceProvider provider = this.getPersistenceProvider();
        if (provider != null) {
            EntityManagerFactory emf = provider.createEntityManagerFactory(this.getPersistenceUnitName(), props);
            if (emf == null) {
                throw new IllegalStateException("PersistenceProvider [" + provider + "] did not return an EntityManagerFactory for name '" + this.getPersistenceUnitName() + "'");
            }
            return emf;
        }
        return Persistence.createEntityManagerFactory(this.getPersistenceUnitName(), this.getJpaPropertyMap());
    }
}

