/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.borda.dao;

import br.gov.lexml.LexMLUtil;
import br.gov.lexml.borda.dao.AbstractDAO;
import br.gov.lexml.borda.domain.RegistroItem;
import br.gov.lexml.borda.domain.RegistroItemErro;
import br.gov.lexml.borda.domain.RegistroItemLog;
import br.gov.lexml.borda.domain.TipoErro;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceUnit;
import javax.persistence.Query;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class RegistroItemDAO
extends AbstractDAO {
    private static final Logger logger = Logger.getLogger(RegistroItemDAO.class.getName());
    @PersistenceUnit(unitName="borda-db")
    private EntityManagerFactory m_emf = null;

    public void setEntityManagerFactory(EntityManagerFactory p_emf) throws Exception {
        this.m_emf = p_emf;
        EntityManager em = this.getEntityManager(this.m_emf);
        if (em == null) {
            logger.log(Level.ERROR, "EntityManager nulo ap\u00f3s um setEntityManagerFactory");
        }
    }

    public List<RegistroItem> listByTimeWindow(Date from, Date until) {
        EntityManager em = this.getEntityManager(this.m_emf);
        if (until == null) {
            until = new Date();
        }
        if (from == null) {
            from = new Date(0L);
        }
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri WHERE ri.cdValidacao ='O' AND ri.tsRegistroGmt <=:puntil AND ri.tsRegistroGmt >=:pfrom ");
        query.setParameter("pfrom", (Object)from);
        query.setParameter("puntil", (Object)until);
        return query.getResultList();
    }

    public List<RegistroItem> listUndefined() {
        EntityManager em = this.getEntityManager(this.m_emf);
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri WHERE ri.cdValidacao !=:ok");
        query.setParameter("ok", (Object)"O");
        return query.getResultList();
    }

    public RegistroItem load(String identifier) {
        EntityManager em = this.getEntityManager(this.m_emf);
        Query query = em.createQuery("SELECT ri FROM RegistroItem ri WHERE ri.idRegistroItem =:rid ");
        query.setParameter("rid", (Object)identifier);
        try {
            return (RegistroItem)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RegistroItemErro newLogErr(RegistroItem p_ri, TipoErro p_te, String p_detalhe_erro) {
        RegistroItemErro erro = new RegistroItemErro();
        erro.setIdRegistroItem(p_ri);
        if (p_detalhe_erro == null) {
            p_detalhe_erro = "sem detalhe";
        }
        erro.setDeDetalheItemErro(p_detalhe_erro);
        erro.setTsRegistroGmt(p_ri.getTsRegistroGmt());
        erro.setIdTipoErro(p_te);
        return erro;
    }

    public RegistroItemLog newLogMsg(RegistroItem p_ri, String p_msg) {
        RegistroItemLog log = new RegistroItemLog();
        this.timeStamp(log);
        log.setIdRegistroItem(p_ri);
        log.setDeMensagem(p_msg);
        log.setTsRegistroGmt(p_ri.getTsRegistroGmt());
        return log;
    }

    public boolean oaiDelete(RegistroItem ri) {
        ri.setCdStatus("D");
        return this.update(ri);
    }

    public boolean save(RegistroItem p_ri) {
        this.timeStamp(p_ri);
        if (this.inBulkMode()) {
            this.bulkPersist(p_ri);
        } else {
            EntityManager em = this.getEntityManager(this.m_emf);
            em.getTransaction().begin();
            em.persist(p_ri);
            em.getTransaction().commit();
        }
        return true;
    }

    public boolean saveOrUpdate(RegistroItem p_ri) {
        EntityManager em = this.getEntityManager(this.m_emf);
        RegistroItem ri = em.find(RegistroItem.class, p_ri.getIdRegistroItem());
        if (ri == null) {
            return this.save(p_ri);
        }
        return this.update(p_ri);
    }

    public boolean save(RegistroItemErro p_rie) {
        if (this.inBulkMode()) {
            this.bulkPersist(p_rie);
        } else {
            EntityManager em = this.getEntityManager(this.m_emf);
            em.getTransaction().begin();
            em.persist(p_rie);
            em.getTransaction().commit();
        }
        return true;
    }

    public boolean save(RegistroItemLog p_ril) {
        this.timeStamp(p_ril);
        if (this.inBulkMode()) {
            this.bulkPersist(p_ril);
        } else {
            EntityManager em = this.getEntityManager(this.m_emf);
            em.getTransaction().begin();
            em.persist(p_ril);
            em.getTransaction().commit();
        }
        return true;
    }

    public boolean saveRegistroItemErroList(List<RegistroItemErro> p_list) {
        Iterator<RegistroItemErro> iter = p_list.iterator();
        boolean inBulk = this.inBulkMode();
        if (!inBulk) {
            this.beginBulkMode();
        }
        while (iter.hasNext()) {
            RegistroItemErro rie = iter.next();
            this.timeStamp(rie);
            this.bulkPersist(rie);
        }
        if (!inBulk) {
            this.bulkCommit();
        }
        return true;
    }

    public boolean saveRegistroItemLogList(List<RegistroItemLog> p_list) {
        Iterator<RegistroItemLog> iter = p_list.iterator();
        boolean inBulk = this.inBulkMode();
        if (!inBulk) {
            this.beginBulkMode();
        }
        while (iter.hasNext()) {
            RegistroItemLog ril = iter.next();
            this.timeStamp(ril);
            this.bulkPersist(ril);
        }
        if (!inBulk) {
            this.bulkCommit();
        }
        return true;
    }

    public void timeStamp(RegistroItem p_ri) {
        Timestamp now = new Timestamp(LexMLUtil.nowInMillisGMT());
        p_ri.setTsRegistroGmt(now);
    }

    public void timeStamp(RegistroItemLog p_log) {
        Timestamp now = new Timestamp(LexMLUtil.nowInMillisGMT());
        p_log.setTsProcessamento(now);
    }

    public void timeStamp(RegistroItemErro p_err) {
        Timestamp now = new Timestamp(LexMLUtil.nowInMillisGMT());
        p_err.setTsProcessamento(now);
    }

    public boolean update(List<RegistroItem> p_list) {
        Iterator<RegistroItem> iter = p_list.iterator();
        boolean wasInBulkMode = this.inBulkMode();
        if (!wasInBulkMode) {
            this.beginBulkMode();
        }
        while (iter.hasNext()) {
            RegistroItem ri = iter.next();
            this.timeStamp(ri);
            this.bulkMerge(ri);
        }
        if (!wasInBulkMode) {
            this.bulkCommit();
        }
        return true;
    }

    public final void beginBulkMode() {
        this.beginBulkMode(this.getEntityManager(this.m_emf));
    }

    public boolean update(RegistroItem p_ri) {
        this.timeStamp(p_ri);
        return this.updateObject(p_ri);
    }

    public boolean update(RegistroItemErro p_rie) {
        return this.updateObject(p_rie);
    }

    public boolean update(RegistroItemLog p_ril) {
        this.timeStamp(p_ril);
        return this.updateObject(p_ril);
    }

    private boolean updateObject(Object p_object) {
        if (this.inBulkMode()) {
            this.bulkMerge(p_object);
        } else {
            EntityManager em = this.getEntityManager(this.m_emf);
            em.getTransaction().begin();
            em.merge(p_object);
            em.getTransaction().commit();
        }
        return true;
    }
}

