/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.parser;

import br.gov.lexml.util.StringUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class ParserXmlAbstractImpl {
    protected String getTexto(XMLStreamReader xmlsr, String elemento) throws XMLStreamException {
        if (StringUtil.isVazia(elemento)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        xmlsr.next();
        while (xmlsr.hasNext()) {
            int evento = xmlsr.getEventType();
            switch (evento) {
                case 1: {
                    this.montaTagInicio(buffer, xmlsr);
                    break;
                }
                case 2: {
                    if (elemento.equals(xmlsr.getLocalName())) {
                        return buffer.toString();
                    }
                    this.montaTagFechamento(buffer, xmlsr);
                    break;
                }
                case 4: {
                    String texto = new String(xmlsr.getTextCharacters(), xmlsr.getTextStart(), xmlsr.getTextLength()).replaceAll("\\s{2,}", " ");
                    if (" ".equals(texto)) break;
                    buffer.append(texto);
                }
            }
            xmlsr.next();
        }
        return buffer.toString();
    }

    protected void montaAtributosTag(int index, StringBuffer buffer, XMLStreamReader xmlsr) {
        buffer.append(' ');
        QName qname = xmlsr.getAttributeName(index);
        this.montaNomeTag(qname.getPrefix(), qname.getLocalPart(), buffer);
        buffer.append("=\"");
        buffer.append(xmlsr.getAttributeValue(index));
        buffer.append('\"');
    }

    protected void montaNomeTag(String prefix, String localName, StringBuffer buffer) {
        if (!StringUtil.isVazia(prefix)) {
            buffer.append(prefix);
            buffer.append(':');
        }
        if (!StringUtil.isVazia(localName)) {
            buffer.append(localName);
        }
    }

    protected void montaTagFechamento(StringBuffer buffer, XMLStreamReader xmlsr) {
        buffer.append("</");
        this.montaNomeTag(xmlsr.getPrefix(), xmlsr.getLocalName(), buffer);
        buffer.append('>');
    }

    protected void montaTagInicio(StringBuffer buffer, XMLStreamReader xmlsr) {
        buffer.append('<');
        this.montaNomeTag(xmlsr.getPrefix(), xmlsr.getLocalName(), buffer);
        int qtde = xmlsr.getAttributeCount();
        int i = 0;
        while (i < qtde) {
            this.montaAtributosTag(i, buffer, xmlsr);
            ++i;
        }
        buffer.append('>');
    }
}

