/*
 * Decompiled with CFR 0.152.
 */
package br.gov.lexml.dominio.urn;

import br.gov.lexml.dominio.excecoes.UrnInvalidaException;
import br.gov.lexml.dominio.urn.autoridade.Autoridade;
import br.gov.lexml.dominio.urn.autoridade.AutoridadeNormaHierarquiaSuperiorImpl;
import br.gov.lexml.dominio.urn.data.DataObraComplexa;
import br.gov.lexml.dominio.urn.data.DataObraComplexaImpl;
import br.gov.lexml.dominio.urn.descritor.Descritor;
import br.gov.lexml.dominio.urn.descritor.DescritorImpl;
import br.gov.lexml.dominio.urn.formaconteudo.FormaConteudo;
import br.gov.lexml.dominio.urn.formaconteudo.FormaConteudoImpl;
import br.gov.lexml.dominio.urn.localizacao.Localizacao;
import br.gov.lexml.dominio.urn.localizacao.LocalizacaoImpl;
import br.gov.lexml.dominio.urn.tipoDocumento.DocumentoHierarquiaSuperiorImpl;
import br.gov.lexml.dominio.urn.tipoDocumento.PublicacaoOficialImpl;
import br.gov.lexml.dominio.urn.tipoDocumento.TipoDocumento;
import br.gov.lexml.dominio.urn.versao.VersaoObraIndividual;
import br.gov.lexml.dominio.urn.versao.VersaoObraIndividualImpl;

public class ElementoUrnFactory {
    private static ElementoUrnFactory me = null;

    private ElementoUrnFactory() {
    }

    public static ElementoUrnFactory getInstance() {
        if (me == null) {
            me = new ElementoUrnFactory();
        }
        return me;
    }

    public Autoridade getAutoridade(String texto) throws UrnInvalidaException {
        return new AutoridadeNormaHierarquiaSuperiorImpl(texto);
    }

    public Localizacao getLocalizacao(String texto) throws UrnInvalidaException {
        return new LocalizacaoImpl(texto);
    }

    public Descritor getDescritor(String texto) throws UrnInvalidaException {
        return new DescritorImpl(texto);
    }

    public TipoDocumento getTipoDocumento(String texto) throws UrnInvalidaException {
        if (texto != null && texto.startsWith("publicacao.oficial")) {
            return new PublicacaoOficialImpl(texto);
        }
        return new DocumentoHierarquiaSuperiorImpl(texto);
    }

    public DataObraComplexa getDataObraComplexa(String texto) throws UrnInvalidaException {
        return new DataObraComplexaImpl(texto);
    }

    public FormaConteudo getFormaConteudo(String texto) throws UrnInvalidaException {
        return new FormaConteudoImpl(texto);
    }

    public VersaoObraIndividual getVersaoObraIndividual(String texto) throws UrnInvalidaException {
        return new VersaoObraIndividualImpl(texto);
    }
}

